/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.tomcat.deployment;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarFile;
import javax.transaction.UserTransaction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.deployment.DeploymentContext;
import org.apache.geronimo.deployment.ModuleIDBuilder;
import org.apache.geronimo.deployment.service.EnvironmentBuilder;
import org.apache.geronimo.deployment.service.ServiceConfigBuilder;
import org.apache.geronimo.deployment.util.DeploymentUtil;
import org.apache.geronimo.deployment.xbeans.EnvironmentType;
import org.apache.geronimo.deployment.xbeans.GbeanType;
import org.apache.geronimo.deployment.xmlbeans.XmlBeansUtil;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.AbstractNameQuery;
import org.apache.geronimo.gbean.GBeanData;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.gbean.SingleElementCollection;
import org.apache.geronimo.j2ee.deployment.EARContext;
import org.apache.geronimo.j2ee.deployment.Module;
import org.apache.geronimo.j2ee.deployment.ModuleBuilder;
import org.apache.geronimo.j2ee.deployment.RefContext;
import org.apache.geronimo.j2ee.deployment.WebModule;
import org.apache.geronimo.j2ee.deployment.WebServiceBuilder;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.Naming;
import org.apache.geronimo.kernel.config.Configuration;
import org.apache.geronimo.kernel.config.ConfigurationData;
import org.apache.geronimo.kernel.repository.Environment;
import org.apache.geronimo.naming.deployment.ENCConfigBuilder;
import org.apache.geronimo.naming.deployment.GBeanResourceEnvironmentBuilder;
import org.apache.geronimo.naming.deployment.ResourceEnvironmentBuilder;
import org.apache.geronimo.schema.SchemaConversionUtils;
import org.apache.geronimo.security.deploy.DefaultPrincipal;
import org.apache.geronimo.security.deployment.SecurityBuilder;
import org.apache.geronimo.security.deployment.SecurityConfiguration;
import org.apache.geronimo.security.jacc.ComponentPermissions;
import org.apache.geronimo.tomcat.RealmGBean;
import org.apache.geronimo.tomcat.TomcatWebAppContext;
import org.apache.geronimo.tomcat.util.SecurityHolder;
import org.apache.geronimo.transaction.context.OnlineUserTransaction;
import org.apache.geronimo.web.deployment.AbstractWebModuleBuilder;
import org.apache.geronimo.web.deployment.GenericToSpecificPlanConverter;
import org.apache.geronimo.webservices.WebServiceContainer;
import org.apache.geronimo.xbeans.geronimo.naming.GerEjbLocalRefType;
import org.apache.geronimo.xbeans.geronimo.naming.GerEjbRefType;
import org.apache.geronimo.xbeans.geronimo.naming.GerGbeanLocatorType;
import org.apache.geronimo.xbeans.geronimo.naming.GerGbeanRefType;
import org.apache.geronimo.xbeans.geronimo.naming.GerMessageDestinationType;
import org.apache.geronimo.xbeans.geronimo.naming.GerResourceEnvRefType;
import org.apache.geronimo.xbeans.geronimo.naming.GerResourceRefType;
import org.apache.geronimo.xbeans.geronimo.naming.GerServiceRefType;
import org.apache.geronimo.xbeans.geronimo.security.GerSecurityType;
import org.apache.geronimo.xbeans.geronimo.web.tomcat.TomcatWebAppDocument;
import org.apache.geronimo.xbeans.geronimo.web.tomcat.TomcatWebAppType;
import org.apache.geronimo.xbeans.geronimo.web.tomcat.config.GerTomcatDocument;
import org.apache.geronimo.xbeans.j2ee.EjbLocalRefType;
import org.apache.geronimo.xbeans.j2ee.EjbRefType;
import org.apache.geronimo.xbeans.j2ee.EnvEntryType;
import org.apache.geronimo.xbeans.j2ee.MessageDestinationRefType;
import org.apache.geronimo.xbeans.j2ee.MessageDestinationType;
import org.apache.geronimo.xbeans.j2ee.ResourceEnvRefType;
import org.apache.geronimo.xbeans.j2ee.ResourceRefType;
import org.apache.geronimo.xbeans.j2ee.ServiceRefType;
import org.apache.geronimo.xbeans.j2ee.ServletType;
import org.apache.geronimo.xbeans.j2ee.WebAppDocument;
import org.apache.geronimo.xbeans.j2ee.WebAppType;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;

public class TomcatModuleBuilder
extends AbstractWebModuleBuilder {
    private static final Log log;
    private final Environment defaultEnvironment;
    private final AbstractNameQuery tomcatContainerName;
    private final SingleElementCollection webServiceBuilder;
    private static final String TOMCAT_NAMESPACE;
    public static final GBeanInfo GBEAN_INFO;
    static final /* synthetic */ boolean $assertionsDisabled;

    public TomcatModuleBuilder(Environment defaultEnvironment, AbstractNameQuery tomcatContainerName, Collection webServiceBuilder, Kernel kernel) {
        super(kernel);
        this.defaultEnvironment = defaultEnvironment;
        this.tomcatContainerName = tomcatContainerName;
        this.webServiceBuilder = new SingleElementCollection(webServiceBuilder);
    }

    private WebServiceBuilder getWebServiceBuilder() {
        return (WebServiceBuilder)this.webServiceBuilder.getElement();
    }

    protected Module createModule(Object plan, JarFile moduleFile, String targetPath, URL specDDUrl, boolean standAlone, String contextRoot, AbstractName earName, Naming naming, ModuleIDBuilder idBuilder) throws DeploymentException {
        AbstractName moduleName;
        WebAppType webApp;
        String specDD;
        if (!$assertionsDisabled && moduleFile == null) {
            throw new AssertionError((Object)"moduleFile is null");
        }
        if (!$assertionsDisabled && targetPath == null) {
            throw new AssertionError((Object)"targetPath is null");
        }
        if (!$assertionsDisabled && targetPath.endsWith("/")) {
            throw new AssertionError((Object)"targetPath must not end with a '/'");
        }
        try {
            if (specDDUrl == null) {
                specDDUrl = DeploymentUtil.createJarURL((JarFile)moduleFile, (String)"WEB-INF/web.xml");
            }
            specDD = DeploymentUtil.readAll((URL)specDDUrl);
        }
        catch (Exception e) {
            return null;
        }
        try {
            XmlObject parsed = XmlBeansUtil.parse((String)specDD);
            WebAppDocument webAppDoc = SchemaConversionUtils.convertToServletSchema((XmlObject)parsed);
            webApp = webAppDoc.getWebApp();
        }
        catch (XmlException xmle) {
            throw new DeploymentException("Error parsing web.xml for " + targetPath, (Throwable)xmle);
        }
        TomcatModuleBuilder.check((WebAppType)webApp);
        TomcatWebAppType tomcatWebApp = this.getTomcatWebApp(plan, moduleFile, standAlone, targetPath, webApp);
        if (contextRoot == null || contextRoot.trim().equals("")) {
            contextRoot = tomcatWebApp.isSetContextRoot() ? tomcatWebApp.getContextRoot() : this.determineDefaultContextRoot(webApp, standAlone, moduleFile, targetPath);
        }
        contextRoot = contextRoot.trim();
        EnvironmentType environmentType = tomcatWebApp.getEnvironment();
        Environment environment = EnvironmentBuilder.buildEnvironment((EnvironmentType)environmentType, (Environment)this.defaultEnvironment);
        String warName = new File(moduleFile.getName()).getName();
        if (warName.lastIndexOf(46) > -1) {
            warName = warName.substring(0, warName.lastIndexOf(46));
        }
        idBuilder.resolve(environment, warName, "war");
        Map servletNameToPathMap = this.buildServletNameToPathMap(webApp, contextRoot);
        Map portMap = Collections.EMPTY_MAP;
        try {
            URL wsDDUrl = DeploymentUtil.createJarURL((JarFile)moduleFile, (String)"WEB-INF/webservices.xml");
            portMap = this.getWebServiceBuilder().parseWebServiceDescriptor(wsDDUrl, moduleFile, false, servletNameToPathMap);
        }
        catch (MalformedURLException e) {
            // empty catch block
        }
        if (earName == null) {
            earName = naming.createRootName(environment.getConfigId(), "null", "J2EEApplication");
            moduleName = naming.createChildName(earName, environment.getConfigId().toString(), "WebModule");
        } else {
            moduleName = naming.createChildName(earName, targetPath, "WebModule");
        }
        return new WebModule(standAlone, moduleName, environment, moduleFile, targetPath, (XmlObject)webApp, (XmlObject)tomcatWebApp, specDD, contextRoot, portMap, TOMCAT_NAMESPACE);
    }

    TomcatWebAppType getTomcatWebApp(Object plan, JarFile moduleFile, boolean standAlone, String targetPath, WebAppType webApp) throws DeploymentException {
        XmlObject rawPlan = null;
        try {
            TomcatWebAppType tomcatWebApp;
            block12: {
                try {
                    if (plan instanceof XmlObject) {
                        rawPlan = (XmlObject)plan;
                        break block12;
                    }
                    if (plan != null) {
                        rawPlan = XmlBeansUtil.parse((URL)((File)plan).toURL());
                        break block12;
                    }
                    URL path = DeploymentUtil.createJarURL((JarFile)moduleFile, (String)"WEB-INF/geronimo-web.xml");
                    try {
                        rawPlan = XmlBeansUtil.parse((URL)path);
                    }
                    catch (FileNotFoundException e) {
                        path = DeploymentUtil.createJarURL((JarFile)moduleFile, (String)"WEB-INF/geronimo-tomcat.xml");
                        try {
                            rawPlan = XmlBeansUtil.parse((URL)path);
                        }
                        catch (FileNotFoundException e1) {
                            log.warn((Object)("Web application " + targetPath + " does not contain a WEB-INF/geronimo-web.xml deployment plan.  This may or may not be a problem, depending on whether you have things like resource references that need to be resolved.  You can also give the deployer a separate deployment plan file on the command line."));
                        }
                    }
                }
                catch (IOException e) {
                    log.warn((Object)e);
                }
            }
            if (rawPlan != null) {
                XmlObject webPlan = new GenericToSpecificPlanConverter(GerTomcatDocument.type.getDocumentElementName().getNamespaceURI(), TomcatWebAppDocument.type.getDocumentElementName().getNamespaceURI(), "tomcat").convertToSpecificPlan(rawPlan);
                tomcatWebApp = (TomcatWebAppType)webPlan.changeType(TomcatWebAppType.type);
                SchemaConversionUtils.validateDD((XmlObject)tomcatWebApp);
            } else {
                String defaultContextRoot = this.determineDefaultContextRoot(webApp, standAlone, moduleFile, targetPath);
                tomcatWebApp = this.createDefaultPlan(defaultContextRoot);
            }
            return tomcatWebApp;
        }
        catch (XmlException e) {
            throw new DeploymentException("xml problem for web app " + targetPath, (Throwable)e);
        }
    }

    private TomcatWebAppType createDefaultPlan(String path) {
        TomcatWebAppType tomcatWebApp = TomcatWebAppType.Factory.newInstance();
        tomcatWebApp.setContextRoot("/" + path);
        return tomcatWebApp;
    }

    public void initContext(EARContext earContext, Module module, ClassLoader cl) throws DeploymentException {
        WebAppType webApp = (WebAppType)module.getSpecDD();
        MessageDestinationType[] messageDestinations = webApp.getMessageDestinationArray();
        TomcatWebAppType gerWebApp = (TomcatWebAppType)module.getVendorDD();
        GerMessageDestinationType[] gerMessageDestinations = gerWebApp.getMessageDestinationArray();
        ENCConfigBuilder.registerMessageDestinations((RefContext)earContext.getRefContext(), (String)module.getName(), (MessageDestinationType[])messageDestinations, (GerMessageDestinationType[])gerMessageDestinations);
        if (!(webApp.getSecurityConstraintArray().length <= 0 && webApp.getSecurityRoleArray().length <= 0 || gerWebApp.isSetSecurityRealmName())) {
            throw new DeploymentException("web.xml for web app " + module.getName() + " includes security elements but Geronimo deployment plan is not provided or does not contain <security-realm-name> element necessary to configure security accordingly.");
        }
        if (gerWebApp.isSetSecurity()) {
            if (!gerWebApp.isSetSecurityRealmName()) {
                throw new DeploymentException("You have supplied a security configuration for web app " + module.getName() + " but no security-realm-name to allow login");
            }
            SecurityConfiguration securityConfiguration = SecurityBuilder.buildSecurityConfiguration((GerSecurityType)gerWebApp.getSecurity(), (ClassLoader)cl);
            earContext.setSecurityConfiguration(securityConfiguration);
        }
    }

    public void addGBeans(EARContext earContext, Module module, ClassLoader cl, Collection repository) throws DeploymentException {
        EARContext moduleContext = module.getEarContext();
        ClassLoader moduleClassLoader = moduleContext.getClassLoader();
        AbstractName moduleName = moduleContext.getModuleName();
        WebModule webModule = (WebModule)module;
        WebAppType webApp = (WebAppType)webModule.getSpecDD();
        TomcatWebAppType tomcatWebApp = (TomcatWebAppType)webModule.getVendorDD();
        GbeanType[] gbeans = tomcatWebApp.getGbeanArray();
        ServiceConfigBuilder.addGBeans((GbeanType[])gbeans, (ClassLoader)moduleClassLoader, (AbstractName)moduleName, (DeploymentContext)moduleContext);
        OnlineUserTransaction userTransaction = new OnlineUserTransaction();
        Map compContext = this.buildComponentContext(earContext, (Module)webModule, webApp, tomcatWebApp, (UserTransaction)userTransaction, moduleClassLoader);
        GBeanData webModuleData = new GBeanData(moduleName, TomcatWebAppContext.GBEAN_INFO);
        try {
            webModuleData.setReferencePattern("J2EEServer", moduleContext.getServerName());
            if (!module.isStandAlone()) {
                webModuleData.setReferencePattern("J2EEApplication", earContext.getModuleName());
            }
            webModuleData.setAttribute("deploymentDescriptor", (Object)module.getOriginalSpecDD());
            Set securityRoles = TomcatModuleBuilder.collectRoleNames((WebAppType)webApp);
            HashMap rolePermissions = new HashMap();
            webModuleData.setAttribute("contextPath", (Object)webModule.getContextRoot());
            Set dependencies = this.findGBeanDependencies(earContext);
            webModuleData.addDependencies(dependencies);
            webModuleData.setAttribute("componentContext", (Object)compContext);
            webModuleData.setAttribute("userTransaction", (Object)userTransaction);
            GBeanResourceEnvironmentBuilder rebuilder = new GBeanResourceEnvironmentBuilder(webModuleData);
            ENCConfigBuilder.setResourceEnvironment((ResourceEnvironmentBuilder)rebuilder, (ResourceRefType[])webApp.getResourceRefArray(), (GerResourceRefType[])tomcatWebApp.getResourceRefArray());
            webModuleData.setReferencePattern("TransactionContextManager", earContext.getTransactionContextManagerObjectName());
            webModuleData.setReferencePattern("TrackedConnectionAssociator", earContext.getConnectionTrackerObjectName());
            if (tomcatWebApp.isSetWebContainer()) {
                AbstractNameQuery webContainerName = ENCConfigBuilder.getGBeanQuery((String)"GBean", (GerGbeanLocatorType)tomcatWebApp.getWebContainer());
                webModuleData.setReferencePattern("Container", webContainerName);
            } else {
                webModuleData.setReferencePattern("Container", this.tomcatContainerName);
            }
            if (tomcatWebApp.isSetHost()) {
                String virtualServer = tomcatWebApp.getHost().trim();
                webModuleData.setAttribute("virtualServer", (Object)virtualServer);
            }
            if (tomcatWebApp.isSetCrossContext()) {
                webModuleData.setAttribute("crossContext", (Object)Boolean.TRUE);
            }
            if (tomcatWebApp.isSetDisableCookies()) {
                webModuleData.setAttribute("disableCookies", (Object)Boolean.TRUE);
            }
            if (tomcatWebApp.isSetTomcatRealm()) {
                String tomcatRealm = tomcatWebApp.getTomcatRealm().trim();
                AbstractName realmName = earContext.getNaming().createChildName(moduleName, tomcatRealm, RealmGBean.GBEAN_INFO.getJ2eeType());
                webModuleData.setReferencePattern("TomcatRealm", realmName);
            }
            if (tomcatWebApp.isSetValveChain()) {
                String valveChain = tomcatWebApp.getValveChain().trim();
                AbstractName valveName = earContext.getNaming().createChildName(moduleName, valveChain, "TomcatValve");
                webModuleData.setReferencePattern("TomcatValveChain", valveName);
            }
            if (tomcatWebApp.isSetCluster()) {
                String cluster = tomcatWebApp.getCluster().trim();
                AbstractName clusterName = earContext.getNaming().createChildName(moduleName, cluster, "Cluster");
                webModuleData.setReferencePattern("Cluster", clusterName);
            }
            if (tomcatWebApp.isSetManager()) {
                String manager = tomcatWebApp.getManager().trim();
                AbstractName managerName = earContext.getNaming().createChildName(moduleName, manager, "Manager");
                webModuleData.setReferencePattern("Manager", managerName);
            }
            Map portMap = webModule.getPortMap();
            ServletType[] servletTypes = webApp.getServletArray();
            HashMap<String, WebServiceContainer> webServices = new HashMap<String, WebServiceContainer>();
            for (int i = 0; i < servletTypes.length; ++i) {
                String servletName;
                ServletType servletType = servletTypes[i];
                this.processRoleRefPermissions(servletType, securityRoles, rolePermissions);
                if (portMap == null || !portMap.containsKey(servletName = servletType.getServletName().getStringValue().trim())) continue;
                String servletClassName = servletType.getServletClass().getStringValue().trim();
                Object portInfo = portMap.get(servletName);
                if (portInfo == null) {
                    throw new DeploymentException("No web service deployment info for servlet name " + servletName + " in web app " + module.getName());
                }
                WebServiceContainer wsContainer = this.configurePOJO(webModule.getModuleFile(), portInfo, servletClassName, moduleClassLoader);
                webServices.put(servletName, wsContainer);
            }
            this.addUnmappedJSPPermissions(securityRoles, rolePermissions);
            webModuleData.setAttribute("webServices", webServices);
            if (tomcatWebApp.isSetSecurityRealmName()) {
                if (earContext.getSecurityConfiguration() == null) {
                    throw new DeploymentException("You have specified a <security-realm-name> for the webapp " + moduleName + " but no <security> configuration (role mapping) is supplied in the Geronimo plan for the web application (or the Geronimo plan for the EAR if the web app is in an EAR)");
                }
                SecurityHolder securityHolder = new SecurityHolder();
                securityHolder.setSecurityRealm(tomcatWebApp.getSecurityRealmName().trim());
                String policyContextID = moduleName.toString().replaceAll("[, :]", "_");
                securityHolder.setPolicyContextID(policyContextID);
                ComponentPermissions componentPermissions = this.buildSpecSecurityConfig(webApp, securityRoles, rolePermissions);
                securityHolder.setExcluded(componentPermissions.getExcludedPermissions());
                Permissions checkedPermissions = new Permissions();
                Iterator iterator = rolePermissions.values().iterator();
                while (iterator.hasNext()) {
                    PermissionCollection permissionsForRole = (PermissionCollection)iterator.next();
                    Enumeration<Permission> iterator2 = permissionsForRole.elements();
                    while (iterator2.hasMoreElements()) {
                        Permission permission = iterator2.nextElement();
                        ((PermissionCollection)checkedPermissions).add(permission);
                    }
                }
                securityHolder.setChecked((PermissionCollection)checkedPermissions);
                earContext.addSecurityContext(policyContextID, (Object)componentPermissions);
                DefaultPrincipal defaultPrincipal = earContext.getSecurityConfiguration().getDefaultPrincipal();
                securityHolder.setDefaultPrincipal(defaultPrincipal);
                if (defaultPrincipal != null) {
                    securityHolder.setSecurity(true);
                }
                webModuleData.setAttribute("securityHolder", (Object)securityHolder);
                webModuleData.setReferencePattern("RoleDesignateSource", earContext.getJaccManagerName());
            }
            moduleContext.addGBean(webModuleData);
            if (!module.isStandAlone()) {
                ConfigurationData moduleConfigurationData = moduleContext.getConfigurationData();
                earContext.addChildConfiguration(module.getTargetPath(), moduleConfigurationData);
            }
        }
        catch (DeploymentException de) {
            throw de;
        }
        catch (Exception e) {
            throw new DeploymentException("Unable to initialize GBean for web app " + module.getName(), (Throwable)e);
        }
    }

    public String getSchemaNamespace() {
        return TOMCAT_NAMESPACE;
    }

    public WebServiceContainer configurePOJO(JarFile moduleFile, Object portInfoObject, String seiClassName, ClassLoader classLoader) throws DeploymentException, IOException {
        GBeanData fakeData = new GBeanData();
        this.getWebServiceBuilder().configurePOJO(fakeData, moduleFile, portInfoObject, seiClassName, classLoader);
        return (WebServiceContainer)fakeData.getAttribute("webServiceContainer");
    }

    private Map buildComponentContext(EARContext earContext, Module webModule, WebAppType webApp, TomcatWebAppType tomcatWebApp, UserTransaction userTransaction, ClassLoader cl) throws DeploymentException {
        return ENCConfigBuilder.buildComponentContext((EARContext)earContext, (Configuration)earContext.getConfiguration(), (Module)webModule, (UserTransaction)userTransaction, (EnvEntryType[])webApp.getEnvEntryArray(), (EjbRefType[])webApp.getEjbRefArray(), (GerEjbRefType[])tomcatWebApp.getEjbRefArray(), (EjbLocalRefType[])webApp.getEjbLocalRefArray(), (GerEjbLocalRefType[])tomcatWebApp.getEjbLocalRefArray(), (ResourceRefType[])webApp.getResourceRefArray(), (GerResourceRefType[])tomcatWebApp.getResourceRefArray(), (ResourceEnvRefType[])webApp.getResourceEnvRefArray(), (GerResourceEnvRefType[])tomcatWebApp.getResourceEnvRefArray(), (MessageDestinationRefType[])webApp.getMessageDestinationRefArray(), (ServiceRefType[])webApp.getServiceRefArray(), (GerServiceRefType[])tomcatWebApp.getServiceRefArray(), (GerGbeanRefType[])tomcatWebApp.getGbeanRefArray(), (ClassLoader)cl);
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        $assertionsDisabled = !TomcatModuleBuilder.class.desiredAssertionStatus();
        log = LogFactory.getLog((Class)TomcatModuleBuilder.class);
        TOMCAT_NAMESPACE = TomcatWebAppDocument.type.getDocumentElementName().getNamespaceURI();
        GBeanInfoBuilder infoBuilder = GBeanInfoBuilder.createStatic((Class)TomcatModuleBuilder.class, (String)"ModuleBuilder");
        infoBuilder.addAttribute("defaultEnvironment", Environment.class, true, true);
        infoBuilder.addAttribute("tomcatContainerName", AbstractNameQuery.class, true, true);
        infoBuilder.addReference("WebServiceBuilder", WebServiceBuilder.class, "ModuleBuilder");
        infoBuilder.addAttribute("kernel", Kernel.class, false);
        infoBuilder.addInterface(ModuleBuilder.class);
        infoBuilder.setConstructor(new String[]{"defaultEnvironment", "tomcatContainerName", "WebServiceBuilder", "kernel"});
        GBEAN_INFO = infoBuilder.getBeanInfo();
    }
}

