/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.tomcat;

import org.apache.catalina.startup.Catalina;
import org.apache.catalina.util.ServerInfo;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.gbean.GReferenceInfo;

public class TomcatGBean
implements GBeanLifecycle {
    private static final Log log = LogFactory.getLog((Class)TomcatGBean.class);
    private Catalina shell;
    private final ServerInfo serverInfo;
    private String catalinaHome;
    private String catalinaBase;
    private String catalinaConfig = "var/catalina/server.xml";
    public static final GBeanInfo GBEAN_INFO;

    public TomcatGBean(ServerInfo serverInfo, String catalinaHome, String catalinaBase, String catalinaConfig) {
        this.serverInfo = serverInfo;
        this.catalinaHome = catalinaHome;
        this.catalinaBase = catalinaBase;
        this.catalinaConfig = catalinaConfig;
    }

    public void doFail() {
        try {
            this.doStop();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void doStart() throws Exception {
        log.debug((Object)("catalinaHome: " + this.catalinaHome + ", catalinaBase: " + this.catalinaBase + ", catalinaConfig: " + this.catalinaConfig));
        if (this.shell == null) {
            this.shell = new Catalina();
        }
        if (this.catalinaHome != null && this.catalinaHome.length() > 0) {
            this.shell.setCatalinaHome(this.catalinaHome);
        }
        if (this.catalinaBase != null && this.catalinaBase.length() > 0) {
            this.shell.setCatalinaBase(this.catalinaBase);
        }
        if (this.catalinaConfig != null && this.catalinaConfig.length() > 0) {
            this.shell.setConfig(this.catalinaConfig);
        }
        this.shell.setParentClassLoader(this.getClass().getClassLoader());
        this.shell.setUseNaming(false);
        this.shell.start();
    }

    public void doStop() throws Exception {
        if (this.shell != null) {
            this.shell.stop();
            this.shell = null;
        }
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoFactory = new GBeanInfoBuilder(TomcatGBean.class.getName());
        infoFactory.setConstructor(new String[]{"ServerInfo", "CatalinaHome", "CatalinaBase", "CatalinaConfig"});
        infoFactory.addReference(new GReferenceInfo("ServerInfo", ServerInfo.class.getName()));
        infoFactory.addAttribute("CatalinaHome", String.class, true);
        infoFactory.addAttribute("CatalinaBase", String.class, true);
        infoFactory.addAttribute("CatalinaConfig", String.class, true);
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

