/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.data;

import gov.nasa.worldwind.avlist.AVList;
import gov.nasa.worldwind.avlist.AVListImpl;
import gov.nasa.worldwind.data.DataRaster;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWUtil;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.Map;

public abstract class AbstractDataRaster
extends AVListImpl
implements DataRaster {
    protected int width = 0;
    protected int height = 0;

    protected AbstractDataRaster() {
    }

    protected AbstractDataRaster(int n, int n2, Sector sector) throws IllegalArgumentException {
        if (n < 0) {
            String string = Logging.getMessage("generic.InvalidWidth", n);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (n2 < 0) {
            String string = Logging.getMessage("generic.InvalidHeight", n2);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (sector == null) {
            String string = Logging.getMessage("nullValue.SectorIsNull");
            Logging.logger().finest(string);
        }
        this.width = n;
        this.height = n2;
        if (null != sector) {
            this.setValue("gov.nasa.worldwind.avKey.Sector", sector);
        }
        this.setValue("gov.nasa.worldwind.avkey.Width", n);
        this.setValue("gov.nasa.worldwind.avkey.Height", n2);
    }

    protected AbstractDataRaster(int n, int n2, Sector sector, AVList aVList) throws IllegalArgumentException {
        this(n, n2, sector);
        if (null != aVList) {
            for (Map.Entry<String, Object> entry : aVList.getEntries()) {
                this.setValue(entry.getKey(), entry.getValue());
            }
        }
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public Sector getSector() {
        if (this.hasKey("gov.nasa.worldwind.avKey.Sector")) {
            return (Sector)this.getValue("gov.nasa.worldwind.avKey.Sector");
        }
        return null;
    }

    @Override
    public Object setValue(String string, Object object) {
        if (null == string) {
            String string2 = Logging.getMessage("nullValue.KeyIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (this.hasKey(string)) {
            if ("gov.nasa.worldwind.avkey.Width".equals(string) && this.getWidth() != ((Integer)object).intValue()) {
                String string3 = Logging.getMessage("generic.AttemptToChangeReadOnlyProperty", string);
                Logging.logger().finest(string3);
                return this;
            }
            if ("gov.nasa.worldwind.avkey.Height".equals(string) && this.getHeight() != ((Integer)object).intValue()) {
                String string4 = Logging.getMessage("generic.AttemptToChangeReadOnlyProperty", string);
                Logging.logger().finest(string4);
                return this;
            }
        }
        return super.setValue(string, object);
    }

    protected Rectangle computeClipRect(Sector sector, DataRaster dataRaster) {
        AffineTransform affineTransform = this.computeGeographicToRasterTransform(dataRaster.getWidth(), dataRaster.getHeight(), dataRaster.getSector());
        Point2D.Double double_ = new Point2D.Double();
        Point2D.Double double_2 = new Point2D.Double();
        Point2D.Double double_3 = new Point2D.Double();
        ((Point2D)double_).setLocation(sector.getMinLongitude().degrees, sector.getMaxLatitude().degrees);
        affineTransform.transform(double_, double_2);
        ((Point2D)double_).setLocation(sector.getMaxLongitude().degrees, sector.getMinLatitude().degrees);
        affineTransform.transform(double_, double_3);
        int n = (int)Math.floor(((Point2D)double_2).getX());
        int n2 = (int)Math.floor(((Point2D)double_2).getY());
        int n3 = (int)Math.ceil(((Point2D)double_3).getX() - ((Point2D)double_2).getX());
        int n4 = (int)Math.ceil(((Point2D)double_3).getY() - ((Point2D)double_2).getY());
        return new Rectangle(n, n2, n3, n4);
    }

    protected AffineTransform computeSourceToDestTransform(int n, int n2, Sector sector, int n3, int n4, Sector sector2) {
        double d = (double)n4 * -(sector.getMaxLatitude().degrees - sector2.getMaxLatitude().degrees) / sector2.getDeltaLatDegrees();
        double d2 = (double)n3 * (sector.getMinLongitude().degrees - sector2.getMinLongitude().degrees) / sector2.getDeltaLonDegrees();
        double d3 = (double)n4 / (double)n2 * (sector.getDeltaLatDegrees() / sector2.getDeltaLatDegrees());
        double d4 = (double)n3 / (double)n * (sector.getDeltaLonDegrees() / sector2.getDeltaLonDegrees());
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.translate(d2, d);
        affineTransform.scale(d4, d3);
        return affineTransform;
    }

    protected AffineTransform computeGeographicToRasterTransform(int n, int n2, Sector sector) {
        double d = -sector.getMaxLatitude().degrees;
        double d2 = -sector.getMinLongitude().degrees;
        double d3 = -((double)n2 / sector.getDeltaLatDegrees());
        double d4 = (double)n / sector.getDeltaLonDegrees();
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.scale(d4, d3);
        affineTransform.translate(d2, d);
        return affineTransform;
    }

    @Override
    public DataRaster getSubRaster(int n, int n2, Sector sector, AVList aVList) {
        aVList = null == aVList ? new AVListImpl() : aVList;
        String[] stringArray = new String[]{"gov.nasa.worldwind.avkey.DataType", "gov.nasa.worldwind.avkey.MissingDataFlag", "gov.nasa.worldwind.avkey.ByteOrder", "gov.nasa.worldwind.avkey.PixelFormat", "gov.nasa.worldwind.avkey.ElevationUnit"};
        WWUtil.copyValues(this, aVList, stringArray, false);
        aVList.setValue("gov.nasa.worldwind.avkey.Width", n);
        aVList.setValue("gov.nasa.worldwind.avkey.Height", n2);
        aVList.setValue("gov.nasa.worldwind.avKey.Sector", sector);
        return this.getSubRaster(aVList);
    }

    @Override
    public DataRaster getSubRaster(AVList aVList) {
        if (null == aVList) {
            String string = Logging.getMessage("nullValue.ParamsIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (!aVList.hasKey("gov.nasa.worldwind.avkey.Width")) {
            String string = Logging.getMessage("generic.MissingRequiredParameter", "gov.nasa.worldwind.avkey.Width");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        int n = (Integer)aVList.getValue("gov.nasa.worldwind.avkey.Width");
        if (n <= 0) {
            String string = Logging.getMessage("generic.InvalidWidth", n);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (!aVList.hasKey("gov.nasa.worldwind.avkey.Height")) {
            String string = Logging.getMessage("generic.MissingRequiredParameter", "gov.nasa.worldwind.avkey.Height");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        int n2 = (Integer)aVList.getValue("gov.nasa.worldwind.avkey.Height");
        if (n2 <= 0) {
            String string = Logging.getMessage("generic.InvalidHeight", n2);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (!aVList.hasKey("gov.nasa.worldwind.avKey.Sector")) {
            String string = Logging.getMessage("generic.MissingRequiredParameter", "gov.nasa.worldwind.avKey.Sector");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Sector sector = (Sector)aVList.getValue("gov.nasa.worldwind.avKey.Sector");
        if (null == sector || Sector.EMPTY_SECTOR.equals(sector)) {
            String string = Logging.getMessage("nullValue.SectorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (Sector.EMPTY_SECTOR.equals(sector)) {
            String string = Logging.getMessage("nullValue.SectorGeometryIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        String[] stringArray = new String[]{"gov.nasa.worldwind.avkey.DataType", "gov.nasa.worldwind.avkey.MissingDataFlag", "gov.nasa.worldwind.avkey.ByteOrder", "gov.nasa.worldwind.avkey.PixelFormat", "gov.nasa.worldwind.avkey.ElevationUnit"};
        WWUtil.copyValues(this, aVList, stringArray, false);
        return this.doGetSubRaster(n, n2, sector, aVList);
    }

    abstract DataRaster doGetSubRaster(int var1, int var2, Sector var3, AVList var4);
}

