/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.data;

import gov.nasa.worldwind.avlist.AVList;
import gov.nasa.worldwind.avlist.AVListImpl;
import gov.nasa.worldwind.data.AbstractDataRasterReader;
import gov.nasa.worldwind.data.DataRaster;
import gov.nasa.worldwind.formats.tiff.GeotiffReader;
import gov.nasa.worldwind.formats.worldfile.WorldFile;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.util.ImageUtil;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWIO;
import gov.nasa.worldwind.util.WWUtil;
import java.io.IOException;

public class GeotiffRasterReader
extends AbstractDataRasterReader {
    private static final String[] geotiffMimeTypes = new String[]{"image/tiff", "image/geotiff"};
    private static final String[] geotiffSuffixes = new String[]{"tif", "tiff", "gtif", "tif.zip", "tiff.zip", "tif.gz", "tiff.gz"};

    public GeotiffRasterReader() {
        super(geotiffMimeTypes, geotiffSuffixes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean doCanRead(Object object, AVList aVList) {
        String string = WWIO.getSourcePath(object);
        if (string == null) {
            return false;
        }
        GeotiffReader geotiffReader = null;
        try {
            geotiffReader = new GeotiffReader(string);
            boolean bl = geotiffReader.isGeotiff(0);
            if (!bl) {
                bl = WorldFile.hasWorldFiles(object);
            }
            boolean bl2 = bl;
            return bl2;
        }
        catch (Exception exception) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (geotiffReader != null) {
                geotiffReader.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected DataRaster[] doRead(Object object, AVList aVList) throws IOException {
        String string = WWIO.getSourcePath(object);
        if (string == null) {
            String string2 = Logging.getMessage("DataRaster.CannotRead", object);
            Logging.logger().severe(string2);
            throw new IOException(string2);
        }
        AVListImpl aVListImpl = new AVListImpl();
        if (null != aVList) {
            aVListImpl.setValues(aVList);
        }
        GeotiffReader geotiffReader = null;
        DataRaster[] dataRasterArray = null;
        try {
            this.readMetadata(object, aVListImpl);
            geotiffReader = new GeotiffReader(string);
            geotiffReader.copyMetadataTo(aVListImpl);
            dataRasterArray = geotiffReader.readDataRaster();
            if (null != dataRasterArray) {
                String[] stringArray = new String[]{"gov.nasa.worldwind.avKey.Sector"};
                for (DataRaster dataRaster : dataRasterArray) {
                    WWUtil.copyValues(aVListImpl, dataRaster, stringArray, false);
                }
            }
        }
        finally {
            if (geotiffReader != null) {
                geotiffReader.close();
            }
        }
        return dataRasterArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doReadMetadata(Object object, AVList aVList) throws IOException {
        String string = WWIO.getSourcePath(object);
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.PathIsNull", object);
            Logging.logger().severe(string2);
            throw new IOException(string2);
        }
        GeotiffReader geotiffReader = null;
        try {
            geotiffReader = new GeotiffReader(string);
            geotiffReader.copyMetadataTo(aVList);
            boolean bl = geotiffReader.isGeotiff(0);
            if (!bl && aVList.hasKey("gov.nasa.worldwind.avkey.Width") && aVList.hasKey("gov.nasa.worldwind.avkey.Height")) {
                int[] nArray = new int[]{(Integer)aVList.getValue("gov.nasa.worldwind.avkey.Width"), (Integer)aVList.getValue("gov.nasa.worldwind.avkey.Height")};
                aVList.setValue("gov.nasa.worldwind.worldFile.ImageSize", nArray);
                WorldFile.readWorldFiles(object, aVList);
                Object object2 = aVList.getValue("gov.nasa.worldwind.avKey.Sector");
                if (object2 == null || !(object2 instanceof Sector)) {
                    ImageUtil.calcBoundingBoxForUTM(aVList);
                }
            }
        }
        finally {
            if (geotiffReader != null) {
                geotiffReader.close();
            }
        }
    }
}

