/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.formats.csv;

import gov.nasa.worldwind.formats.csv.CSVTrackPoint;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.tracks.Track;
import gov.nasa.worldwind.tracks.TrackPoint;
import gov.nasa.worldwind.tracks.TrackPointIterator;
import gov.nasa.worldwind.tracks.TrackPointIteratorImpl;
import gov.nasa.worldwind.tracks.TrackSegment;
import gov.nasa.worldwind.util.Logging;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Scanner;

public class CSVReader
implements Track,
TrackSegment {
    private List<Track> tracks = new ArrayList<Track>();
    private List<TrackSegment> segments = new ArrayList<TrackSegment>();
    private List<TrackPoint> points = new ArrayList<TrackPoint>();
    private String name;

    public CSVReader() {
        this.tracks.add(this);
        this.segments.add(this);
    }

    @Override
    public List<TrackSegment> getSegments() {
        return this.segments;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getNumPoints() {
        return this.points.size();
    }

    @Override
    public List<TrackPoint> getPoints() {
        return this.points;
    }

    public void readFile(String string) throws IOException {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.PathIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        this.name = string;
        File file = new File(string);
        if (!file.exists()) {
            String string3 = Logging.getMessage("generic.FileNotFound", string);
            Logging.logger().severe(string3);
            throw new FileNotFoundException(string);
        }
        FileInputStream fileInputStream = new FileInputStream(file);
        this.doReadStream(fileInputStream);
    }

    public void readStream(InputStream inputStream, String string) throws IOException {
        if (inputStream == null) {
            String string2 = Logging.getMessage("nullValue.InputStreamIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        this.name = string != null ? string : "Un-named stream";
        this.doReadStream(inputStream);
    }

    public List<Track> getTracks() {
        return this.tracks;
    }

    public Iterator<Position> getTrackPositionIterator() {
        return new Iterator<Position>(){
            private TrackPointIterator trackPoints;
            {
                this.trackPoints = new TrackPointIteratorImpl(CSVReader.this.tracks);
            }

            @Override
            public boolean hasNext() {
                return this.trackPoints.hasNext();
            }

            @Override
            public Position next() {
                return this.trackPoints.next().getPosition();
            }

            @Override
            public void remove() {
                this.trackPoints.remove();
            }
        };
    }

    private void doReadStream(InputStream inputStream) {
        Scanner scanner = new Scanner(inputStream);
        try {
            String string;
            do {
                if ((string = scanner.nextLine()) == null) continue;
                this.parseLine(string);
            } while (string != null);
        }
        catch (NoSuchElementException noSuchElementException) {
            return;
        }
    }

    private void parseLine(String string) {
        if (string.trim().length() > 0) {
            CSVTrackPoint cSVTrackPoint = new CSVTrackPoint(string.split(","));
            this.points.add(cSVTrackPoint);
        }
    }
}

