/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.formats.dds;

import gov.nasa.worldwind.formats.dds.DDSConstants;
import gov.nasa.worldwind.formats.dds.DDSHeader;
import gov.nasa.worldwind.formats.dds.DDSPixelFormat;
import gov.nasa.worldwind.formats.dds.DXT1Compressor;
import gov.nasa.worldwind.formats.dds.DXT3Compressor;
import gov.nasa.worldwind.formats.dds.DXTCompressionAttributes;
import gov.nasa.worldwind.formats.dds.DXTCompressor;
import gov.nasa.worldwind.util.ImageUtil;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWIO;
import gov.nasa.worldwind.util.WWMath;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import javax.imageio.ImageIO;

public class DDSCompressor {
    public static ByteBuffer compressImageStream(InputStream inputStream, DXTCompressionAttributes dXTCompressionAttributes) throws IOException {
        if (inputStream == null) {
            String string = Logging.getMessage("nullValue.InputStreamIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (dXTCompressionAttributes == null) {
            String string = Logging.getMessage("nullValue.AttributesIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        BufferedImage bufferedImage = ImageIO.read(inputStream);
        if (bufferedImage == null) {
            return null;
        }
        DDSCompressor dDSCompressor = new DDSCompressor();
        return dDSCompressor.compressImage(bufferedImage, dXTCompressionAttributes);
    }

    public static ByteBuffer compressImageStream(InputStream inputStream) throws IOException {
        if (inputStream == null) {
            String string = Logging.getMessage("nullValue.InputStreamIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return DDSCompressor.compressImageStream(inputStream, DDSCompressor.getDefaultCompressionAttributes());
    }

    public static ByteBuffer compressImageBuffer(ByteBuffer byteBuffer, DXTCompressionAttributes dXTCompressionAttributes) throws IOException {
        if (byteBuffer == null) {
            String string = Logging.getMessage("nullValue.Image");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (dXTCompressionAttributes == null) {
            String string = Logging.getMessage("nullValue.AttributesIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        InputStream inputStream = WWIO.getInputStreamFromByteBuffer(byteBuffer);
        return DDSCompressor.compressImageStream(inputStream, dXTCompressionAttributes);
    }

    public static ByteBuffer compressImageBuffer(ByteBuffer byteBuffer) throws IOException {
        if (byteBuffer == null) {
            String string = Logging.getMessage("nullValue.Image");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return DDSCompressor.compressImageBuffer(byteBuffer, DDSCompressor.getDefaultCompressionAttributes());
    }

    public static ByteBuffer compressImageFile(File file, DXTCompressionAttributes dXTCompressionAttributes) throws IOException {
        if (file == null) {
            String string = Logging.getMessage("nullValue.FileIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (!file.exists() || !file.canRead()) {
            String string = Logging.getMessage("DDSConverter.NoFileOrNoPermission");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (dXTCompressionAttributes == null) {
            String string = Logging.getMessage("nullValue.AttributesIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        BufferedImage bufferedImage = ImageIO.read(file);
        if (bufferedImage == null) {
            return null;
        }
        DDSCompressor dDSCompressor = new DDSCompressor();
        return dDSCompressor.compressImage(bufferedImage, dXTCompressionAttributes);
    }

    public static ByteBuffer compressImageFile(File file) throws IOException {
        if (file == null) {
            String string = Logging.getMessage("nullValue.FileIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (!file.exists() || !file.canRead()) {
            String string = Logging.getMessage("DDSConverter.NoFileOrNoPermission");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return DDSCompressor.compressImageFile(file, DDSCompressor.getDefaultCompressionAttributes());
    }

    public static ByteBuffer compressImageURL(URL uRL, DXTCompressionAttributes dXTCompressionAttributes) throws IOException {
        if (uRL == null) {
            String string = Logging.getMessage("nullValue.URLIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (dXTCompressionAttributes == null) {
            String string = Logging.getMessage("nullValue.AttributesIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        BufferedImage bufferedImage = ImageIO.read(uRL);
        if (bufferedImage == null) {
            return null;
        }
        DDSCompressor dDSCompressor = new DDSCompressor();
        return dDSCompressor.compressImage(bufferedImage, dXTCompressionAttributes);
    }

    public static ByteBuffer compressImageURL(URL uRL) throws IOException {
        if (uRL == null) {
            String string = Logging.getMessage("nullValue.URLIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return DDSCompressor.compressImageURL(uRL, DDSCompressor.getDefaultCompressionAttributes());
    }

    public static ByteBuffer compressImage(BufferedImage bufferedImage) {
        if (bufferedImage == null) {
            String string = Logging.getMessage("nullValue.ImageIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (!WWMath.isPowerOfTwo(bufferedImage.getWidth()) || !WWMath.isPowerOfTwo(bufferedImage.getHeight())) {
            String string = Logging.getMessage("generic.InvalidImageSize", bufferedImage.getWidth(), bufferedImage.getHeight());
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        DDSCompressor dDSCompressor = new DDSCompressor();
        DXTCompressionAttributes dXTCompressionAttributes = DDSCompressor.getDefaultCompressionAttributes();
        return dDSCompressor.compressImage(bufferedImage, dXTCompressionAttributes);
    }

    public static DXTCompressionAttributes getDefaultCompressionAttributes() {
        DXTCompressionAttributes dXTCompressionAttributes = new DXTCompressionAttributes();
        dXTCompressionAttributes.setBuildMipmaps(true);
        dXTCompressionAttributes.setPremultiplyAlpha(true);
        dXTCompressionAttributes.setDXTFormat(0);
        return dXTCompressionAttributes;
    }

    public ByteBuffer compressImage(BufferedImage bufferedImage, DXTCompressionAttributes dXTCompressionAttributes) {
        if (bufferedImage == null) {
            String string = Logging.getMessage("nullValue.ImageIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (!WWMath.isPowerOfTwo(bufferedImage.getWidth()) || !WWMath.isPowerOfTwo(bufferedImage.getHeight())) {
            String string = Logging.getMessage("generic.InvalidImageSize", bufferedImage.getWidth(), bufferedImage.getHeight());
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (dXTCompressionAttributes == null) {
            String string = Logging.getMessage("nullValue.AttributesIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        DXTCompressor dXTCompressor = this.getDXTCompressor(bufferedImage, dXTCompressionAttributes);
        return this.doCompressImage(dXTCompressor, bufferedImage, dXTCompressionAttributes);
    }

    public ByteBuffer compressImageDXT1(BufferedImage bufferedImage, DXTCompressionAttributes dXTCompressionAttributes) {
        if (bufferedImage == null) {
            String string = Logging.getMessage("nullValue.ImageIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (!WWMath.isPowerOfTwo(bufferedImage.getWidth()) || !WWMath.isPowerOfTwo(bufferedImage.getHeight())) {
            String string = Logging.getMessage("generic.InvalidImageSize", bufferedImage.getWidth(), bufferedImage.getHeight());
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (dXTCompressionAttributes == null) {
            String string = Logging.getMessage("nullValue.AttributesIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        DXT1Compressor dXT1Compressor = new DXT1Compressor();
        return this.doCompressImage(dXT1Compressor, bufferedImage, dXTCompressionAttributes);
    }

    public ByteBuffer compressImageDXT3(BufferedImage bufferedImage, DXTCompressionAttributes dXTCompressionAttributes) {
        if (bufferedImage == null) {
            String string = Logging.getMessage("nullValue.ImageIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (!WWMath.isPowerOfTwo(bufferedImage.getWidth()) || !WWMath.isPowerOfTwo(bufferedImage.getHeight())) {
            String string = Logging.getMessage("generic.InvalidImageSize", bufferedImage.getWidth(), bufferedImage.getHeight());
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (dXTCompressionAttributes == null) {
            String string = Logging.getMessage("nullValue.AttributesIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        DXT3Compressor dXT3Compressor = new DXT3Compressor();
        return this.doCompressImage(dXT3Compressor, bufferedImage, dXTCompressionAttributes);
    }

    protected ByteBuffer doCompressImage(DXTCompressor dXTCompressor, BufferedImage bufferedImage, DXTCompressionAttributes dXTCompressionAttributes) {
        DDSHeader dDSHeader = this.createDDSHeader(dXTCompressor, bufferedImage, dXTCompressionAttributes);
        BufferedImage[] bufferedImageArray = null;
        int n = 4 + dDSHeader.getSize();
        if (dXTCompressionAttributes.isBuildMipmaps()) {
            bufferedImageArray = this.buildMipMaps(bufferedImage, dXTCompressionAttributes);
            for (BufferedImage bufferedImage2 : bufferedImageArray) {
                n += dXTCompressor.getCompressedSize(bufferedImage2, dXTCompressionAttributes);
            }
            dDSHeader.setFlags(dDSHeader.getFlags() | 0x20000);
            dDSHeader.setMipMapCount(bufferedImageArray.length);
        } else {
            n += dXTCompressor.getCompressedSize(bufferedImage, dXTCompressionAttributes);
        }
        ByteBuffer byteBuffer = this.createBuffer(n);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        byteBuffer.putInt(DDSConstants.MAGIC);
        this.writeDDSHeader(dDSHeader, byteBuffer);
        if (bufferedImageArray == null) {
            dXTCompressor.compressImage(bufferedImage, dXTCompressionAttributes, byteBuffer);
        } else {
            for (BufferedImage bufferedImage3 : bufferedImageArray) {
                dXTCompressor.compressImage(bufferedImage3, dXTCompressionAttributes, byteBuffer);
            }
        }
        byteBuffer.rewind();
        return byteBuffer;
    }

    protected DXTCompressor getDXTCompressor(BufferedImage bufferedImage, DXTCompressionAttributes dXTCompressionAttributes) {
        if (dXTCompressionAttributes.getDXTFormat() == DDSConstants.D3DFMT_DXT1) {
            return new DXT1Compressor();
        }
        if (dXTCompressionAttributes.getDXTFormat() == DDSConstants.D3DFMT_DXT2 || dXTCompressionAttributes.getDXTFormat() == DDSConstants.D3DFMT_DXT3) {
            return new DXT3Compressor();
        }
        if (!bufferedImage.getColorModel().hasAlpha()) {
            return new DXT1Compressor();
        }
        return new DXT3Compressor();
    }

    protected ByteBuffer createBuffer(int n) {
        return ByteBuffer.allocateDirect(n);
    }

    protected BufferedImage[] buildMipMaps(BufferedImage bufferedImage, DXTCompressionAttributes dXTCompressionAttributes) {
        int n = 3;
        int n2 = ImageUtil.getMaxMipmapLevel(bufferedImage.getWidth(), bufferedImage.getHeight());
        return ImageUtil.buildMipmaps(bufferedImage, n, n2);
    }

    protected DDSHeader createDDSHeader(DXTCompressor dXTCompressor, BufferedImage bufferedImage, DXTCompressionAttributes dXTCompressionAttributes) {
        DDSPixelFormat dDSPixelFormat = new DDSPixelFormat();
        dDSPixelFormat.setFlags(dDSPixelFormat.getFlags() | 4);
        dDSPixelFormat.setFourCC(dXTCompressor.getDXTFormat());
        DDSHeader dDSHeader = new DDSHeader();
        dDSHeader.setFlags(dDSHeader.getFlags() | 4 | 2 | 0x80000 | 0x1000 | 1);
        dDSHeader.setWidth(bufferedImage.getWidth());
        dDSHeader.setHeight(bufferedImage.getHeight());
        dDSHeader.setLinearSize(dXTCompressor.getCompressedSize(bufferedImage, dXTCompressionAttributes));
        dDSHeader.setPixelFormat(dDSPixelFormat);
        dDSHeader.setCaps(dDSHeader.getCaps() | 0x1000);
        return dDSHeader;
    }

    protected void writeDDSHeader(DDSHeader dDSHeader, ByteBuffer byteBuffer) {
        int n = byteBuffer.position();
        byteBuffer.putInt(dDSHeader.getSize());
        byteBuffer.putInt(dDSHeader.getFlags());
        byteBuffer.putInt(dDSHeader.getHeight());
        byteBuffer.putInt(dDSHeader.getWidth());
        byteBuffer.putInt(dDSHeader.getLinearSize());
        byteBuffer.putInt(dDSHeader.getDepth());
        byteBuffer.putInt(dDSHeader.getMipMapCount());
        byteBuffer.position(byteBuffer.position() + 44);
        this.writeDDSPixelFormat(dDSHeader.getPixelFormat(), byteBuffer);
        byteBuffer.putInt(dDSHeader.getCaps());
        byteBuffer.putInt(dDSHeader.getCaps2());
        byteBuffer.putInt(dDSHeader.getCaps3());
        byteBuffer.putInt(dDSHeader.getCaps4());
        byteBuffer.position(byteBuffer.position() + 4);
        byteBuffer.position(n + dDSHeader.getSize());
    }

    protected void writeDDSPixelFormat(DDSPixelFormat dDSPixelFormat, ByteBuffer byteBuffer) {
        int n = byteBuffer.position();
        byteBuffer.putInt(dDSPixelFormat.getSize());
        byteBuffer.putInt(dDSPixelFormat.getFlags());
        byteBuffer.putInt(dDSPixelFormat.getFourCC());
        byteBuffer.putInt(dDSPixelFormat.getRGBBitCount());
        byteBuffer.putInt(dDSPixelFormat.getRBitMask());
        byteBuffer.putInt(dDSPixelFormat.getGBitMask());
        byteBuffer.putInt(dDSPixelFormat.getBBitMask());
        byteBuffer.putInt(dDSPixelFormat.getABitMask());
        byteBuffer.position(n + dDSPixelFormat.getSize());
    }
}

