/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.formats.shapefile;

import gov.nasa.worldwind.avlist.AVListImpl;
import gov.nasa.worldwind.formats.shapefile.DBaseField;
import gov.nasa.worldwind.formats.shapefile.DBaseFile;
import gov.nasa.worldwind.util.Logging;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.logging.Level;

public class DBaseRecord
extends AVListImpl {
    private boolean deleted = false;
    private int recordNumber;
    private static final DateFormat dateformat = new SimpleDateFormat("yyyyMMdd");

    public DBaseRecord(DBaseFile dBaseFile, ByteBuffer byteBuffer, int n) {
        if (dBaseFile == null) {
            String string = Logging.getMessage("nullValue.DBaseFileIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (byteBuffer == null) {
            String string = Logging.getMessage("nullValue.BufferIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.readFromBuffer(dBaseFile, byteBuffer, n);
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public int getRecordNumber() {
        return this.recordNumber;
    }

    protected void readFromBuffer(DBaseFile dBaseFile, ByteBuffer byteBuffer, int n) {
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        this.recordNumber = n;
        byte by = byteBuffer.get();
        this.deleted = by == 42;
        int n2 = 0;
        for (DBaseField dBaseField : dBaseFile.getFields()) {
            if (n2 >= dBaseField.getLength()) continue;
            n2 = dBaseField.getLength();
        }
        DBaseField[] dBaseFieldArray = dBaseFile.getFields();
        byte[] byArray = new byte[n2];
        for (DBaseField dBaseField : dBaseFieldArray) {
            int n3 = dBaseFile.readZeroTerminatedString(byteBuffer, byArray, dBaseField.getLength());
            if (dBaseFile.isStringEmpty(byArray, n3)) {
                this.setValue(dBaseField.getName(), null);
                continue;
            }
            String string = dBaseFile.decodeString(byArray, n3).trim();
            try {
                if (dBaseField.getType() == "DBase.FieldTypeBoolean") {
                    this.setValue(dBaseField.getName(), string.equalsIgnoreCase("T") || string.equalsIgnoreCase("Y"));
                    continue;
                }
                if (dBaseField.getType() == "DBase.FieldTypeChar") {
                    this.setValue(dBaseField.getName(), string);
                    continue;
                }
                if (dBaseField.getType() == "DBase.FieldTypeDate") {
                    this.setValue(dBaseField.getName(), dateformat.parse(string));
                    continue;
                }
                if (dBaseField.getType() != "DBase.FieldTypeNumber") continue;
                if (dBaseField.getDecimals() > 0) {
                    this.setValue(dBaseField.getName(), Double.valueOf(string));
                    continue;
                }
                this.setValue(dBaseField.getName(), Long.valueOf(string));
            }
            catch (Exception exception) {
                Logging.logger().log(Level.WARNING, Logging.getMessage("SHP.FieldParsingError", dBaseField, string), exception);
            }
        }
    }
}

