/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.layers.mercator;

import com.jogamp.opengl.util.texture.TextureData;
import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.avlist.AVList;
import gov.nasa.worldwind.avlist.AVListImpl;
import gov.nasa.worldwind.cache.BasicMemoryCache;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.layers.mercator.MercatorSector;
import gov.nasa.worldwind.layers.mercator.MercatorTextureTile;
import gov.nasa.worldwind.layers.mercator.MercatorTiledImageLayer;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.retrieve.HTTPRetriever;
import gov.nasa.worldwind.retrieve.RetrievalPostProcessor;
import gov.nasa.worldwind.retrieve.Retriever;
import gov.nasa.worldwind.retrieve.URLRetriever;
import gov.nasa.worldwind.util.LevelSet;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.OGLUtil;
import gov.nasa.worldwind.util.WWIO;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.logging.Level;
import javax.imageio.ImageIO;

public class BasicMercatorTiledImageLayer
extends MercatorTiledImageLayer {
    private final Object fileLock = new Object();

    public BasicMercatorTiledImageLayer(LevelSet levelSet) {
        super(levelSet);
        if (!WorldWind.getMemoryCacheSet().containsCache(MercatorTextureTile.class.getName())) {
            long l = Configuration.getLongValue("gov.nasa.worldwind.avkey.TextureTileCacheSize", 3000000L);
            BasicMemoryCache basicMemoryCache = new BasicMemoryCache((long)(0.85 * (double)l), l);
            basicMemoryCache.setName("Texture Tiles");
            WorldWind.getMemoryCacheSet().addCache(MercatorTextureTile.class.getName(), basicMemoryCache);
        }
    }

    public BasicMercatorTiledImageLayer(AVList aVList) {
        this(new LevelSet(aVList));
        this.setValue("gov.nasa.worldwind.avkey.ConstructionParameters", aVList);
    }

    @Override
    protected void forceTextureLoad(MercatorTextureTile mercatorTextureTile) {
        URL uRL = this.getDataFileStore().findFile(mercatorTextureTile.getPath(), true);
        if (uRL != null && !this.isTextureExpired(mercatorTextureTile, uRL)) {
            this.loadTexture(mercatorTextureTile, uRL);
        }
    }

    @Override
    protected void requestTexture(DrawContext drawContext, MercatorTextureTile mercatorTextureTile) {
        Vec4 vec4 = mercatorTextureTile.getCentroidPoint(drawContext.getGlobe());
        if (this.getReferencePoint() != null) {
            mercatorTextureTile.setPriority(vec4.distanceTo3(this.getReferencePoint()));
        }
        RequestTask requestTask = new RequestTask(mercatorTextureTile, this);
        this.getRequestQ().add(requestTask);
    }

    private boolean isTextureExpired(MercatorTextureTile mercatorTextureTile, URL uRL) {
        if (!WWIO.isFileOutOfDate(uRL, mercatorTextureTile.getLevel().getExpiryTime())) {
            return false;
        }
        this.getDataFileStore().removeFile(uRL);
        String string = Logging.getMessage("generic.DataFileExpired", uRL);
        Logging.logger().fine(string);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean loadTexture(MercatorTextureTile mercatorTextureTile, URL uRL) {
        TextureData textureData;
        Object object = this.fileLock;
        synchronized (object) {
            textureData = BasicMercatorTiledImageLayer.readTexture(uRL, this.isUseMipMaps());
        }
        if (textureData == null) {
            return false;
        }
        mercatorTextureTile.setTextureData(textureData);
        if (mercatorTextureTile.getLevelNumber() != 0 || !this.isRetainLevelZeroTiles()) {
            this.addTileToCache(mercatorTextureTile);
        }
        return true;
    }

    private static TextureData readTexture(URL uRL, boolean bl) {
        try {
            return OGLUtil.newTextureData(Configuration.getMaxCompatibleGLProfile(), uRL, bl);
        }
        catch (Exception exception) {
            String string = Logging.getMessage("layers.TextureLayer.ExceptionAttemptingToReadTextureFile", uRL.toString());
            Logging.logger().log(Level.SEVERE, string, exception);
            return null;
        }
    }

    private void addTileToCache(MercatorTextureTile mercatorTextureTile) {
        WorldWind.getMemoryCache(MercatorTextureTile.class.getName()).add(mercatorTextureTile.getTileKey(), mercatorTextureTile);
    }

    protected void downloadTexture(MercatorTextureTile mercatorTextureTile) {
        Integer n;
        Integer n2;
        URL uRL;
        if (!WorldWind.getRetrievalService().isAvailable()) {
            return;
        }
        try {
            uRL = mercatorTextureTile.getResourceURL();
            if (uRL == null) {
                return;
            }
            if (WorldWind.getNetworkStatus().isHostUnavailable(uRL)) {
                return;
            }
        }
        catch (MalformedURLException malformedURLException) {
            Logging.logger().log(Level.SEVERE, Logging.getMessage("layers.TextureLayer.ExceptionCreatingTextureUrl", mercatorTextureTile), malformedURLException);
            return;
        }
        if (!"http".equalsIgnoreCase(uRL.getProtocol())) {
            Logging.logger().severe(Logging.getMessage("layers.TextureLayer.UnknownRetrievalProtocol", uRL.toString()));
            return;
        }
        HTTPRetriever hTTPRetriever = new HTTPRetriever(uRL, new DownloadPostProcessor(mercatorTextureTile, this));
        hTTPRetriever.setValue("URLRetriever.ExtractZipEntry", "true");
        Integer n3 = AVListImpl.getIntegerValue(this, "gov.nasa.worldwind.avkey.URLConnectTimeout");
        if (n3 != null && n3 > 0) {
            hTTPRetriever.setConnectTimeout(n3);
        }
        if ((n2 = AVListImpl.getIntegerValue(this, "gov.nasa.worldwind.avkey.URLReadTimeout")) != null && n2 > 0) {
            hTTPRetriever.setReadTimeout(n2);
        }
        if ((n = AVListImpl.getIntegerValue(this, "gov.nasa.worldwind.avkey.RetrievalStaleRequestLimit")) != null && n > 0) {
            hTTPRetriever.setStaleRequestLimit(n);
        }
        WorldWind.getRetrievalService().runRetriever(hTTPRetriever, mercatorTextureTile.getPriority());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveBuffer(ByteBuffer byteBuffer, File file) throws IOException {
        Object object = this.fileLock;
        synchronized (object) {
            WWIO.saveBuffer(byteBuffer, file);
        }
    }

    protected boolean isTileValid(BufferedImage bufferedImage) {
        return true;
    }

    protected BufferedImage modifyImage(BufferedImage bufferedImage) {
        return bufferedImage;
    }

    private BufferedImage convertBufferToImage(ByteBuffer byteBuffer) {
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteBuffer.array());
            return ImageIO.read(byteArrayInputStream);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean transformAndSave(BufferedImage bufferedImage, MercatorSector mercatorSector, File file) {
        try {
            bufferedImage = this.transform(bufferedImage, mercatorSector);
            String string = file.getName().substring(file.getName().lastIndexOf(46) + 1);
            Object object = this.fileLock;
            synchronized (object) {
                return ImageIO.write((RenderedImage)bufferedImage, string, file);
            }
        }
        catch (IOException iOException) {
            return false;
        }
    }

    private BufferedImage transform(BufferedImage bufferedImage, MercatorSector mercatorSector) {
        int n = bufferedImage.getType();
        if (n == 0) {
            n = 1;
        }
        BufferedImage bufferedImage2 = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), n);
        double d = mercatorSector.getMinLatPercent();
        double d2 = mercatorSector.getMaxLatPercent();
        for (int i = 0; i < bufferedImage.getHeight(); ++i) {
            double d3 = 1.0 - (double)i / (double)(bufferedImage.getHeight() - 1);
            Angle angle = Angle.fromRadians(d3 * mercatorSector.getDeltaLatRadians() + mercatorSector.getMinLatitude().radians);
            double d4 = 1.0 - (MercatorSector.gudermannianInverse(angle) - d) / (d2 - d);
            d4 = Math.max(0.0, Math.min(1.0, d4));
            int n2 = (int)(d4 * (double)(bufferedImage.getHeight() - 1));
            for (int j = 0; j < bufferedImage.getWidth(); ++j) {
                bufferedImage2.setRGB(j, i, bufferedImage.getRGB(j, n2));
            }
        }
        return bufferedImage2;
    }

    private static class DownloadPostProcessor
    implements RetrievalPostProcessor {
        private final MercatorTextureTile tile;
        private final BasicMercatorTiledImageLayer layer;

        public DownloadPostProcessor(MercatorTextureTile mercatorTextureTile, BasicMercatorTiledImageLayer basicMercatorTiledImageLayer) {
            this.tile = mercatorTextureTile;
            this.layer = basicMercatorTiledImageLayer;
        }

        @Override
        public ByteBuffer run(Retriever retriever) {
            if (retriever == null) {
                String string = Logging.getMessage("nullValue.RetrieverIsNull");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            try {
                Object object;
                if (!retriever.getState().equals("gov.nasa.worldwind.RetrieverStatusSuccessful")) {
                    return null;
                }
                URLRetriever uRLRetriever = (URLRetriever)retriever;
                ByteBuffer byteBuffer = uRLRetriever.getBuffer();
                if (retriever instanceof HTTPRetriever) {
                    object = (HTTPRetriever)retriever;
                    if (((HTTPRetriever)object).getResponseCode() == 204) {
                        this.layer.getLevels().markResourceAbsent(this.tile);
                        return null;
                    }
                    if (((HTTPRetriever)object).getResponseCode() != 200) {
                        this.layer.getLevels().markResourceAbsent(this.tile);
                        return null;
                    }
                }
                if ((object = this.layer.getDataFileStore().newFile(this.tile.getPath())) == null) {
                    return null;
                }
                if (((File)object).exists()) {
                    return byteBuffer;
                }
                if (byteBuffer != null) {
                    String string = uRLRetriever.getContentType();
                    if (string == null) {
                        return null;
                    }
                    if (string.contains("xml") || string.contains("html") || string.contains("text")) {
                        this.layer.getLevels().markResourceAbsent(this.tile);
                        StringBuffer stringBuffer = new StringBuffer();
                        while (byteBuffer.hasRemaining()) {
                            stringBuffer.append((char)byteBuffer.get());
                        }
                        Logging.logger().severe(stringBuffer.toString());
                        return null;
                    }
                    if (string.contains("dds")) {
                        this.layer.saveBuffer(byteBuffer, (File)object);
                    } else if (string.contains("zip")) {
                        this.layer.saveBuffer(byteBuffer, (File)object);
                    } else if (string.contains("image")) {
                        BufferedImage bufferedImage = this.layer.convertBufferToImage(byteBuffer);
                        if (bufferedImage != null) {
                            if (this.layer.isTileValid(bufferedImage = this.layer.modifyImage(bufferedImage))) {
                                if (!this.layer.transformAndSave(bufferedImage, this.tile.getMercatorSector(), (File)object)) {
                                    bufferedImage = null;
                                }
                            } else {
                                this.layer.getLevels().markResourceAbsent(this.tile);
                                return null;
                            }
                        }
                        if (bufferedImage == null) {
                            this.layer.saveBuffer(byteBuffer, (File)object);
                        }
                    }
                    if (byteBuffer != null) {
                        this.layer.firePropertyChange("gov.nasa.worldwind.avkey.LayerObject", null, this);
                    }
                    return byteBuffer;
                }
            }
            catch (IOException iOException) {
                this.layer.getLevels().markResourceAbsent(this.tile);
                Logging.logger().log(Level.SEVERE, Logging.getMessage("layers.TextureLayer.ExceptionSavingRetrievedTextureFile", this.tile.getPath()), iOException);
            }
            return null;
        }
    }

    private static class RequestTask
    implements Runnable,
    Comparable<RequestTask> {
        private final BasicMercatorTiledImageLayer layer;
        private final MercatorTextureTile tile;

        private RequestTask(MercatorTextureTile mercatorTextureTile, BasicMercatorTiledImageLayer basicMercatorTiledImageLayer) {
            this.layer = basicMercatorTiledImageLayer;
            this.tile = mercatorTextureTile;
        }

        @Override
        public void run() {
            URL uRL = this.layer.getDataFileStore().findFile(this.tile.getPath(), false);
            if (uRL != null && !this.layer.isTextureExpired(this.tile, uRL)) {
                if (this.layer.loadTexture(this.tile, uRL)) {
                    this.layer.getLevels().unmarkResourceAbsent(this.tile);
                    this.layer.firePropertyChange("gov.nasa.worldwind.avkey.LayerObject", null, this);
                    return;
                }
                this.layer.getDataFileStore().removeFile(uRL);
                this.layer.getLevels().markResourceAbsent(this.tile);
                String string = Logging.getMessage("generic.DeletedCorruptDataFile", uRL);
                Logging.logger().info(string);
            }
            this.layer.downloadTexture(this.tile);
        }

        @Override
        public int compareTo(RequestTask requestTask) {
            if (requestTask == null) {
                String string = Logging.getMessage("nullValue.RequestTaskIsNull");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            return this.tile.getPriority() == requestTask.tile.getPriority() ? 0 : (this.tile.getPriority() < requestTask.tile.getPriority() ? -1 : 1);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            RequestTask requestTask = (RequestTask)object;
            return !(this.tile == null ? requestTask.tile != null : !this.tile.equals(requestTask.tile));
        }

        public int hashCode() {
            return this.tile != null ? this.tile.hashCode() : 0;
        }

        public String toString() {
            return this.tile.toString();
        }
    }
}

