/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.render;

import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwind.Disposable;
import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.avlist.AVList;
import gov.nasa.worldwind.avlist.AVListImpl;
import gov.nasa.worldwind.event.SelectEvent;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.pick.PickSupport;
import gov.nasa.worldwind.pick.PickedObject;
import gov.nasa.worldwind.render.AbstractBalloon;
import gov.nasa.worldwind.render.BalloonAttributes;
import gov.nasa.worldwind.render.BasicWWTexture;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.Offset;
import gov.nasa.worldwind.render.OrderedRenderable;
import gov.nasa.worldwind.render.Size;
import gov.nasa.worldwind.render.WWTexture;
import gov.nasa.worldwind.util.GeometryBuilder;
import gov.nasa.worldwind.util.HotSpot;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.OGLStackHandler;
import gov.nasa.worldwind.util.OGLUtil;
import gov.nasa.worldwind.util.WWIO;
import gov.nasa.worldwind.util.WWUtil;
import gov.nasa.worldwind.util.webview.BasicWebViewFactory;
import gov.nasa.worldwind.util.webview.WebResourceResolver;
import gov.nasa.worldwind.util.webview.WebView;
import gov.nasa.worldwind.util.webview.WebViewFactory;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeEvent;
import java.net.URL;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.media.opengl.GL2;

public abstract class AbstractBrowserBalloon
extends AbstractBalloon
implements OrderedRenderable,
HotSpot,
Disposable {
    protected static final Dimension DEFAULT_NATIVE_SIZE = new Dimension(400, 300);
    protected static final int DEFAULT_OUTLINE_PICK_WIDTH = 10;
    protected static final String DEFAULT_WEB_VIEW_FACTORY = BasicWebViewFactory.class.getName();
    protected static final int FRAME_GEOMETRY_ELLIPSE_SLICES = 64;
    protected static final int FRAME_GEOMETRY_RECTANGLE_CORNER_SLICES = 16;
    protected String visibilityAction = "gov.nasa.worldwind.avkey.VisibilityActionRelease";
    protected boolean drawTitleBar = true;
    protected boolean drawBrowserControls = true;
    protected boolean drawResizeControl = true;
    protected int outlinePickWidth = 10;
    protected List<BrowserControl> browserControls = new ArrayList<BrowserControl>(AbstractBrowserBalloon.createDefaultBrowserControls());
    protected Object resourceResolver;
    protected long textUpdateTime = -1L;
    protected boolean webViewCreationFailed;
    protected WebView webView;
    protected long frameTimeStamp = -1L;
    protected long geomTimeStamp = -1L;
    protected long webViewTimeStamp = -1L;
    protected Point screenOffset;
    protected Rectangle screenRect;
    protected Rectangle screenExtent;
    protected Rectangle screenPickExtent;
    protected Rectangle webViewRect;
    protected Dimension webViewContentSize;
    protected double eyeDistance;
    protected FrameGeometryInfo frameInfo;
    protected Layer pickLayer;
    protected Point lastPickPoint;
    protected PickSupport pickSupport = new PickSupport();
    protected OGLStackHandler osh = new OGLStackHandler();

    protected static List<BrowserControl> createDefaultBrowserControls() {
        return Arrays.asList(new BrowserControl("gov.nasa.worldwind.avkey.Close", new Offset(30.0, 25.0, "gov.nasa.worldwind.avkey.InsetPixels", "gov.nasa.worldwind.avkey.InsetPixels"), "images/browser-close-16x16.gif"), new BrowserControl("gov.nasa.worldwind.avkey.Back", new Offset(15.0, 25.0, "gov.nasa.worldwind.avkey.Pixels", "gov.nasa.worldwind.avkey.InsetPixels"), "images/browser-back-16x16.gif"), new BrowserControl("gov.nasa.worldwind.avkey.Forward", new Offset(35.0, 25.0, "gov.nasa.worldwind.avkey.Pixels", "gov.nasa.worldwind.avkey.InsetPixels"), "images/browser-forward-16x16.gif"));
    }

    protected AbstractBrowserBalloon(String string) {
        super(string);
    }

    protected abstract void computeBalloonPoints(DrawContext var1);

    protected abstract void setupDepthTest(DrawContext var1);

    @Override
    public void dispose() {
        this.disposeWebView();
    }

    public boolean isDrawTitleBar() {
        return this.drawTitleBar;
    }

    public void setDrawTitleBar(boolean bl) {
        this.drawTitleBar = bl;
    }

    public boolean isDrawBrowserControls() {
        return this.drawBrowserControls;
    }

    public void setDrawBrowserControls(boolean bl) {
        this.drawBrowserControls = bl;
    }

    public boolean isDrawResizeControl() {
        return this.drawResizeControl;
    }

    public void setDrawResizeControl(boolean bl) {
        this.drawResizeControl = bl;
    }

    @Override
    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (!this.isVisible() && "gov.nasa.worldwind.avkey.VisibilityActionRelease".equals(this.getVisibilityAction())) {
            this.disposeWebView();
        }
    }

    public int getOutlinePickWidth() {
        return this.outlinePickWidth;
    }

    public void setOutlinePickWidth(int n) {
        if (n < 0) {
            String string = Logging.getMessage("Geom.WidthIsNegative", n);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.outlinePickWidth = n;
    }

    public Iterable<BrowserControl> getBrowserControls() {
        return this.browserControls;
    }

    public void addBrowserControl(BrowserControl browserControl) {
        if (browserControl == null) {
            String string = Logging.getMessage("nullValue.BrowserControlIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.browserControls.add(browserControl);
    }

    public BrowserControl addBrowserControl(String string, Offset offset, Object object) {
        if (offset == null) {
            String string2 = Logging.getMessage("nullValue.OffsetIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (WWUtil.isEmpty(object)) {
            String string3 = Logging.getMessage("nullValue.ImageSource");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        BrowserControl browserControl = new BrowserControl(string, offset, object);
        this.addBrowserControl(browserControl);
        return browserControl;
    }

    public BrowserControl addBrowserControl(String string, Offset offset, Size size, Object object) {
        if (offset == null) {
            String string2 = Logging.getMessage("nullValue.OffsetIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (size == null) {
            String string3 = Logging.getMessage("nullValue.SizeIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        if (WWUtil.isEmpty(object)) {
            String string4 = Logging.getMessage("nullValue.ImageSource");
            Logging.logger().severe(string4);
            throw new IllegalArgumentException(string4);
        }
        BrowserControl browserControl = new BrowserControl(string, offset, size, object);
        this.addBrowserControl(browserControl);
        return browserControl;
    }

    public void addAllBrowserControls(Iterable<? extends BrowserControl> iterable) {
        if (iterable == null) {
            String string = Logging.getMessage("nullValue.IterableIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        for (BrowserControl browserControl : iterable) {
            if (browserControl == null) continue;
            this.browserControls.add(browserControl);
        }
    }

    public void removeBrowserControl(BrowserControl browserControl) {
        if (browserControl == null) {
            String string = Logging.getMessage("nullValue.BrowserControlIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.browserControls.remove(browserControl);
    }

    public void removeAllBrowserControls() {
        this.browserControls.clear();
    }

    public Object getResourceResolver() {
        return this.resourceResolver;
    }

    public void setResourceResolver(Object object) {
        this.resourceResolver = object;
        this.textUpdateTime = -1L;
    }

    public String getVisibilityAction() {
        return this.visibilityAction;
    }

    public void setVisibilityAction(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        this.visibilityAction = string;
    }

    public void goBack() {
        if (this.webView != null) {
            this.webView.goBack();
        }
    }

    public void goForward() {
        if (this.webView != null) {
            this.webView.goForward();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (!this.isVisible() && propertyChangeEvent != null && "gov.nasa.worldwind.avkey.Repaint".equals(propertyChangeEvent.getPropertyName())) {
            return;
        }
        super.propertyChange(propertyChangeEvent);
    }

    @Override
    public Rectangle getBounds(DrawContext drawContext) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.updateRenderStateIfNeeded(drawContext);
        return this.screenExtent;
    }

    @Override
    public double getDistanceFromEye() {
        return this.eyeDistance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pick(DrawContext drawContext, Point point) {
        if (!this.isPickEnabled()) {
            return;
        }
        this.pickSupport.clearPickList();
        try {
            this.pickSupport.beginPicking(drawContext);
            this.render(drawContext);
        }
        finally {
            this.pickSupport.endPicking(drawContext);
            this.pickSupport.resolvePick(drawContext, point, this.pickLayer);
        }
    }

    @Override
    public void render(DrawContext drawContext) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (!this.isVisible()) {
            return;
        }
        if (drawContext.isOrderedRenderingMode()) {
            this.drawOrderedRenderable(drawContext);
        } else {
            this.makeOrderedRenderable(drawContext);
        }
    }

    protected void makeOrderedRenderable(DrawContext drawContext) {
        this.updateRenderStateIfNeeded(drawContext);
        if (this.getActiveAttributes() == null || this.screenRect == null) {
            return;
        }
        if (drawContext.getFrameTimeStamp() != this.geomTimeStamp) {
            if (this.mustRegenerateGeometry()) {
                this.computeGeometry();
            }
            this.geomTimeStamp = drawContext.getFrameTimeStamp();
        }
        if (drawContext.getFrameTimeStamp() != this.webViewTimeStamp) {
            this.updateWebView(drawContext);
            this.webViewTimeStamp = drawContext.getFrameTimeStamp();
        }
        if (this.intersectsFrustum(drawContext)) {
            drawContext.addOrderedRenderable(this);
        }
        if (drawContext.isPickingMode()) {
            this.pickLayer = drawContext.getCurrentLayer();
        }
    }

    protected void updateRenderStateIfNeeded(DrawContext drawContext) {
        if (drawContext.getFrameTimeStamp() != this.frameTimeStamp) {
            this.updateRenderState(drawContext);
            this.frameTimeStamp = drawContext.getFrameTimeStamp();
        }
    }

    protected void updateRenderState(DrawContext drawContext) {
        this.determineActiveAttributes();
        if (this.getActiveAttributes() == null) {
            return;
        }
        this.determineWebViewContentSize();
        this.computeBalloonPoints(drawContext);
    }

    protected Dimension computeSize(DrawContext drawContext, BalloonAttributes balloonAttributes) {
        Dimension dimension = this.webViewContentSize != null && this.webViewContentSize.width != 0 && this.webViewContentSize.height != 0 ? this.computeFrameRectForWebViewRect(balloonAttributes, new Rectangle(this.webViewContentSize)).getSize() : DEFAULT_NATIVE_SIZE;
        Dimension dimension2 = balloonAttributes.getSize().compute(dimension.width, dimension.height, drawContext.getView().getViewport().width, drawContext.getView().getViewport().height);
        if (balloonAttributes.getMaximumSize() != null) {
            Dimension dimension3 = balloonAttributes.getMaximumSize().compute(dimension.width, dimension.height, drawContext.getView().getViewport().width, drawContext.getView().getViewport().height);
            if (dimension2.width > dimension3.width) {
                dimension2.width = dimension3.width;
            }
            if (dimension2.height > dimension3.height) {
                dimension2.height = dimension3.height;
            }
        }
        return dimension2;
    }

    protected Point computeOffset(DrawContext drawContext, BalloonAttributes balloonAttributes, int n, int n2) {
        Point2D.Double double_ = balloonAttributes.getOffset().computeOffset(n, n2, 1.0, 1.0);
        return new Point((int)double_.getX(), (int)double_.getY());
    }

    protected boolean mustRegenerateGeometry() {
        if (this.frameInfo == null) {
            return true;
        }
        if (!this.screenRect.getSize().equals(this.frameInfo.size) || !this.screenOffset.equals(this.frameInfo.offset)) {
            return true;
        }
        BalloonAttributes balloonAttributes = this.getActiveAttributes();
        return !balloonAttributes.getBalloonShape().equals(this.frameInfo.balloonShape) || !balloonAttributes.getLeaderShape().equals(this.frameInfo.leaderShape) || balloonAttributes.getLeaderWidth() != this.frameInfo.leaderWidth || balloonAttributes.getCornerRadius() != this.frameInfo.cornerRadius;
    }

    protected void computeGeometry() {
        if (this.screenRect == null) {
            return;
        }
        BalloonAttributes balloonAttributes = this.getActiveAttributes();
        if (this.frameInfo == null) {
            this.frameInfo = new FrameGeometryInfo();
        }
        this.frameInfo.vertexBuffer = this.createFrameVertices();
        this.frameInfo.size = this.screenRect.getSize();
        this.frameInfo.offset = this.screenOffset;
        this.frameInfo.balloonShape = balloonAttributes.getBalloonShape();
        this.frameInfo.leaderShape = balloonAttributes.getLeaderShape();
        this.frameInfo.leaderWidth = balloonAttributes.getLeaderWidth();
        this.frameInfo.cornerRadius = balloonAttributes.getCornerRadius();
    }

    protected FloatBuffer createFrameVertices() {
        BalloonAttributes balloonAttributes = this.getActiveAttributes();
        if ("gov.nasa.worldwind.avkey.ShapeNone".equals(balloonAttributes.getBalloonShape())) {
            return this.makeDefaultFrameVertices();
        }
        if ("gov.nasa.worldwind.avkey.ShapeEllipse".equals(balloonAttributes.getBalloonShape())) {
            return this.makeEllipseFrameVertices();
        }
        return this.makeRectangleFrameVertices();
    }

    protected FloatBuffer makeDefaultFrameVertices() {
        BalloonAttributes balloonAttributes = this.getActiveAttributes();
        GeometryBuilder geometryBuilder = new GeometryBuilder();
        int n = this.webViewRect.x - this.screenRect.x;
        int n2 = this.webViewRect.y - this.screenRect.y;
        if ("gov.nasa.worldwind.avkey.ShapeTriangle".equals(balloonAttributes.getLeaderShape())) {
            return geometryBuilder.makeRectangleWithLeader(n, n2, this.webViewRect.width, this.webViewRect.height, this.screenOffset.x, this.screenOffset.y, balloonAttributes.getLeaderWidth());
        }
        return geometryBuilder.makeRectangle(n, n2, this.webViewRect.width, this.webViewRect.height);
    }

    protected FloatBuffer makeEllipseFrameVertices() {
        BalloonAttributes balloonAttributes = this.getActiveAttributes();
        GeometryBuilder geometryBuilder = new GeometryBuilder();
        int n = this.screenRect.width / 2;
        int n2 = this.screenRect.height / 2;
        int n3 = this.screenRect.width / 2;
        int n4 = this.screenRect.height / 2;
        if ("gov.nasa.worldwind.avkey.ShapeTriangle".equals(balloonAttributes.getLeaderShape())) {
            return geometryBuilder.makeEllipseWithLeader(n, n2, n3, n4, 64, this.screenOffset.x, this.screenOffset.y, balloonAttributes.getLeaderWidth());
        }
        return geometryBuilder.makeEllipse(n, n2, n3, n4, 64);
    }

    protected FloatBuffer makeRectangleFrameVertices() {
        BalloonAttributes balloonAttributes = this.getActiveAttributes();
        GeometryBuilder geometryBuilder = new GeometryBuilder();
        if ("gov.nasa.worldwind.avkey.ShapeTriangle".equals(balloonAttributes.getLeaderShape())) {
            return geometryBuilder.makeRectangleWithLeader(0.0f, 0.0f, this.screenRect.width, this.screenRect.height, balloonAttributes.getCornerRadius(), 16, this.screenOffset.x, this.screenOffset.y, balloonAttributes.getLeaderWidth());
        }
        return geometryBuilder.makeRectangle(0.0f, 0.0f, this.screenRect.width, this.screenRect.height, balloonAttributes.getCornerRadius(), 16);
    }

    protected boolean intersectsFrustum(DrawContext drawContext) {
        if (drawContext.isPickingMode()) {
            return drawContext.getPickFrustums().intersectsAny(this.screenPickExtent);
        }
        return drawContext.getView().getViewport().intersects(this.screenExtent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void drawOrderedRenderable(DrawContext drawContext) {
        this.beginDrawing(drawContext);
        try {
            this.doDrawOrderedRenderable(drawContext);
        }
        finally {
            this.endDrawing(drawContext);
        }
    }

    protected void beginDrawing(DrawContext drawContext) {
        GL2 gL2 = drawContext.getGL().getGL2();
        int n = 18701;
        this.osh.clear();
        this.osh.pushAttrib(gL2, n);
        this.osh.pushClientAttrib(gL2, 2);
        this.osh.pushProjectionIdentity(gL2);
        gL2.glOrtho(0.0, (double)drawContext.getView().getViewport().width, 0.0, (double)drawContext.getView().getViewport().height, -1.0, 1.0);
        this.osh.pushTextureIdentity(gL2);
        this.osh.pushModelviewIdentity(gL2);
        gL2.glEnableClientState(32884);
        if (!drawContext.isPickingMode()) {
            gL2.glEnable(3042);
            OGLUtil.applyBlending(gL2, false);
        }
    }

    protected void endDrawing(DrawContext drawContext) {
        GL2 gL2 = drawContext.getGL().getGL2();
        this.osh.pop(gL2);
    }

    protected void doDrawOrderedRenderable(DrawContext drawContext) {
        GL2 gL2 = drawContext.getGL().getGL2();
        if (drawContext.isPickingMode()) {
            Color color = drawContext.getUniquePickColor();
            this.pickSupport.addPickableObject(this.createPickedObject(drawContext, color));
            gL2.glColor3ub((byte)color.getRed(), (byte)color.getGreen(), (byte)color.getBlue());
        }
        gL2.glTranslatef((float)this.screenRect.x, (float)this.screenRect.y, 0.0f);
        if (!drawContext.isDeepPickingEnabled()) {
            this.setupDepthTest(drawContext);
        }
        this.drawFrame(drawContext);
        if (this.isDrawTitleBar(drawContext)) {
            this.drawTitleBar(drawContext);
        }
        if (this.isDrawResizeControl(drawContext)) {
            this.drawResizeControl(drawContext);
        }
        if (this.isDrawBrowserControls(drawContext)) {
            this.drawBrowserControls(drawContext);
        }
        if (this.isDrawLinks(drawContext)) {
            this.drawLinks(drawContext);
        }
    }

    protected PickedObject createPickedObject(DrawContext drawContext, Color color) {
        PickedObject pickedObject = new PickedObject(color.getRGB(), this.getDelegateOwner() != null ? this.getDelegateOwner() : this);
        pickedObject.setValue("gov.nasa.worldwind.avkey.HotSpot", this);
        return pickedObject;
    }

    protected PickedObject createLinkPickedObject(DrawContext drawContext, Color color, AVList aVList) {
        PickedObject pickedObject = new PickedObject(color.getRGB(), this);
        pickedObject.setValues(aVList);
        pickedObject.setValue("gov.nasa.worldwind.avkey.Context", this.getValue("gov.nasa.worldwind.avkey.Context"));
        return pickedObject;
    }

    protected boolean isDrawInterior(DrawContext drawContext) {
        return this.getActiveAttributes().isDrawInterior() && this.getActiveAttributes().getInteriorOpacity() > 0.0;
    }

    protected boolean isDrawOutline(DrawContext drawContext) {
        return this.getActiveAttributes().isDrawOutline() && this.getActiveAttributes().getOutlineOpacity() > 0.0;
    }

    protected boolean isDrawTitleBar(DrawContext drawContext) {
        return this.isDrawTitleBar() && this.isDrawInterior(drawContext) && !drawContext.isPickingMode();
    }

    protected boolean isDrawResizeControl(DrawContext drawContext) {
        return this.isDrawResizeControl() && (this.isDrawInterior(drawContext) || this.isDrawOutline(drawContext)) && drawContext.isPickingMode();
    }

    protected boolean isDrawBrowserControls(DrawContext drawContext) {
        return this.isDrawBrowserControls() && this.isDrawInterior(drawContext);
    }

    protected boolean isDrawLinks(DrawContext drawContext) {
        return this.isDrawInterior(drawContext) && drawContext.isPickingMode();
    }

    protected void drawFrame(DrawContext drawContext) {
        if (this.frameInfo.vertexBuffer == null) {
            return;
        }
        GL2 gL2 = drawContext.getGL().getGL2();
        gL2.glVertexPointer(2, 5126, 0, (Buffer)this.frameInfo.vertexBuffer);
        if (this.isDrawInterior(drawContext)) {
            this.prepareToDrawInterior(drawContext);
            this.drawFrameInterior(drawContext);
        }
        if (this.isDrawOutline(drawContext)) {
            this.prepareToDrawOutline(drawContext);
            this.drawFrameOutline(drawContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void drawFrameInterior(DrawContext drawContext) {
        if (this.frameInfo.vertexBuffer == null) {
            return;
        }
        GL2 gL2 = drawContext.getGL().getGL2();
        boolean bl = false;
        try {
            if (!drawContext.isPickingMode() && this.bindWebViewTexture(drawContext)) {
                gL2.glEnable(3553);
                gL2.glEnableClientState(32888);
                gL2.glTexEnvi(8960, 8704, 8449);
                gL2.glTexCoordPointer(2, 5126, 0, (Buffer)this.frameInfo.vertexBuffer);
                bl = true;
            }
            gL2.glDrawArrays(6, 0, this.frameInfo.vertexBuffer.remaining() / 2);
        }
        finally {
            if (bl) {
                gL2.glDisable(3553);
                gL2.glDisableClientState(32888);
                gL2.glBindTexture(3553, 0);
                gL2.glTexEnvf(8960, 8704, 8448.0f);
                gL2.glTexCoordPointer(2, 5126, 0, null);
            }
        }
    }

    protected void drawFrameOutline(DrawContext drawContext) {
        if (this.frameInfo.vertexBuffer == null) {
            return;
        }
        drawContext.getGL().glDrawArrays(2, 0, this.frameInfo.vertexBuffer.remaining() / 2);
    }

    protected void prepareToDrawInterior(DrawContext drawContext) {
        GL2 gL2 = drawContext.getGL().getGL2();
        if (!drawContext.isPickingMode()) {
            Color color = this.getActiveAttributes().getInteriorMaterial().getDiffuse();
            double d = this.getActiveAttributes().getInteriorOpacity();
            gL2.glColor4ub((byte)color.getRed(), (byte)color.getGreen(), (byte)color.getBlue(), (byte)(d < 1.0 ? (int)(d * 255.0 + 0.5) : 255));
        }
    }

    protected void prepareToDrawOutline(DrawContext drawContext) {
        GL2 gL2 = drawContext.getGL().getGL2();
        if (!drawContext.isPickingMode()) {
            Color color = this.getActiveAttributes().getOutlineMaterial().getDiffuse();
            double d = this.getActiveAttributes().getOutlineOpacity();
            gL2.glColor4ub((byte)color.getRed(), (byte)color.getGreen(), (byte)color.getBlue(), (byte)(d < 1.0 ? (int)(d * 255.0 + 0.5) : 255));
            if (this.getActiveAttributes().isEnableAntialiasing()) {
                gL2.glEnable(2848);
            }
            if (this.getActiveAttributes().getOutlineStippleFactor() > 0) {
                gL2.glEnable(2852);
                gL2.glLineStipple(this.getActiveAttributes().getOutlineStippleFactor(), this.getActiveAttributes().getOutlineStipplePattern());
            }
        }
        if (drawContext.isPickingMode()) {
            gL2.glLineWidth((float)this.computeOutlinePickWidth());
        } else {
            gL2.glLineWidth((float)this.getActiveAttributes().getOutlineWidth());
        }
    }

    protected Rectangle computeFramePickRect(Rectangle rectangle) {
        double d = this.computeOutlinePickWidth();
        return new Rectangle(rectangle.x - (int)d / 2, rectangle.y - (int)d / 2, rectangle.width + (int)d, rectangle.height + (int)d);
    }

    protected double computeOutlinePickWidth() {
        return Math.max(this.getActiveAttributes().getOutlineWidth(), (double)this.getOutlinePickWidth());
    }

    protected void updateWebView(DrawContext drawContext) {
        if (this.webView == null) {
            this.makeWebView(drawContext, this.webViewRect.getSize());
            if (this.webView == null) {
                return;
            }
        }
        this.webView.setFrameSize(this.webViewRect.getSize());
        this.webView.setBackgroundColor(this.getActiveAttributes().getInteriorMaterial().getDiffuse());
        if (this.getTextDecoder().getLastUpdateTime() != this.textUpdateTime) {
            this.setWebViewContent();
            this.textUpdateTime = this.getTextDecoder().getLastUpdateTime();
        }
    }

    protected void setWebViewContent() {
        String string = this.getTextDecoder().getDecodedText();
        Object object = this.getResourceResolver();
        if (object instanceof WebResourceResolver) {
            this.webView.setHTMLString(string, (WebResourceResolver)object);
        } else if (object instanceof URL) {
            this.webView.setHTMLString(string, (URL)object);
        } else if (object instanceof String) {
            URL uRL = WWIO.makeURL((String)object);
            if (uRL == null) {
                Logging.logger().warning(Logging.getMessage("generic.URIInvalid", object));
            }
            this.webView.setHTMLString(string, uRL);
        } else {
            if (object != null) {
                Logging.logger().warning(Logging.getMessage("generic.UnrecognizedResourceResolver", object));
            }
            this.webView.setHTMLString(string);
        }
    }

    protected void makeWebView(DrawContext drawContext, Dimension dimension) {
        if (this.webView != null || this.webViewCreationFailed) {
            return;
        }
        try {
            String string = Configuration.getStringValue("gov.nasa.worldwind.avkey.WebViewFactory", DEFAULT_WEB_VIEW_FACTORY);
            WebViewFactory webViewFactory = (WebViewFactory)WorldWind.createComponent(string);
            this.webView = webViewFactory.createWebView(dimension);
        }
        catch (Throwable throwable) {
            String string = Logging.getMessage("WebView.ExceptionCreatingWebView", throwable);
            Logging.logger().severe(string);
            drawContext.addRenderingException(throwable);
            this.webViewCreationFailed = true;
        }
        if (this.webView != null) {
            this.webView.addPropertyChangeListener(this);
        }
    }

    protected void disposeWebView() {
        if (this.webView == null) {
            return;
        }
        this.webView.removePropertyChangeListener(this);
        this.webView.dispose();
        this.webView = null;
        this.textUpdateTime = -1L;
        this.webViewContentSize = null;
    }

    protected void determineWebViewContentSize() {
        if (this.webView != null && this.webView.getContentURL() == null) {
            this.webViewContentSize = this.webView.getContentSize();
        }
    }

    protected Rectangle computeWebViewRectForFrameRect(BalloonAttributes balloonAttributes, Rectangle rectangle) {
        Insets insets = balloonAttributes.getInsets();
        return new Rectangle(rectangle.x + insets.left, rectangle.y + insets.bottom, rectangle.width - (insets.left + insets.right), rectangle.height - (insets.bottom + insets.top));
    }

    protected Rectangle computeFrameRectForWebViewRect(BalloonAttributes balloonAttributes, Rectangle rectangle) {
        Insets insets = balloonAttributes.getInsets();
        return new Rectangle(rectangle.x - insets.left, rectangle.y - insets.bottom, rectangle.width + (insets.left + insets.right), rectangle.height + (insets.bottom + insets.top));
    }

    protected boolean bindWebViewTexture(DrawContext drawContext) {
        if (this.webView == null) {
            return false;
        }
        WWTexture wWTexture = this.webView.getTextureRepresentation(drawContext);
        if (wWTexture == null) {
            return false;
        }
        if (!wWTexture.bind(drawContext)) {
            return false;
        }
        GL2 gL2 = drawContext.getGL().getGL2();
        wWTexture.applyInternalTransform(drawContext);
        gL2.glMatrixMode(5890);
        gL2.glScalef(1.0f / (float)this.webViewRect.width, 1.0f / (float)this.webViewRect.height, 1.0f);
        gL2.glTranslatef((float)(this.screenRect.x - this.webViewRect.x), (float)(this.screenRect.y - this.webViewRect.y), 0.0f);
        gL2.glMatrixMode(5888);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void drawWebViewLinks(DrawContext drawContext) {
        GL2 gL2 = drawContext.getGL().getGL2();
        if (this.webView == null) {
            return;
        }
        Iterable<AVList> iterable = this.webView.getLinks();
        if (iterable == null) {
            return;
        }
        for (AVList aVList : iterable) {
            if (aVList == null || aVList.getValue("gov.nasa.worldwind.avkey.Bounds") == null || aVList.getValue("gov.nasa.worldwind.avkey.Rectangles") == null) continue;
            Rectangle rectangle = new Rectangle((Rectangle)aVList.getValue("gov.nasa.worldwind.avkey.Bounds"));
            rectangle.translate(this.webViewRect.x, this.webViewRect.y);
            if (!drawContext.getPickFrustums().intersectsAny(rectangle)) continue;
            Color color = drawContext.getUniquePickColor();
            gL2.glColor3ub((byte)color.getRed(), (byte)color.getGreen(), (byte)color.getBlue());
            this.pickSupport.addPickableObject(this.createLinkPickedObject(drawContext, color, aVList));
            int n = this.webViewRect.x - this.screenRect.x;
            int n2 = this.webViewRect.y - this.screenRect.y;
            gL2.glBegin(7);
            try {
                for (Rectangle rectangle2 : (Rectangle[])aVList.getValue("gov.nasa.worldwind.avkey.Rectangles")) {
                    if (rectangle2 == null) continue;
                    gL2.glVertex2i(n + rectangle2.x, n2 + rectangle2.y);
                    gL2.glVertex2i(n + rectangle2.x + rectangle2.width, n2 + rectangle2.y);
                    gL2.glVertex2i(n + rectangle2.x + rectangle2.width, n2 + rectangle2.y + rectangle2.height);
                    gL2.glVertex2i(n + rectangle2.x, n2 + rectangle2.y + rectangle2.height);
                }
            }
            finally {
                gL2.glEnd();
            }
        }
    }

    protected void drawResizeControl(DrawContext drawContext) {
        if (this.frameInfo.vertexBuffer == null) {
            return;
        }
        GL2 gL2 = drawContext.getGL().getGL2();
        Rectangle rectangle = new Rectangle(this.screenRect.x, drawContext.getView().getViewport().height - this.screenRect.y - this.screenRect.height, this.screenRect.width, this.screenRect.height);
        Color color = drawContext.getUniquePickColor();
        gL2.glColor3ub((byte)color.getRed(), (byte)color.getGreen(), (byte)color.getBlue());
        PickedObject pickedObject = new PickedObject(color.getRGB(), this);
        pickedObject.setValue("gov.nasa.worldwind.avkey.Action", "gov.nasa.worldwind.avkey.Resize");
        pickedObject.setValue("gov.nasa.worldwind.avkey.Bounds", rectangle);
        this.pickSupport.addPickableObject(pickedObject);
        gL2.glLineWidth((float)this.computeOutlinePickWidth());
        gL2.glVertexPointer(2, 5126, 0, (Buffer)this.frameInfo.vertexBuffer);
        gL2.glDrawArrays(2, 0, this.frameInfo.vertexBuffer.remaining() / 2);
    }

    protected void drawBrowserControls(DrawContext drawContext) {
        for (BrowserControl browserControl : this.getBrowserControls()) {
            if (browserControl == null || !browserControl.isVisible()) continue;
            try {
                this.drawBrowserControl(drawContext, browserControl);
            }
            catch (Exception exception) {
                Logging.logger().severe(Logging.getMessage("generic.ExceptionWhileRenderingBrowserControl", browserControl));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void drawBrowserControl(DrawContext drawContext, BrowserControl browserControl) {
        WWTexture wWTexture = browserControl.getTexture();
        if (wWTexture == null) {
            return;
        }
        Point2D.Double double_ = browserControl.getOffset().computeOffset(this.screenRect.width, this.screenRect.height, 1.0, 1.0);
        Dimension dimension = browserControl.getSize().compute(wWTexture.getWidth(drawContext), wWTexture.getHeight(drawContext), this.screenRect.width, this.screenRect.height);
        Rectangle rectangle = new Rectangle(this.screenRect.x + (int)((Point2D)double_).getX(), this.screenRect.y + (int)((Point2D)double_).getY(), dimension.width, dimension.height);
        if (rectangle.isEmpty()) {
            return;
        }
        GL2 gL2 = drawContext.getGL().getGL2();
        OGLStackHandler oGLStackHandler = new OGLStackHandler();
        oGLStackHandler.pushTextureIdentity(gL2);
        oGLStackHandler.pushModelviewIdentity(gL2);
        try {
            gL2.glTranslated((double)rectangle.x, (double)rectangle.y, 0.0);
            gL2.glScaled((double)rectangle.width, (double)rectangle.height, 1.0);
            if (drawContext.isPickingMode()) {
                Color color = drawContext.getUniquePickColor();
                gL2.glColor3ub((byte)color.getRed(), (byte)color.getGreen(), (byte)color.getBlue());
                PickedObject pickedObject = new PickedObject(color.getRGB(), this);
                pickedObject.setValues(browserControl);
                this.pickSupport.addPickableObject(pickedObject);
                drawContext.drawUnitQuad();
            } else {
                Color color = drawContext.getPickFrustums().intersectsAny(rectangle) ? (browserControl.getHighlightColor() != null ? browserControl.getHighlightColor() : BrowserControl.DEFAULT_HIGHLIGHT_COLOR) : (browserControl.getColor() != null ? browserControl.getColor() : BrowserControl.DEFAULT_COLOR);
                float[] fArray = new float[4];
                color.getRGBComponents(fArray);
                float f = fArray[3] * (float)this.getActiveAttributes().getInteriorOpacity();
                if (f > 1.0f) {
                    f = 1.0f;
                }
                OGLUtil.applyBlending(gL2, true);
                gL2.glColor4f(fArray[0] * f, fArray[1] * f, fArray[2] * f, f);
                gL2.glEnable(3553);
                if (wWTexture.bind(drawContext)) {
                    drawContext.drawUnitQuad(wWTexture.getTexCoords());
                }
            }
        }
        finally {
            oGLStackHandler.pop(gL2);
            gL2.glDisable(3553);
            gL2.glBindTexture(3553, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void drawTitleBar(DrawContext drawContext) {
        GL2 gL2 = drawContext.getGL().getGL2();
        Color color = this.getActiveAttributes().getOutlineMaterial().getDiffuse();
        double d = this.getActiveAttributes().getInteriorOpacity();
        gL2.glColor4ub((byte)color.getRed(), (byte)color.getGreen(), (byte)color.getBlue(), (byte)(d < 1.0 ? (int)(d * 255.0 + 0.5) : 255));
        gL2.glDisable(2848);
        gL2.glLineWidth(1.0f);
        int n = this.webViewRect.x - this.screenRect.x;
        int n2 = this.webViewRect.y - this.screenRect.y;
        gL2.glBegin(1);
        try {
            gL2.glVertex2i(n, n2 + this.webViewRect.height);
            gL2.glVertex2i(n + this.webViewRect.width, n2 + this.webViewRect.height);
        }
        finally {
            gL2.glEnd();
        }
    }

    protected void drawLinks(DrawContext drawContext) {
        this.drawWebViewLinks(drawContext);
    }

    @Override
    public void setActive(boolean bl) {
        if (this.webView != null) {
            this.webView.setActive(bl);
        }
    }

    @Override
    public boolean isActive() {
        return this.webView != null && this.webView.isActive();
    }

    @Override
    public void selected(SelectEvent selectEvent) {
        if (selectEvent == null || selectEvent.isConsumed()) {
            return;
        }
        this.handleSelectEvent(selectEvent);
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        if (keyEvent == null || keyEvent.isConsumed()) {
            return;
        }
        this.handleKeyEvent(keyEvent);
        keyEvent.consume();
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent == null || keyEvent.isConsumed()) {
            return;
        }
        this.handleKeyEvent(keyEvent);
        keyEvent.consume();
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        if (keyEvent == null || keyEvent.isConsumed()) {
            return;
        }
        this.handleKeyEvent(keyEvent);
        keyEvent.consume();
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        if (mouseEvent == null || mouseEvent.isConsumed()) {
            return;
        }
        this.handleMouseEvent(mouseEvent);
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        if (mouseWheelEvent == null || mouseWheelEvent.isConsumed()) {
            return;
        }
        this.handleMouseEvent(mouseWheelEvent);
        mouseWheelEvent.consume();
    }

    @Override
    public Cursor getCursor() {
        return null;
    }

    protected void handleSelectEvent(SelectEvent selectEvent) {
        if (this.webView == null) {
            return;
        }
        if (selectEvent.isBoxSelect()) {
            return;
        }
        Point point = selectEvent.getPickPoint();
        if (point == null) {
            point = this.lastPickPoint;
        }
        if (point == null) {
            return;
        }
        Point point2 = this.convertToWebView(selectEvent.getSource(), point);
        if (selectEvent.isLeftPress() || selectEvent.isRightPress()) {
            int n = selectEvent.isLeftPress() ? 1024 : 4096;
            this.webView.sendEvent(new MouseEvent((Component)selectEvent.getSource(), 501, System.currentTimeMillis(), n, point2.x, point2.y, 0, selectEvent.isRightPress(), selectEvent.isRightPress() ? 3 : 1));
        } else if (selectEvent.isLeftClick() || selectEvent.isRightClick() || selectEvent.isLeftDoubleClick()) {
            int n = selectEvent.isLeftDoubleClick() ? 2 : 1;
            int n2 = selectEvent.isLeftClick() || selectEvent.isLeftDoubleClick() ? 1024 : 4096;
            this.webView.sendEvent(new MouseEvent((Component)selectEvent.getSource(), 502, System.currentTimeMillis(), 0, point2.x, point2.y, n, false, selectEvent.isRightClick() ? 3 : 1));
            this.webView.sendEvent(new MouseEvent((Component)selectEvent.getSource(), 500, System.currentTimeMillis(), n2, point2.x, point2.y, n, false, selectEvent.isRightClick() ? 3 : 1));
        } else if (selectEvent.isDrag()) {
            this.webView.sendEvent(new MouseEvent((Component)selectEvent.getSource(), 506, System.currentTimeMillis(), 1024, point2.x, point2.y, 0, false, 1));
        } else if (selectEvent.isDragEnd()) {
            this.webView.sendEvent(new MouseEvent((Component)selectEvent.getSource(), 502, System.currentTimeMillis(), 0, point2.x, point2.y, 0, false, 1));
        }
        this.lastPickPoint = selectEvent.getPickPoint();
        if (!selectEvent.isLeftPress()) {
            selectEvent.consume();
        }
    }

    protected void handleKeyEvent(KeyEvent keyEvent) {
        if (this.webView != null) {
            this.webView.sendEvent(keyEvent);
        }
    }

    protected void handleMouseEvent(MouseEvent mouseEvent) {
        if (this.webView == null) {
            return;
        }
        Point point = this.convertToWebView(mouseEvent.getSource(), mouseEvent.getPoint());
        if (mouseEvent instanceof MouseWheelEvent) {
            this.webView.sendEvent(new MouseWheelEvent((Component)mouseEvent.getSource(), mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), point.x, point.y, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger(), ((MouseWheelEvent)mouseEvent).getScrollType(), ((MouseWheelEvent)mouseEvent).getScrollAmount(), ((MouseWheelEvent)mouseEvent).getWheelRotation()));
        } else {
            this.webView.sendEvent(new MouseEvent((Component)mouseEvent.getSource(), mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), point.x, point.y, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger(), mouseEvent.getButton()));
        }
    }

    protected Point convertToWebView(Object object, Point point) {
        int n = point.x;
        int n2 = point.y;
        if (object instanceof Component) {
            n2 = ((Component)object).getHeight() - point.y;
        }
        return new Point(n -= this.webViewRect.x, n2 -= this.webViewRect.y);
    }

    protected static class FrameGeometryInfo {
        protected FloatBuffer vertexBuffer;
        protected Dimension size;
        protected Point offset;
        protected String balloonShape;
        protected String leaderShape;
        protected int leaderWidth;
        protected int cornerRadius;
    }

    public static class BrowserControl
    extends AVListImpl {
        protected static final Color DEFAULT_COLOR = new Color(255, 255, 255, 153);
        protected static final Color DEFAULT_HIGHLIGHT_COLOR = new Color(255, 255, 255, 255);
        protected boolean visible = true;
        protected Offset offset;
        protected Size size;
        protected Object imageSource;
        protected Color color;
        protected Color highlightColor;
        protected WWTexture texture;

        public BrowserControl(String string, Offset offset, Object object) {
            if (offset == null) {
                String string2 = Logging.getMessage("nullValue.OffsetIsNull");
                Logging.logger().severe(string2);
                throw new IllegalArgumentException(string2);
            }
            if (WWUtil.isEmpty(object)) {
                String string3 = Logging.getMessage("nullValue.ImageSource");
                Logging.logger().severe(string3);
                throw new IllegalArgumentException(string3);
            }
            this.setAction(string);
            this.offset = offset;
            this.size = new Size("gov.nasa.worldwind.render.Size.NativeDimension", 0.0, null, "gov.nasa.worldwind.render.Size.NativeDimension", 0.0, null);
            this.imageSource = object;
        }

        public BrowserControl(String string, Offset offset, Size size, Object object) {
            if (offset == null) {
                String string2 = Logging.getMessage("nullValue.OffsetIsNull");
                Logging.logger().severe(string2);
                throw new IllegalArgumentException(string2);
            }
            if (size == null) {
                String string3 = Logging.getMessage("nullValue.SizeIsNull");
                Logging.logger().severe(string3);
                throw new IllegalArgumentException(string3);
            }
            if (WWUtil.isEmpty(object)) {
                String string4 = Logging.getMessage("nullValue.ImageSource");
                Logging.logger().severe(string4);
                throw new IllegalArgumentException(string4);
            }
            this.setValue("gov.nasa.worldwind.avkey.Action", string);
            this.offset = offset;
            this.size = size;
            this.imageSource = object;
        }

        public boolean isVisible() {
            return this.visible;
        }

        public void setVisible(boolean bl) {
            this.visible = bl;
        }

        public String getAction() {
            return this.getStringValue("gov.nasa.worldwind.avkey.Action");
        }

        public void setAction(String string) {
            this.setValue("gov.nasa.worldwind.avkey.Action", string);
        }

        public Offset getOffset() {
            return this.offset;
        }

        public void setOffset(Offset offset) {
            if (offset == null) {
                String string = Logging.getMessage("nullValue.OffsetIsNull");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            this.offset = offset;
        }

        public Size getSize() {
            return this.size;
        }

        public void setSize(Size size) {
            if (size == null) {
                String string = Logging.getMessage("nullValue.SizeIsNull");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            this.size = size;
        }

        public Color getColor() {
            return this.color;
        }

        public void setColor(Color color) {
            this.color = color;
        }

        public Color getHighlightColor() {
            return this.highlightColor;
        }

        public void setHighlightColor(Color color) {
            this.highlightColor = color;
        }

        public Object getImageSource() {
            return this.imageSource;
        }

        public void setImageSource(Object object) {
            if (WWUtil.isEmpty(object)) {
                String string = Logging.getMessage("nullValue.ImageSource");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            this.imageSource = object;
            this.texture = null;
        }

        protected WWTexture getTexture() {
            if (this.texture == null && this.getImageSource() != null) {
                this.texture = new BasicWWTexture(this.getImageSource(), true);
            }
            return this.texture;
        }
    }
}

