/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.render;

import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Extent;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.render.AbstractShape;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.terrain.Terrain;
import gov.nasa.worldwind.util.Logging;
import java.io.IOException;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public abstract class AbstractGeneralShape
extends AbstractShape {
    protected Position modelPosition = Position.ZERO;
    protected Angle heading;
    protected Angle pitch;
    protected Angle roll;
    protected Vec4 modelScale;
    protected Map<String, Object> resourceMap;

    protected ShapeData getCurrent() {
        return (ShapeData)this.getCurrentData();
    }

    @Override
    protected void initialize() {
        this.altitudeMode = 1;
    }

    public Map<String, Object> getResourceMap() {
        return this.resourceMap;
    }

    public void setResourceMap(Map<String, Object> map) {
        this.resourceMap = map;
    }

    public Position getModelPosition() {
        return this.modelPosition;
    }

    public void setModelPosition(Position position) {
        this.modelPosition = position;
    }

    public Vec4 getModelScale() {
        return this.modelScale;
    }

    public void setModelScale(Vec4 vec4) {
        this.modelScale = vec4;
    }

    public Angle getHeading() {
        return this.heading;
    }

    public void setHeading(Angle angle) {
        this.heading = angle;
    }

    public Angle getPitch() {
        return this.pitch;
    }

    public void setPitch(Angle angle) {
        this.pitch = angle;
    }

    public Angle getRoll() {
        return this.roll;
    }

    public void setRoll(Angle angle) {
        this.roll = angle;
    }

    @Override
    public Position getReferencePosition() {
        return this.getModelPosition();
    }

    protected Vec4 computeReferencePoint(Terrain terrain) {
        Position position = this.getReferencePosition();
        if (position == null) {
            return null;
        }
        Vec4 vec4 = terrain.getSurfacePoint(position.getLatitude(), position.getLongitude(), 0.0);
        if (vec4 == null) {
            return null;
        }
        return vec4;
    }

    protected double computeEyeDistance(DrawContext drawContext, ShapeData shapeData) {
        Vec4 vec4 = drawContext.getView().getEyePoint();
        Extent extent = shapeData.getExtent();
        if (extent != null) {
            return extent.getCenter().distanceTo3(vec4) + extent.getRadius();
        }
        Vec4 vec42 = shapeData.getReferencePoint();
        if (vec42 != null) {
            return vec42.distanceTo3(vec4);
        }
        return 0.0;
    }

    @Override
    public void moveTo(Position position) {
        this.setModelPosition(position);
    }

    @Override
    protected void doExportAsKML(XMLStreamWriter xMLStreamWriter) throws IOException, XMLStreamException {
        String string = Logging.getMessage("unsupportedOperation.doExportAsKML");
        Logging.logger().severe(string);
        throw new UnsupportedOperationException(string);
    }

    @Override
    public Sector getSector() {
        return null;
    }

    protected static class ShapeData
    extends AbstractShape.AbstractShapeData {
        public ShapeData(DrawContext drawContext, AbstractGeneralShape abstractGeneralShape) {
            super(drawContext, abstractGeneralShape.minExpiryTime, abstractGeneralShape.maxExpiryTime);
        }
    }
}

