/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.render;

import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWUtil;
import javax.media.opengl.GL;
import javax.media.opengl.GLContext;

public class GLRuntimeCapabilities {
    protected static final String GL_EXT_FRAMEBUFFER_OBJECT_STRING = "GL_EXT_framebuffer_object";
    protected static final String GL_EXT_TEXTURE_FILTER_ANISOTROPIC_STRING = "GL_EXT_texture_filter_anisotropic";
    protected double glVersion;
    protected boolean isVMwareSVGA3D;
    protected boolean isAnisotropicTextureFilterAvailable;
    protected boolean isAnisotropicTextureFilterEnabled = true;
    protected boolean isFramebufferObjectAvailable;
    protected boolean isFramebufferObjectEnabled = true;
    protected boolean isVertexBufferObjectAvailable;
    protected boolean isVertexBufferObjectEnabled = Configuration.getBooleanValue("gov.nasa.worldwind.avkey.VBOUsage", true);
    protected double maxTextureAnisotropy = -1.0;
    protected int maxTextureSize;
    protected int numTextureUnits;

    public void initialize(GLContext gLContext) {
        Object[] objectArray;
        Object object;
        String string;
        if (gLContext == null) {
            String string2 = Logging.getMessage("nullValue.GLContextIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        GL gL = gLContext.getGL();
        if (this.glVersion < 1.0 && (string = gL.glGetString(7938)) != null && (object = WWUtil.convertStringToDouble(string = string.substring(0, 3))) != null) {
            this.glVersion = (Double)object;
        }
        string = gL.glGetString(7936);
        object = gL.glGetString(7937);
        if (string != null && string.toLowerCase().contains("vmware") && object != null && ((String)object).toLowerCase().contains("svga3d")) {
            this.isVMwareSVGA3D = true;
        }
        this.isAnisotropicTextureFilterAvailable = gL.isExtensionAvailable(GL_EXT_TEXTURE_FILTER_ANISOTROPIC_STRING);
        this.isFramebufferObjectAvailable = gL.isExtensionAvailable(GL_EXT_FRAMEBUFFER_OBJECT_STRING);
        boolean bl = this.isVertexBufferObjectAvailable = this.glVersion >= 1.5;
        if (this.maxTextureAnisotropy < 0.0 && this.isAnisotropicTextureFilterAvailable) {
            objectArray = new float[1];
            gL.glGetFloatv(34047, objectArray, 0);
            this.maxTextureAnisotropy = objectArray[0];
        }
        if (this.numTextureUnits == 0) {
            objectArray = new int[1];
            gL.glGetIntegerv(34018, (int[])objectArray, 0);
            this.numTextureUnits = (int)objectArray[0];
        }
        if (this.maxTextureSize == 0) {
            objectArray = new int[1];
            gL.glGetIntegerv(3379, (int[])objectArray, 0);
            this.maxTextureSize = (int)objectArray[0];
        }
    }

    public double getGLVersion() {
        return this.glVersion;
    }

    public void setGLVersion(double d) {
        this.glVersion = d;
    }

    public boolean isVMwareSVGA3D() {
        return this.isVMwareSVGA3D;
    }

    public boolean isUseAnisotropicTextureFilter() {
        return this.isAnisotropicTextureFilterAvailable && this.isAnisotropicTextureFilterEnabled;
    }

    public boolean isUseFramebufferObject() {
        return this.isFramebufferObjectAvailable && this.isFramebufferObjectEnabled;
    }

    public boolean isUseVertexBufferObject() {
        return this.isVertexBufferObjectAvailable && this.isVertexBufferObjectEnabled;
    }

    public boolean isAnisotropicTextureFilterAvailable() {
        return this.isAnisotropicTextureFilterAvailable;
    }

    public void setAnisotropicTextureFilterAvailable(boolean bl) {
        this.isAnisotropicTextureFilterAvailable = bl;
    }

    public boolean isAnisotropicTextureFilterEnabled() {
        return this.isAnisotropicTextureFilterEnabled;
    }

    public void setAnisotropicTextureFilterEnabled(boolean bl) {
        this.isAnisotropicTextureFilterEnabled = bl;
    }

    public boolean isFramebufferObjectAvailable() {
        return this.isFramebufferObjectAvailable;
    }

    public void setFramebufferObjectAvailable(boolean bl) {
        this.isFramebufferObjectAvailable = bl;
    }

    public boolean isFramebufferObjectEnabled() {
        return this.isFramebufferObjectEnabled;
    }

    public void setFramebufferObjectEnabled(boolean bl) {
        this.isFramebufferObjectEnabled = bl;
    }

    public boolean isVertexBufferObjectAvailable() {
        return this.isVertexBufferObjectAvailable;
    }

    public void setVertexBufferObjectAvailable(boolean bl) {
        this.isVertexBufferObjectAvailable = bl;
    }

    public boolean isVertexBufferObjectEnabled() {
        return this.isVertexBufferObjectEnabled;
    }

    public void setVertexBufferObjectEnabled(boolean bl) {
        this.isVertexBufferObjectEnabled = bl;
    }

    public double getMaxTextureAnisotropy() {
        return this.maxTextureAnisotropy;
    }

    public void setMaxTextureAnisotropy(double d) {
        this.maxTextureAnisotropy = d;
    }

    public int getMaxTextureSize() {
        return this.maxTextureSize;
    }

    public void setMaxTextureSize(int n) {
        if (n < 1) {
            String string = Logging.getMessage("generic.MaxTextureSizeLessThanOne");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.maxTextureSize = n;
    }

    public int getNumTextureUnits() {
        return this.numTextureUnits;
    }

    public void setNumTextureUnits(int n) {
        if (n < 1) {
            String string = Logging.getMessage("generic.NumTextureUnitsLessThanOne");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.numTextureUnits = n;
    }
}

