/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.render;

import com.jogamp.common.nio.Buffers;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.render.AbstractShape;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.Path;
import gov.nasa.worldwind.util.Logging;
import java.awt.Color;
import java.nio.IntBuffer;
import java.util.Iterator;

public class MultiResolutionPath
extends Path {
    protected SkipCountComputer skipCountComputer = new SkipCountComputer(){

        @Override
        public int computeSkipCount(DrawContext drawContext, Path.PathData pathData) {
            double d = MultiResolutionPath.this.getDistanceMetric(drawContext, pathData);
            return d > 10000.0 ? 4 : (d > 1000.0 ? 2 : 1);
        }
    };

    public MultiResolutionPath(Iterable<? extends Position> iterable) {
        super(iterable);
    }

    public MultiResolutionPath(Position.PositionList positionList) {
        super(positionList);
    }

    public SkipCountComputer getSkipCountComputer() {
        return this.skipCountComputer;
    }

    public void setSkipCountComputer(SkipCountComputer skipCountComputer) {
        if (skipCountComputer == null) {
            String string = Logging.getMessage("nullValue.CallbackIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.skipCountComputer = skipCountComputer;
    }

    @Override
    protected AbstractShape.AbstractShapeData createCacheEntry(DrawContext drawContext) {
        return new MultiResolutionPathData(drawContext, this);
    }

    @Override
    protected void makeTessellatedPositions(DrawContext drawContext, Path.PathData pathData) {
        if (this.numPositions < 2) {
            return;
        }
        MultiResolutionPathData multiResolutionPathData = (MultiResolutionPathData)pathData;
        if (multiResolutionPathData.positionOrdinals == null || multiResolutionPathData.positionOrdinals.capacity() < this.numPositions) {
            multiResolutionPathData.positionOrdinals = Buffers.newDirectIntBuffer((int)this.numPositions);
        } else {
            multiResolutionPathData.positionOrdinals.clear();
        }
        super.makeTessellatedPositions(drawContext, pathData);
        multiResolutionPathData.positionOrdinals.flip();
    }

    @Override
    protected void makePositions(DrawContext drawContext, Path.PathData pathData) {
        Iterator iterator = this.positions.iterator();
        Position position = (Position)iterator.next();
        int n = 0;
        Color color = this.getColor(position, n);
        this.addTessellatedPosition(position, color, n, pathData);
        int n2 = this.skipCountComputer.computeSkipCount(drawContext, pathData);
        Vec4 vec4 = this.computePoint(drawContext.getTerrain(), position);
        int n3 = 1;
        while (iterator.hasNext()) {
            Position position2 = (Position)iterator.next();
            if (n3 % n2 == 0 || !iterator.hasNext()) {
                Vec4 vec42 = this.computePoint(drawContext.getTerrain(), position2);
                if (!iterator.hasNext() || !this.isSmall(drawContext, vec4, vec42, 8) && this.isSegmentVisible(drawContext, position, position2, vec4, vec42)) {
                    Color color2 = this.getColor(position2, n3);
                    this.makeSegment(drawContext, position, position2, vec4, vec42, color, color2, n, n3, pathData);
                    position = position2;
                    vec4 = vec42;
                    color = color2;
                    n = n3;
                }
            }
            ++n3;
        }
    }

    @Override
    protected void addTessellatedPosition(Position position, Color color, Integer n, Path.PathData pathData) {
        if (n != null) {
            MultiResolutionPathData multiResolutionPathData = (MultiResolutionPathData)pathData;
            multiResolutionPathData.positionOrdinals.put(n);
        }
        super.addTessellatedPosition(position, color, n, pathData);
    }

    @Override
    protected Integer getOrdinal(int n) {
        MultiResolutionPathData multiResolutionPathData = (MultiResolutionPathData)this.getCurrentPathData();
        return multiResolutionPathData.positionOrdinals.get(n);
    }

    protected static class MultiResolutionPathData
    extends Path.PathData {
        protected IntBuffer positionOrdinals;

        public MultiResolutionPathData(DrawContext drawContext, Path path) {
            super(drawContext, path);
        }

        public IntBuffer getPositionOrdinals() {
            return this.positionOrdinals;
        }

        public void setPositionOrdinals(IntBuffer intBuffer) {
            this.positionOrdinals = intBuffer;
        }
    }

    public static interface SkipCountComputer {
        public int computeSkipCount(DrawContext var1, Path.PathData var2);
    }
}

