/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.render;

import com.jogamp.opengl.util.texture.TextureCoords;
import gov.nasa.worldwind.Movable;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Extent;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.render.AbstractSurfaceRenderable;
import gov.nasa.worldwind.render.BasicWWTexture;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.WWTexture;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.SurfaceTileDrawContext;
import java.awt.Color;
import java.awt.geom.Rectangle2D;
import java.util.List;
import javax.media.opengl.GL2;

public class SurfaceIcon
extends AbstractSurfaceRenderable
implements Movable {
    private Object imageSource;
    private boolean useMipMaps = true;
    private LatLon location;
    private Vec4 locationOffset;
    private double scale = 1.0;
    private Angle heading = Angle.ZERO;
    private Color color = Color.WHITE;
    private boolean maintainSize = false;
    private double maxSize = Double.MAX_VALUE;
    private double minSize = 0.1;
    protected WWTexture texture;
    protected int imageWidth = 32;
    protected int imageHeight = 32;

    public SurfaceIcon(Object object) {
        this(object, null);
    }

    public SurfaceIcon(Object object, LatLon latLon) {
        this.setImageSource(object);
        if (latLon != null) {
            this.setLocation(latLon);
        }
    }

    public LatLon getLocation() {
        return this.location;
    }

    public void setLocation(LatLon latLon) {
        if (latLon == null) {
            String string = Logging.getMessage("nullValue.LatLonIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.location = latLon;
        this.onPropertyChanged();
    }

    public Vec4 getLocationOffset() {
        return this.locationOffset;
    }

    public void setLocationOffset(Vec4 vec4) {
        this.locationOffset = vec4;
        this.onPropertyChanged();
    }

    public Object getImageSource() {
        return this.imageSource;
    }

    public void setImageSource(Object object) {
        if (object == null) {
            String string = Logging.getMessage("nullValue.ImageSource");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.imageSource = object;
        this.texture = null;
        this.onPropertyChanged();
    }

    public boolean isUseMipMaps() {
        return this.useMipMaps;
    }

    public void setUseMipMaps(boolean bl) {
        this.useMipMaps = bl;
        this.texture = null;
        this.onPropertyChanged();
    }

    public double getScale() {
        return this.scale;
    }

    public void setScale(double d) {
        if (d <= 0.0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "scale must be greater then zero");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.scale = d;
        this.onPropertyChanged();
    }

    public Angle getHeading() {
        return this.heading;
    }

    public void setHeading(Angle angle) {
        this.heading = angle;
        this.onPropertyChanged();
    }

    public boolean isMaintainSize() {
        return this.maintainSize;
    }

    public void setMaintainSize(boolean bl) {
        this.maintainSize = bl;
    }

    public double getMinSize() {
        return this.minSize;
    }

    public void setMinSize(double d) {
        this.minSize = d;
        this.onPropertyChanged();
    }

    public double getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(double d) {
        this.maxSize = d;
        this.onPropertyChanged();
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        if (color == null) {
            String string = Logging.getMessage("nullValue.ColorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.color = color;
        this.onPropertyChanged();
    }

    protected boolean isMaintainAppearance() {
        return this.getHeading() == null || this.isMaintainSize();
    }

    @Override
    public Object getStateKey(DrawContext drawContext) {
        if (this.isMaintainAppearance()) {
            return new Object();
        }
        return super.getStateKey(drawContext);
    }

    @Override
    public List<Sector> getSectors(DrawContext drawContext) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return this.computeSectors(drawContext);
    }

    @Override
    public Extent getExtent(DrawContext drawContext) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return this.computeExtent(drawContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void drawGeographic(DrawContext drawContext, SurfaceTileDrawContext surfaceTileDrawContext) {
        WWTexture wWTexture = this.getTexture();
        if (wWTexture == null) {
            return;
        }
        this.beginDraw(drawContext);
        try {
            if (wWTexture.bind(drawContext)) {
                this.imageWidth = wWTexture.getWidth(drawContext);
                this.imageHeight = wWTexture.getHeight(drawContext);
                GL2 gL2 = drawContext.getGL().getGL2();
                gL2.glMatrixMode(5890);
                this.getTexture().applyInternalTransform(drawContext);
                this.applyDrawColor(drawContext);
                this.drawIcon(drawContext, surfaceTileDrawContext);
            }
        }
        catch (Exception exception) {
        }
        finally {
            this.endDraw(drawContext);
        }
    }

    protected void onPropertyChanged() {
        this.updateModifiedTime();
        this.clearCaches();
    }

    @Override
    protected void clearCaches() {
        super.clearCaches();
    }

    protected List<Sector> computeSectors(DrawContext drawContext) {
        if (this.location == null) {
            return null;
        }
        Globe globe = drawContext.getGlobe();
        Rectangle2D.Double double_ = this.computeDrawDimension(drawContext, this.location);
        if (!this.isMaintainAppearance()) {
            double_.setRect(double_.x, double_.y, double_.width * 2.0, double_.height * 2.0);
        }
        double d = Math.max(this.location.getLatitude().cos(), 0.01);
        double d2 = double_.height / globe.getRadius();
        double d3 = double_.width / globe.getRadius() / d;
        double d4 = this.locationOffset != null ? this.locationOffset.y * d2 / (double)this.imageHeight : 0.0;
        double d5 = this.locationOffset != null ? this.locationOffset.x * d3 / (double)this.imageWidth : 0.0;
        Sector sector = new Sector(this.location.getLatitude().subtractRadians(d2 / 2.0).addRadians(d4), this.location.getLatitude().addRadians(d2 / 2.0).addRadians(d4), this.location.getLongitude().subtractRadians(d3 / 2.0).addRadians(d5), this.location.getLongitude().addRadians(d3 / 2.0).addRadians(d5));
        sector = this.computeRotatedSectorBounds(sector, this.location, this.computeDrawHeading(drawContext));
        return this.computeNormalizedSectors(sector);
    }

    protected Rectangle2D.Double computeDrawDimension(DrawContext drawContext, LatLon latLon) {
        double d = this.computePixelSizeAtLocation(drawContext, latLon);
        return this.computeDrawDimension(d);
    }

    protected Rectangle2D.Double computeDrawDimension(double d) {
        double d2;
        double d3 = (double)this.imageHeight * this.scale * d;
        double d4 = (double)this.imageWidth * this.scale * d;
        double d5 = d2 = d3 > d4 ? d3 : d4;
        double d6 = d2 > this.maxSize ? this.maxSize / d2 : (d2 < this.minSize ? this.minSize / d2 : 1.0);
        return new Rectangle2D.Double(0.0, 0.0, d4 * d6, d3 * d6);
    }

    protected Angle computeDrawHeading(DrawContext drawContext) {
        if (this.heading != null) {
            return this.heading;
        }
        return this.getViewHeading(drawContext);
    }

    protected void beginDraw(DrawContext drawContext) {
        GL2 gL2 = drawContext.getGL().getGL2();
        int n = 28673;
        gL2.glPushAttrib(n);
        gL2.glEnable(3008);
        gL2.glAlphaFunc(516, 0.001f);
        gL2.glMatrixMode(5890);
        gL2.glPushMatrix();
        gL2.glMatrixMode(5888);
        gL2.glPushMatrix();
        if (drawContext.isPickingMode()) {
            gL2.glEnable(3553);
            gL2.glTexEnvf(8960, 8704, 34160.0f);
            gL2.glTexEnvf(8960, 34176, 34168.0f);
            gL2.glTexEnvf(8960, 34161, 7681.0f);
        } else {
            gL2.glEnable(3553);
            gL2.glEnable(3042);
            gL2.glBlendFunc(1, 771);
        }
    }

    protected void endDraw(DrawContext drawContext) {
        GL2 gL2 = drawContext.getGL().getGL2();
        if (drawContext.isPickingMode()) {
            gL2.glTexEnvf(8960, 8704, 8448.0f);
            gL2.glTexEnvf(8960, 34176, 5890.0f);
            gL2.glTexEnvf(8960, 34161, 8448.0f);
        }
        gL2.glBindTexture(3553, 0);
        gL2.glMatrixMode(5888);
        gL2.glPopMatrix();
        gL2.glMatrixMode(5890);
        gL2.glPopMatrix();
        gL2.glPopAttrib();
    }

    protected void applyDrawTransform(DrawContext drawContext, SurfaceTileDrawContext surfaceTileDrawContext, LatLon latLon, double d) {
        double d2 = this.computeHemisphereOffset(surfaceTileDrawContext.getSector(), latLon);
        Vec4 vec4 = new Vec4(latLon.getLongitude().degrees + d2, latLon.getLatitude().degrees, 1.0);
        vec4 = vec4.transformBy4(surfaceTileDrawContext.getModelviewMatrix());
        GL2 gL2 = drawContext.getGL().getGL2();
        gL2.glTranslated(vec4.x(), vec4.y(), vec4.z());
        gL2.glScaled(d / latLon.getLatitude().cos(), d, 1.0);
        gL2.glRotated(this.computeDrawHeading((DrawContext)drawContext).degrees, 0.0, 0.0, -1.0);
        gL2.glTranslated((double)(-this.imageWidth / 2), (double)(-this.imageHeight / 2), 0.0);
        if (this.locationOffset != null) {
            gL2.glTranslated(this.locationOffset.x, this.locationOffset.y, 0.0);
        }
    }

    protected double computeDrawScale(DrawContext drawContext, SurfaceTileDrawContext surfaceTileDrawContext, LatLon latLon) {
        double d = this.computeDrawPixelSize(drawContext, surfaceTileDrawContext);
        double d2 = this.isMaintainAppearance() ? this.computeDrawDimension((DrawContext)drawContext, (LatLon)latLon).width / (double)this.imageWidth : this.computeDrawDimension((double)d).width / (double)this.imageWidth;
        return d2 / d;
    }

    protected void applyDrawColor(DrawContext drawContext) {
        if (!drawContext.isPickingMode()) {
            GL2 gL2 = drawContext.getGL().getGL2();
            this.applyPremultipliedAlphaColor(gL2, this.color, this.getOpacity());
        }
    }

    protected void drawIcon(DrawContext drawContext, SurfaceTileDrawContext surfaceTileDrawContext) {
        GL2 gL2 = drawContext.getGL().getGL2();
        gL2.glMatrixMode(5888);
        double d = this.computeDrawScale(drawContext, surfaceTileDrawContext, this.location);
        this.applyDrawTransform(drawContext, surfaceTileDrawContext, this.location, d);
        gL2.glScaled((double)this.imageWidth, (double)this.imageHeight, 1.0);
        drawContext.drawUnitQuad(new TextureCoords(0.0f, 0.0f, 1.0f, 1.0f));
    }

    protected WWTexture getTexture() {
        if (this.texture == null) {
            this.texture = new BasicWWTexture(this.imageSource, this.useMipMaps);
        }
        return this.texture;
    }

    @Override
    public Position getReferencePosition() {
        return new Position(this.location, 0.0);
    }

    @Override
    public void move(Position position) {
        if (position == null) {
            String string = Logging.getMessage("nullValue.PositionIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Position position2 = this.getReferencePosition();
        if (position2 == null) {
            return;
        }
        this.moveTo(position2.add(position));
    }

    @Override
    public void moveTo(Position position) {
        if (position == null) {
            String string = Logging.getMessage("nullValue.PositionIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.setLocation(position);
    }

    protected static class SectorInfo {
        protected List<Sector> sectors;
        protected Object globeStateKey;

        public SectorInfo(List<Sector> list, DrawContext drawContext) {
            this.sectors = list;
            this.globeStateKey = drawContext.getGlobe().getStateKey(drawContext);
        }

        public boolean isValid(DrawContext drawContext) {
            return this.globeStateKey.equals(drawContext.getGlobe().getStateKey(drawContext));
        }
    }
}

