/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.render;

import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.render.ShapeAttributes;
import gov.nasa.worldwind.render.SurfaceQuad;
import gov.nasa.worldwind.util.Logging;

public class SurfaceSquare
extends SurfaceQuad {
    public SurfaceSquare() {
    }

    public SurfaceSquare(ShapeAttributes shapeAttributes) {
        super(shapeAttributes);
    }

    public SurfaceSquare(LatLon latLon, double d) {
        super(latLon, d, d);
    }

    public SurfaceSquare(LatLon latLon, double d, Angle angle) {
        super(latLon, d, d, angle);
    }

    public SurfaceSquare(ShapeAttributes shapeAttributes, LatLon latLon, double d) {
        super(shapeAttributes, latLon, d, d);
    }

    public SurfaceSquare(ShapeAttributes shapeAttributes, LatLon latLon, double d, Angle angle) {
        super(shapeAttributes, latLon, d, d, angle);
    }

    public double getSize() {
        return this.getWidth();
    }

    public void setSize(double d) {
        if (d < 0.0) {
            String string = Logging.getMessage("Geom.SizeIsNegative", d);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.setSize(d, d);
    }
}

