/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.symbology.milstd2525.graphics.areas;

import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.Path;
import gov.nasa.worldwind.symbology.milstd2525.graphics.areas.AttackByFirePosition;
import gov.nasa.worldwind.util.Logging;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class SupportByFirePosition
extends AttackByFirePosition {
    protected Position position4;

    public static List<String> getSupportedGraphics() {
        return Arrays.asList("G-G-OAS--------");
    }

    public SupportByFirePosition(String string) {
        super(string);
    }

    @Override
    public void setPositions(Iterable<? extends Position> iterable) {
        if (iterable == null) {
            String string = Logging.getMessage("nullValue.PositionsListIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        try {
            Iterator<? extends Position> iterator = iterable.iterator();
            this.position1 = iterator.next();
            this.position2 = iterator.next();
            this.position3 = iterator.next();
            this.position4 = iterator.next();
        }
        catch (NoSuchElementException noSuchElementException) {
            String string = Logging.getMessage("generic.InsufficientPositions");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.paths = null;
    }

    @Override
    public Iterable<? extends Position> getPositions() {
        return Arrays.asList(this.position1, this.position2, this.position3, this.position4);
    }

    @Override
    protected void createShapes(DrawContext drawContext) {
        this.paths = new Path[5];
        this.paths[0] = this.createPath(Arrays.asList(this.position1, this.position3));
        this.paths[1] = this.createPath(Arrays.asList(this.position2, this.position4));
        List<Position> list = this.computeArrowheadPositions(drawContext, this.position1, this.position3);
        this.paths[2] = this.createPath(list);
        list = this.computeArrowheadPositions(drawContext, this.position2, this.position4);
        this.paths[3] = this.createPath(list);
        list = this.computeBasePositions(drawContext, this.position1, this.position2, this.position3);
        this.paths[4] = this.createPath(list);
    }
}

