/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.util;

import gov.nasa.worldwind.util.Logging;
import java.util.Arrays;

public class CompoundStringBuilder {
    protected static final int DEFAULT_INITIAL_CAPACITY = 16;
    protected StringBuilder buffer;
    protected int count;
    protected int capacity;
    protected int[] offsets;
    protected int[] lengths;

    public CompoundStringBuilder(StringBuilder stringBuilder, int n) {
        if (stringBuilder == null) {
            String string = Logging.getMessage("nullValue.StringBuilderIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (n < 1) {
            String string = Logging.getMessage("generic.CapacityIsInvalid", n);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.buffer = stringBuilder;
        this.capacity = n;
        this.offsets = new int[this.capacity];
        this.lengths = new int[this.capacity];
    }

    public CompoundStringBuilder(int n) {
        this(new StringBuilder(), n);
    }

    public CompoundStringBuilder() {
        this(new StringBuilder(), 16);
    }

    public int size() {
        return this.count;
    }

    public int substringLength(int n) {
        if (n < 0 || n >= this.count) {
            String string = Logging.getMessage("generic.indexOutOfRange", n);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return this.lengths[n];
    }

    public String substring(int n) {
        if (n < 0 || n >= this.count) {
            String string = Logging.getMessage("generic.indexOutOfRange", n);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        CharSequence charSequence = this.subSequence(n);
        return charSequence != null ? charSequence.toString() : null;
    }

    public CharSequence subSequence(int n) {
        if (n < 0 || n >= this.count) {
            String string = Logging.getMessage("generic.indexOutOfRange", n);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        int n2 = this.offsets[n];
        int n3 = this.lengths[n];
        return this.buffer.subSequence(n2, n2 + n3);
    }

    public int append(CharSequence charSequence) {
        if (charSequence == null) {
            String string = Logging.getMessage("nullValue.CharSequenceIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        int n = 1 + this.count;
        if (n > this.capacity) {
            this.expandCapacity(n);
        }
        int n2 = this.count++;
        this.offsets[n2] = this.buffer.length();
        this.lengths[n2] = charSequence.length();
        this.buffer.append(charSequence, 0, charSequence.length());
        return n2;
    }

    public void clear() {
        this.buffer.delete(0, this.buffer.length());
        this.count = 0;
    }

    protected void expandCapacity(int n) {
        int n2 = 2 * this.capacity;
        if (n2 < 0) {
            n2 = Integer.MAX_VALUE;
        } else if (n2 < n) {
            n2 = n;
        }
        this.offsets = Arrays.copyOf(this.offsets, n2);
        this.lengths = Arrays.copyOf(this.lengths, n2);
        this.capacity = n2;
    }
}

