/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.util;

import gov.nasa.worldwind.geom.Extent;
import gov.nasa.worldwind.geom.PickPointFrustum;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.util.Logging;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;

public class PickPointFrustumList
extends ArrayList<PickPointFrustum> {
    public PickPointFrustumList() {
    }

    public PickPointFrustumList(PickPointFrustumList pickPointFrustumList) {
        super(pickPointFrustumList);
    }

    public final boolean containsInAll(Vec4 vec4) {
        if (vec4 == null) {
            String string = Logging.getMessage("nullValue.PointIsNull");
            Logging.logger().fine(string);
            throw new IllegalArgumentException(string);
        }
        for (PickPointFrustum pickPointFrustum : this) {
            if (pickPointFrustum.contains(vec4)) continue;
            return false;
        }
        return true;
    }

    public final boolean containsInAny(Vec4 vec4) {
        if (vec4 == null) {
            String string = Logging.getMessage("nullValue.PointIsNull");
            Logging.logger().fine(string);
            throw new IllegalArgumentException(string);
        }
        for (PickPointFrustum pickPointFrustum : this) {
            if (!pickPointFrustum.contains(vec4)) continue;
            return true;
        }
        return false;
    }

    public final boolean containsInAll(Point point) {
        if (point == null) {
            String string = Logging.getMessage("nullValue.PointIsNull");
            Logging.logger().fine(string);
            throw new IllegalArgumentException(string);
        }
        for (PickPointFrustum pickPointFrustum : this) {
            if (pickPointFrustum.contains(point)) continue;
            return false;
        }
        return true;
    }

    public final boolean containsInAny(double d, double d2) {
        for (PickPointFrustum pickPointFrustum : this) {
            if (!pickPointFrustum.contains(d, d2)) continue;
            return true;
        }
        return false;
    }

    public final boolean containsInAny(Point point) {
        if (point == null) {
            String string = Logging.getMessage("nullValue.PointIsNull");
            Logging.logger().fine(string);
            throw new IllegalArgumentException(string);
        }
        for (PickPointFrustum pickPointFrustum : this) {
            if (!pickPointFrustum.contains(point)) continue;
            return true;
        }
        return false;
    }

    public final boolean intersectsAll(Extent extent) {
        if (extent == null) {
            String string = Logging.getMessage("nullValue.ExtentIsNull");
            Logging.logger().fine(string);
            throw new IllegalArgumentException(string);
        }
        for (PickPointFrustum pickPointFrustum : this) {
            if (pickPointFrustum.intersects(extent)) continue;
            return false;
        }
        return true;
    }

    public final boolean intersectsAny(Extent extent) {
        if (extent == null) {
            String string = Logging.getMessage("nullValue.ExtentIsNull");
            Logging.logger().fine(string);
            throw new IllegalArgumentException(string);
        }
        for (PickPointFrustum pickPointFrustum : this) {
            if (!pickPointFrustum.intersects(extent)) continue;
            return true;
        }
        return false;
    }

    public final boolean intersectsAny(Vec4 vec4, Vec4 vec42) {
        for (PickPointFrustum pickPointFrustum : this) {
            if (!pickPointFrustum.intersectsSegment(vec4, vec42)) continue;
            return true;
        }
        return false;
    }

    public final boolean intersectsAll(Rectangle rectangle) {
        if (rectangle == null) {
            String string = Logging.getMessage("nullValue.RectangleIsNull");
            Logging.logger().fine(string);
            throw new IllegalArgumentException(string);
        }
        for (PickPointFrustum pickPointFrustum : this) {
            if (pickPointFrustum.intersects(rectangle)) continue;
            return false;
        }
        return true;
    }

    public final boolean intersectsAny(Rectangle rectangle) {
        if (rectangle == null) {
            String string = Logging.getMessage("nullValue.RectangleIsNull");
            Logging.logger().fine(string);
            throw new IllegalArgumentException(string);
        }
        for (PickPointFrustum pickPointFrustum : this) {
            if (!pickPointFrustum.intersects(rectangle)) continue;
            return true;
        }
        return false;
    }
}

