/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.util.tree;

import com.jogamp.opengl.util.awt.TextRenderer;
import com.jogamp.opengl.util.texture.TextureCoords;
import gov.nasa.worldwind.WWObjectImpl;
import gov.nasa.worldwind.event.SelectEvent;
import gov.nasa.worldwind.pick.PickSupport;
import gov.nasa.worldwind.pick.PickedObject;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.MultiLineTextRenderer;
import gov.nasa.worldwind.render.Offset;
import gov.nasa.worldwind.render.PreRenderable;
import gov.nasa.worldwind.render.WWTexture;
import gov.nasa.worldwind.util.BoundedHashMap;
import gov.nasa.worldwind.util.HotSpot;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.OGLTextRenderer;
import gov.nasa.worldwind.util.OGLUtil;
import gov.nasa.worldwind.util.tree.BasicTreeAttributes;
import gov.nasa.worldwind.util.tree.ScrollFrame;
import gov.nasa.worldwind.util.tree.Scrollable;
import gov.nasa.worldwind.util.tree.Tree;
import gov.nasa.worldwind.util.tree.TreeAttributes;
import gov.nasa.worldwind.util.tree.TreeHotSpot;
import gov.nasa.worldwind.util.tree.TreeLayout;
import gov.nasa.worldwind.util.tree.TreeModel;
import gov.nasa.worldwind.util.tree.TreeNode;
import gov.nasa.worldwind.util.tree.TreePath;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.media.opengl.GL2;

public class BasicTreeLayout
extends WWObjectImpl
implements TreeLayout,
Scrollable,
PreRenderable {
    protected Tree tree;
    protected ScrollFrame frame;
    protected TreeAttributes normalAttributes = new BasicTreeAttributes();
    protected TreeAttributes highlightAttributes = new BasicTreeAttributes();
    protected TreeAttributes activeAttributes = new BasicTreeAttributes();
    protected static final TreeAttributes defaultAttributes = new BasicTreeAttributes();
    protected boolean highlighted;
    protected PickSupport pickSupport = new PickSupport();
    protected TreeNode scrollToNode;
    protected Dimension size;
    protected boolean mustRecomputeSize = true;
    protected boolean mustRecomputeLayout = true;
    protected boolean showDescription = true;
    protected boolean drawNodeStateSymbol = true;
    protected boolean drawSelectedSymbol = true;
    protected boolean wrapText = true;
    protected int maxWrappedLines = 2;
    protected BoundedHashMap<TextCacheKey, Rectangle2D> textCache = new BoundedHashMap();
    protected BoundedHashMap<TreeNode, NodeLayout> layoutCache = new BoundedHashMap();
    protected List<NodeLayout> treeNodes = new ArrayList<NodeLayout>();
    protected int padding = 10;
    protected long frameNumber = -1L;
    protected long attributesFrameNumber = -1L;
    protected Point screenLocation;
    protected long updateTime;
    protected Dimension previousFrameSize;
    protected Dimension previousSizeBounds;
    protected int lineHeight;
    protected int nodeCount;
    protected int indent;

    public BasicTreeLayout(Tree tree) {
        this(tree, null);
    }

    public BasicTreeLayout(Tree tree, int n, int n2) {
        this(tree, new Offset(Double.valueOf(n), Double.valueOf(n2), "gov.nasa.worldwind.avkey.Pixels", "gov.nasa.worldwind.avkey.InsetPixels"));
    }

    public BasicTreeLayout(Tree tree, Offset offset) {
        this.tree = tree;
        this.frame = this.createFrame();
        this.frame.setContents(this);
        this.frame.addPropertyChangeListener(this);
        this.tree.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getSource() != BasicTreeLayout.this && !"gov.nasa.worldwind.avkey.Repaint".equals(propertyChangeEvent.getPropertyName())) {
                    BasicTreeLayout.this.invalidate();
                }
            }
        });
        if (offset != null) {
            this.setScreenLocation(offset);
        }
    }

    public boolean isWrapText() {
        return this.wrapText;
    }

    public void setWrapText(boolean bl) {
        this.wrapText = bl;
    }

    protected Dimension getNodeStateSymbolSize() {
        return new Dimension(12, 12);
    }

    protected Dimension getSelectedSymbolSize() {
        return new Dimension(12, 12);
    }

    public boolean isShowDescription() {
        return this.showDescription;
    }

    public void setShowDescription(boolean bl) {
        this.showDescription = bl;
    }

    public boolean isDrawSelectedSymbol() {
        return this.drawSelectedSymbol;
    }

    public void setDrawSelectedSymbol(boolean bl) {
        this.drawSelectedSymbol = bl;
    }

    public boolean isDrawNodeStateSymbol() {
        return this.drawNodeStateSymbol;
    }

    public int getMaxWrappedLines() {
        return this.maxWrappedLines;
    }

    public void setMaxWrappedLines(int n) {
        if (n != this.maxWrappedLines) {
            this.maxWrappedLines = n;
            this.invalidate();
            this.invalidateWrappedText();
        }
    }

    public void setDrawNodeStateSymbol(boolean bl) {
        this.drawNodeStateSymbol = bl;
    }

    @Override
    public long getUpdateTime() {
        return this.updateTime;
    }

    protected ScrollFrame createFrame() {
        return new ScrollFrame();
    }

    @Override
    public Dimension getSize(DrawContext drawContext, Dimension dimension) {
        this.updateAttributes(drawContext);
        if (this.mustRecomputeSize(dimension)) {
            TreeModel treeModel = this.tree.getModel();
            TreeNode treeNode = treeModel.getRoot();
            this.size = new Dimension();
            this.nodeCount = 0;
            this.computeSize(this.tree, treeNode, drawContext, dimension, this.size, 0, 1);
            this.layoutCache.setCapacity(this.nodeCount);
            this.textCache.setCapacity(this.nodeCount * 2);
            this.size.height += this.padding;
            this.mustRecomputeSize = false;
            this.previousSizeBounds = dimension;
            this.markUpdated();
        }
        return this.size;
    }

    protected void computeSize(Tree tree, TreeNode treeNode, DrawContext drawContext, Dimension dimension, Dimension dimension2, int n, int n2) {
        ++this.nodeCount;
        TreeAttributes treeAttributes = this.getActiveAttributes();
        Dimension dimension3 = this.getNodeSize(drawContext, dimension, n, treeNode, treeAttributes);
        int n3 = 0;
        if (this.mustDisplayNode(treeNode, n2)) {
            int n4 = dimension3.width + n;
            if (n4 > dimension2.width) {
                dimension2.width = n4;
            }
            dimension2.height += dimension3.height;
            dimension2.height += treeAttributes.getRowSpacing();
            n3 = this.indent;
        }
        if (tree.isNodeExpanded(treeNode)) {
            for (TreeNode treeNode2 : treeNode.getChildren()) {
                this.computeSize(tree, treeNode2, drawContext, dimension, dimension2, n + n3, n2 + 1);
            }
        }
    }

    public void invalidate() {
        this.markUpdated();
        this.mustRecomputeSize = true;
        this.mustRecomputeLayout = true;
    }

    protected void markUpdated() {
        this.updateTime = System.currentTimeMillis();
    }

    protected boolean mustDisplayNode(TreeNode treeNode, int n) {
        return treeNode.isVisible() && (n > 1 || this.getActiveAttributes().isRootVisible());
    }

    @Override
    public void preRender(DrawContext drawContext) {
        this.scrollToNode(drawContext);
        this.frame.preRender(drawContext);
    }

    @Override
    public void render(DrawContext drawContext) {
        this.frame.render(drawContext);
    }

    protected synchronized void scrollToNode(DrawContext drawContext) {
        if (this.scrollToNode != null) {
            ScrollFrame scrollFrame = this.getFrame();
            scrollFrame.updateBounds(drawContext);
            Point point = new Point(0, 0);
            Rectangle rectangle = this.findNodeBounds(this.scrollToNode, this.tree.getModel().getRoot(), drawContext, scrollFrame.getBounds(drawContext).getSize(), point, 1);
            int n = (int)Math.abs(rectangle.getMaxY()) - this.getActiveAttributes().getRowSpacing();
            this.frame.getScrollBar("gov.nasa.worldwind.avkey.Vertical").setValue(n);
            this.scrollToNode = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void renderScrollable(DrawContext drawContext, Point point, Dimension dimension, Rectangle rectangle) {
        TreeModel treeModel = this.tree.getModel();
        TreeNode treeNode = treeModel.getRoot();
        this.screenLocation = point;
        this.updateAttributes(drawContext);
        if (this.frameNumber != drawContext.getFrameTimeStamp()) {
            if (this.mustRecomputeTreeLayout(dimension)) {
                this.treeNodes.clear();
                Point point2 = new Point(0, this.size.height);
                this.computeTreeLayout(treeNode, drawContext, dimension, point2, 1, this.treeNodes);
                this.previousFrameSize = dimension;
                this.mustRecomputeLayout = false;
            }
            this.frameNumber = drawContext.getFrameTimeStamp();
        }
        try {
            if (drawContext.isPickingMode()) {
                this.pickSupport.clearPickList();
                this.pickSupport.beginPicking(drawContext);
            }
            this.renderNodes(drawContext, point, this.treeNodes, rectangle);
        }
        finally {
            if (drawContext.isPickingMode()) {
                this.pickSupport.endPicking(drawContext);
                this.pickSupport.resolvePick(drawContext, drawContext.getPickPoint(), drawContext.getCurrentLayer());
            }
        }
    }

    protected boolean mustRecomputeTreeLayout(Dimension dimension) {
        return this.mustRecomputeLayout || this.previousFrameSize == null || this.previousFrameSize.width != dimension.width;
    }

    protected boolean mustRecomputeSize(Dimension dimension) {
        return this.mustRecomputeSize || this.previousSizeBounds == null && dimension != null || dimension != null && this.previousSizeBounds.width != dimension.width;
    }

    protected void updateAttributes(DrawContext drawContext) {
        if (drawContext.getFrameTimeStamp() != this.attributesFrameNumber) {
            this.determineActiveAttributes();
            this.indent = this.computeIndentation();
            this.lineHeight = this.computeMaxTextHeight(drawContext);
            this.attributesFrameNumber = drawContext.getFrameTimeStamp();
        }
    }

    protected int computeIndentation() {
        int n = this.getActiveAttributes().getIconSize().width;
        int n2 = this.getActiveAttributes().getIconSpace();
        int n3 = this.getSelectedSymbolSize().width;
        return n3 + n2 + (n - n3) / 2;
    }

    protected int computeMaxTextHeight(DrawContext drawContext) {
        TreeAttributes treeAttributes = this.getActiveAttributes();
        Rectangle2D rectangle2D = this.getTextBounds(drawContext, "_\u00c9", treeAttributes.getFont());
        double d = Math.abs(rectangle2D.getY());
        return (int)Math.max(d, (double)treeAttributes.getIconSize().height);
    }

    protected void renderNodes(DrawContext drawContext, Point point, Iterable<NodeLayout> iterable, Rectangle rectangle) {
        ArrayList<NodeLayout> arrayList = new ArrayList<NodeLayout>();
        for (NodeLayout nodeLayout : iterable) {
            nodeLayout.reset(point);
            if (!this.intersectsFrustum(drawContext, nodeLayout, rectangle)) continue;
            arrayList.add(nodeLayout);
        }
        if (this.isDrawNodeStateSymbol()) {
            this.drawTriangles(drawContext, arrayList);
        }
        if (this.isDrawSelectedSymbol()) {
            this.drawCheckboxes(drawContext, arrayList);
        }
        if (!drawContext.isPickingMode()) {
            this.drawIcons(drawContext, arrayList);
            this.drawText(drawContext, arrayList);
            if (this.isShowDescription()) {
                this.drawDescriptionText(drawContext, arrayList);
            }
        } else {
            this.pickTextAndIcon(drawContext, arrayList);
        }
    }

    protected boolean intersectsFrustum(DrawContext drawContext, NodeLayout nodeLayout, Rectangle rectangle) {
        if (!rectangle.intersects(nodeLayout.screenBounds)) {
            return false;
        }
        return !drawContext.isPickingMode() || drawContext.getPickFrustums().intersectsAny(nodeLayout.pickScreenBounds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void pickTextAndIcon(DrawContext drawContext, Iterable<NodeLayout> iterable) {
        GL2 gL2 = drawContext.getGL().getGL2();
        try {
            gL2.glBegin(7);
            for (NodeLayout nodeLayout : iterable) {
                Color color = drawContext.getUniquePickColor();
                PickedObject pickedObject = new PickedObject(color.getRGB(), nodeLayout.node);
                pickedObject.setValue("gov.nasa.worldwind.avkey.HotSpot", this.getFrame());
                this.pickSupport.addPickableObject(pickedObject);
                gL2.glColor3ub((byte)color.getRed(), (byte)color.getGreen(), (byte)color.getBlue());
                float f = nodeLayout.drawPoint.x;
                float f2 = nodeLayout.drawPoint.y;
                float f3 = (float)nodeLayout.screenBounds.getMaxX();
                float f4 = (float)nodeLayout.screenBounds.getMaxY();
                gL2.glVertex2f(f, f4);
                gL2.glVertex2f(f3, f4);
                gL2.glVertex2f(f3, f2);
                gL2.glVertex2f(f, f2);
            }
        }
        finally {
            gL2.glEnd();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void drawText(DrawContext drawContext, Iterable<NodeLayout> iterable) {
        GL2 gL2 = drawContext.getGL().getGL2();
        TreeAttributes treeAttributes = this.getActiveAttributes();
        Color color = treeAttributes.getColor();
        float[] fArray = color.getRGBColorComponents(null);
        TextRenderer textRenderer = OGLTextRenderer.getOrCreateTextRenderer(drawContext.getTextRendererCache(), treeAttributes.getFont(), true, false, false);
        gL2.glPolygonMode(1028, 6914);
        try {
            textRenderer.begin3DRendering();
            textRenderer.setColor(fArray[0], fArray[1], fArray[2], 1.0f);
            for (NodeLayout nodeLayout : iterable) {
                String string = this.getText(nodeLayout.node);
                Rectangle2D rectangle2D = this.getTextBounds(drawContext, string, treeAttributes.getFont());
                int n = (int)Math.abs(rectangle2D.getY());
                int n2 = nodeLayout.bounds.height - n - (this.lineHeight - n) / 2;
                textRenderer.draw(string, nodeLayout.drawPoint.x, nodeLayout.drawPoint.y + n2);
            }
        }
        finally {
            textRenderer.end3DRendering();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void drawDescriptionText(DrawContext drawContext, Iterable<NodeLayout> iterable) {
        TreeAttributes treeAttributes = this.getActiveAttributes();
        Color color = treeAttributes.getColor();
        float[] fArray = color.getRGBColorComponents(null);
        TextRenderer textRenderer = OGLTextRenderer.getOrCreateTextRenderer(drawContext.getTextRendererCache(), treeAttributes.getDescriptionFont(), true, false, false);
        MultiLineTextRenderer multiLineTextRenderer = new MultiLineTextRenderer(textRenderer);
        try {
            textRenderer.begin3DRendering();
            textRenderer.setColor(fArray[0], fArray[1], fArray[2], 1.0f);
            for (NodeLayout nodeLayout : iterable) {
                String string = nodeLayout.node.getDescription();
                if (string == null) continue;
                String string2 = this.computeWrappedText(drawContext, nodeLayout.node, treeAttributes.getDescriptionFont(), (int)(nodeLayout.screenBounds.getMaxX() - (double)nodeLayout.drawPoint.x));
                int n = nodeLayout.bounds.height - this.lineHeight;
                multiLineTextRenderer.draw(string2, nodeLayout.drawPoint.x, nodeLayout.drawPoint.y + n);
            }
        }
        finally {
            textRenderer.end3DRendering();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void drawIcons(DrawContext drawContext, Iterable<NodeLayout> iterable) {
        GL2 gL2 = drawContext.getGL().getGL2();
        try {
            gL2.glPolygonMode(1028, 6914);
            gL2.glEnable(3553);
            TreeAttributes treeAttributes = this.getActiveAttributes();
            Dimension dimension = treeAttributes.getIconSize();
            gL2.glColor4d(1.0, 1.0, 1.0, 1.0);
            WWTexture wWTexture = null;
            for (NodeLayout nodeLayout : iterable) {
                boolean bl;
                WWTexture wWTexture2 = nodeLayout.node.getTexture();
                if (wWTexture2 == null) continue;
                if (wWTexture != null && wWTexture2.getImageSource() == wWTexture.getImageSource()) {
                    bl = true;
                } else {
                    bl = wWTexture2.bind(drawContext);
                    if (bl) {
                        wWTexture = wWTexture2;
                    }
                }
                if (!bl) continue;
                int n = 0;
                if (dimension.height < nodeLayout.bounds.height) {
                    n = nodeLayout.bounds.height - dimension.height - (this.lineHeight - dimension.height) / 2;
                }
                try {
                    gL2.glPushMatrix();
                    TextureCoords textureCoords = wWTexture.getTexCoords();
                    gL2.glTranslated((double)nodeLayout.drawPoint.x, (double)(nodeLayout.drawPoint.y + n), 1.0);
                    gL2.glScaled((double)dimension.width, (double)dimension.width, 1.0);
                    drawContext.drawUnitQuad(textureCoords);
                }
                finally {
                    gL2.glPopMatrix();
                }
                nodeLayout.drawPoint.x += treeAttributes.getIconSize().width + treeAttributes.getIconSpace();
            }
        }
        finally {
            gL2.glDisable(3553);
            gL2.glBindTexture(3553, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void drawCheckboxes(DrawContext drawContext, Iterable<NodeLayout> iterable) {
        Dimension dimension;
        GL2 gL2 = drawContext.getGL().getGL2();
        if (!drawContext.isPickingMode()) {
            this.drawFilledCheckboxes(drawContext, iterable);
            this.drawCheckmarks(drawContext, iterable);
            dimension = this.getSelectedSymbolSize();
        } else {
            dimension = new Dimension(this.getSelectedSymbolSize().width + this.getActiveAttributes().getIconSpace(), this.lineHeight + this.getActiveAttributes().getRowSpacing());
        }
        if (drawContext.isPickingMode()) {
            gL2.glBegin(7);
        }
        try {
            for (NodeLayout nodeLayout : iterable) {
                int n = nodeLayout.bounds.height - dimension.height - (this.lineHeight - dimension.height) / 2;
                int n2 = nodeLayout.drawPoint.x;
                int n3 = nodeLayout.drawPoint.y + n;
                int n4 = dimension.width;
                if (!drawContext.isPickingMode()) {
                    gL2.glBegin(2);
                    try {
                        gL2.glVertex2f((float)(n2 + n4), (float)(n3 + dimension.height) + 0.5f);
                        gL2.glVertex2f((float)n2, (float)(n3 + dimension.height) + 0.5f);
                        gL2.glVertex2f((float)n2, (float)n3);
                        gL2.glVertex2f((float)(n2 + n4), (float)n3 + 0.5f);
                    }
                    finally {
                        gL2.glEnd();
                    }
                } else {
                    Color color = drawContext.getUniquePickColor();
                    int n5 = color.getRGB();
                    this.pickSupport.addPickableObject(n5, this.createSelectControl(nodeLayout.node));
                    gL2.glColor3ub((byte)color.getRed(), (byte)color.getGreen(), (byte)color.getBlue());
                    if (nodeLayout.node.isLeaf() || !this.isDrawNodeStateSymbol()) {
                        n4 = n2 - this.screenLocation.x + dimension.width;
                        n2 = this.screenLocation.x;
                    }
                    gL2.glVertex2f((float)(n2 + n4), (float)(n3 + dimension.height));
                    gL2.glVertex2f((float)n2, (float)(n3 + dimension.height));
                    gL2.glVertex2f((float)n2, (float)n3);
                    gL2.glVertex2f((float)(n2 + n4), (float)n3);
                }
                nodeLayout.drawPoint.x += dimension.width + this.getActiveAttributes().getIconSpace();
            }
        }
        finally {
            if (drawContext.isPickingMode()) {
                gL2.glEnd();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void drawFilledCheckboxes(DrawContext drawContext, Iterable<NodeLayout> iterable) {
        Dimension dimension = this.getSelectedSymbolSize();
        TreeAttributes treeAttributes = this.getActiveAttributes();
        GL2 gL2 = drawContext.getGL().getGL2();
        Color[] colorArray = treeAttributes.getCheckBoxColor();
        try {
            gL2.glLineWidth(1.0f);
            gL2.glPolygonMode(1028, 6914);
            gL2.glBegin(7);
            for (NodeLayout nodeLayout : iterable) {
                int n = nodeLayout.bounds.height - dimension.height - (this.lineHeight - dimension.height) / 2;
                int n2 = nodeLayout.drawPoint.x;
                int n3 = nodeLayout.drawPoint.y + n;
                String string = nodeLayout.node.isTreeSelected();
                boolean bl = "util.tree.PartiallySelected".equals(string);
                if (!bl) continue;
                OGLUtil.applyColor(gL2, colorArray[0], 1.0, false);
                gL2.glVertex2f((float)(n2 + dimension.width), (float)(n3 + dimension.height));
                gL2.glVertex2f((float)n2, (float)(n3 + dimension.height));
                gL2.glVertex2f((float)n2, (float)n3);
                OGLUtil.applyColor(gL2, colorArray[1], 1.0, false);
                gL2.glVertex2f((float)(n2 + dimension.width), (float)n3);
            }
        }
        finally {
            gL2.glEnd();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void drawCheckmarks(DrawContext drawContext, Iterable<NodeLayout> iterable) {
        Dimension dimension = this.getSelectedSymbolSize();
        TreeAttributes treeAttributes = this.getActiveAttributes();
        Color color = treeAttributes.getColor();
        GL2 gL2 = drawContext.getGL().getGL2();
        OGLUtil.applyColor(gL2, color, 1.0, false);
        try {
            gL2.glEnable(2848);
            gL2.glBegin(1);
            for (NodeLayout nodeLayout : iterable) {
                int n = nodeLayout.bounds.height - dimension.height - (this.lineHeight - dimension.height) / 2;
                String string = nodeLayout.node.isTreeSelected();
                boolean bl = "util.tree.Selected".equals(string);
                if (!bl) continue;
                int n2 = nodeLayout.drawPoint.x;
                int n3 = nodeLayout.drawPoint.y + n;
                gL2.glVertex2f((float)n2 + (float)dimension.width * 0.3f - 1.0f, (float)n3 + (float)dimension.height * 0.6f);
                gL2.glVertex2f((float)n2 + (float)dimension.width * 0.3f - 1.0f, (float)n3 + (float)dimension.height * 0.2f + 1.0f);
                gL2.glVertex2f((float)n2 + (float)dimension.width * 0.3f - 1.0f, (float)n3 + (float)dimension.height * 0.2f + 1.0f);
                gL2.glVertex2f((float)n2 + (float)dimension.width * 0.8f - 1.0f, (float)n3 + (float)dimension.height * 0.8f);
            }
        }
        finally {
            gL2.glEnd();
            gL2.glDisable(2848);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void drawTriangles(DrawContext drawContext, Iterable<NodeLayout> iterable) {
        GL2 gL2 = drawContext.getGL().getGL2();
        Dimension dimension = this.getNodeStateSymbolSize();
        int n = dimension.height / 2;
        int n2 = dimension.width / 2;
        int n3 = this.getActiveAttributes().getIconSpace();
        int n4 = dimension.width + n3;
        if (!drawContext.isPickingMode()) {
            TreeAttributes treeAttributes = this.getActiveAttributes();
            Color object = treeAttributes.getColor();
            gL2.glPolygonMode(1028, 6914);
            gL2.glLineWidth(1.0f);
            OGLUtil.applyColor(gL2, object, 1.0, false);
            gL2.glBegin(4);
        } else {
            gL2.glBegin(7);
        }
        try {
            for (NodeLayout nodeLayout : iterable) {
                if (!nodeLayout.node.isLeaf()) {
                    int n5 = nodeLayout.drawPoint.x;
                    int n6 = nodeLayout.drawPoint.y;
                    if (!drawContext.isPickingMode()) {
                        n5 += n2;
                        n6 += n;
                        if (this.tree.isNodeExpanded(nodeLayout.node)) {
                            int color = nodeLayout.bounds.height - n2 - (this.lineHeight - n2) / 2;
                            gL2.glVertex2i(n5 - n, n6 += color);
                            gL2.glVertex2i(n5, -n2 + n6);
                            gL2.glVertex2i(n5 + n, n6);
                        } else {
                            int n7 = nodeLayout.bounds.height - dimension.height - (this.lineHeight - dimension.height) / 2;
                            gL2.glVertex2f((float)n5, (float)(-n + (n6 += n7)) - 0.5f);
                            gL2.glVertex2f((float)(n5 + n2), (float)n6);
                            gL2.glVertex2f((float)n5, (float)(n + n6) - 0.5f);
                        }
                    } else {
                        Color color = drawContext.getUniquePickColor();
                        int n8 = color.getRGB();
                        this.pickSupport.addPickableObject(n8, this.createTogglePathControl(this.tree, nodeLayout.node));
                        gL2.glColor3ub((byte)color.getRed(), (byte)color.getGreen(), (byte)color.getBlue());
                        n5 = this.screenLocation.x;
                        int n9 = nodeLayout.drawPoint.x + n4 - n5;
                        n6 = (int)nodeLayout.screenBounds.getMaxY() - this.lineHeight;
                        gL2.glVertex2f((float)n5, (float)n6);
                        gL2.glVertex2f((float)n5, (float)(n6 + this.lineHeight));
                        gL2.glVertex2f((float)(n5 + n9), (float)(n6 + this.lineHeight));
                        gL2.glVertex2f((float)(n5 + n9), (float)n6);
                    }
                }
                if (!this.isDrawNodeStateSymbol()) continue;
                nodeLayout.drawPoint.x += this.getNodeStateSymbolSize().width + this.getActiveAttributes().getIconSpace();
            }
        }
        finally {
            gL2.glEnd();
        }
    }

    protected void computeTreeLayout(TreeNode treeNode, DrawContext drawContext, Dimension dimension, Point point, int n, List<NodeLayout> list) {
        TreeAttributes treeAttributes = this.getActiveAttributes();
        int n2 = point.x;
        if (this.mustDisplayNode(treeNode, n)) {
            Dimension dimension2 = this.getNodeSize(drawContext, dimension, point.x, treeNode, treeAttributes);
            int n3 = point.y - (dimension2.height + this.getActiveAttributes().getRowSpacing());
            Rectangle rectangle = new Rectangle(point.x, n3, dimension2.width, dimension2.height);
            NodeLayout nodeLayout = (NodeLayout)this.layoutCache.get(treeNode);
            if (nodeLayout == null) {
                nodeLayout = new NodeLayout(treeNode);
            }
            nodeLayout.bounds = rectangle;
            int n4 = treeAttributes.getRowSpacing();
            nodeLayout.pickBounds = new Rectangle(0, rectangle.y - n4, dimension.width, rectangle.height + n4 * 2);
            list.add(nodeLayout);
            point.x += this.indent;
            point.y -= dimension2.height + this.getActiveAttributes().getRowSpacing();
        }
        if (this.tree.isNodeExpanded(treeNode)) {
            for (TreeNode treeNode2 : treeNode.getChildren()) {
                this.computeTreeLayout(treeNode2, drawContext, dimension, point, n + 1, list);
            }
        }
        point.x = n2;
    }

    protected Rectangle findNodeBounds(TreeNode treeNode, TreeNode treeNode2, DrawContext drawContext, Dimension dimension, Point point, int n) {
        TreeAttributes treeAttributes = this.getActiveAttributes();
        int n2 = point.x;
        if (n > 1 || treeAttributes.isRootVisible()) {
            Dimension dimension2 = this.getNodeSize(drawContext, dimension, point.x, treeNode2, treeAttributes);
            point.y -= dimension2.height + this.getActiveAttributes().getRowSpacing();
            Rectangle object = new Rectangle(point.x, point.y, dimension2.width, dimension2.height);
            if (treeNode2.getPath().equals(treeNode.getPath())) {
                return object;
            }
            point.x += n * this.indent;
        }
        if (this.tree.isNodeExpanded(treeNode2)) {
            for (TreeNode treeNode3 : treeNode2.getChildren()) {
                Rectangle rectangle = this.findNodeBounds(treeNode, treeNode3, drawContext, dimension, point, n + 1);
                if (rectangle == null) continue;
                return rectangle;
            }
        }
        point.x = n2;
        return null;
    }

    @Override
    public synchronized void makeVisible(TreePath treePath) {
        TreeNode treeNode = this.tree.getNode(treePath);
        if (treeNode == null) {
            return;
        }
        for (TreeNode treeNode2 = treeNode.getParent(); treeNode2 != null; treeNode2 = treeNode2.getParent()) {
            this.tree.expandPath(treeNode2.getPath());
        }
        this.scrollToNode = treeNode;
    }

    public Offset getScreenLocation() {
        return this.frame.getScreenLocation();
    }

    public void setScreenLocation(Offset offset) {
        this.frame.setScreenLocation(offset);
    }

    @Override
    public TreeAttributes getAttributes() {
        return this.normalAttributes;
    }

    @Override
    public void setAttributes(TreeAttributes treeAttributes) {
        if (treeAttributes == null) {
            String string = Logging.getMessage("nullValue.AttributesIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.normalAttributes = treeAttributes;
    }

    public TreeAttributes getHighlightAttributes() {
        return this.highlightAttributes;
    }

    public void setHighlightAttributes(TreeAttributes treeAttributes) {
        if (treeAttributes == null) {
            String string = Logging.getMessage("nullValue.AttributesIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.highlightAttributes = treeAttributes;
    }

    protected TreeAttributes getActiveAttributes() {
        return this.activeAttributes;
    }

    protected void determineActiveAttributes() {
        TreeAttributes treeAttributes = defaultAttributes;
        if (this.isHighlighted()) {
            treeAttributes = this.getHighlightAttributes() != null ? this.getHighlightAttributes() : (this.getAttributes() != null ? this.getAttributes() : defaultAttributes);
        } else if (this.getAttributes() != null) {
            treeAttributes = this.getAttributes();
        }
        if (!treeAttributes.equals(this.activeAttributes)) {
            this.markUpdated();
        }
        this.activeAttributes.copy(treeAttributes);
    }

    public boolean isHighlighted() {
        return this.highlighted;
    }

    @Override
    public void setHighlighted(boolean bl) {
        this.highlighted = bl;
    }

    public ScrollFrame getFrame() {
        return this.frame;
    }

    public Dimension getNodeSize(DrawContext drawContext, Dimension dimension, int n, TreeNode treeNode, TreeAttributes treeAttributes) {
        Dimension dimension2 = new Dimension();
        if (treeNode.hasImage()) {
            Dimension dimension3 = treeAttributes.getIconSize();
            if (dimension3.height > dimension2.height) {
                dimension2.height = dimension3.height;
            }
            dimension2.width += dimension3.width + treeAttributes.getIconSpace();
        }
        if (this.isDrawSelectedSymbol()) {
            dimension2.width += this.getSelectedSymbolSize().width + treeAttributes.getIconSpace();
        }
        if (this.isDrawNodeStateSymbol()) {
            dimension2.width += this.getNodeStateSymbolSize().width + treeAttributes.getIconSpace();
        }
        int n2 = dimension2.width;
        Rectangle2D rectangle2D = this.getTextBounds(drawContext, this.getText(treeNode), treeAttributes.getFont());
        int n3 = (int)rectangle2D.getWidth();
        dimension2.height = (int)Math.max((double)dimension2.height, rectangle2D.getHeight());
        String string = this.getDescriptionText(treeNode);
        if (string != null) {
            Rectangle2D rectangle2D2;
            if (this.isWrapText() && dimension != null) {
                int n4;
                int n5 = dimension.width - n - n2;
                int n6 = this.estimateWrappedTextLines(drawContext, string, treeAttributes.getDescriptionFont(), n5);
                if (n6 == 1) {
                    rectangle2D2 = this.getMultilineTextBounds(drawContext, string, treeAttributes.getDescriptionFont());
                    n4 = (int)Math.min((double)n5, rectangle2D2.getWidth());
                } else {
                    n4 = n5;
                }
                rectangle2D2 = new Rectangle(n4, n6 * this.lineHeight);
                NodeLayout nodeLayout = (NodeLayout)this.layoutCache.get(treeNode);
                if (nodeLayout == null) {
                    nodeLayout = new NodeLayout(treeNode);
                    this.layoutCache.put(treeNode, nodeLayout);
                }
                nodeLayout.numLines = n6;
            } else {
                rectangle2D2 = this.getMultilineTextBounds(drawContext, string, treeAttributes.getDescriptionFont());
            }
            dimension2.height += (int)Math.abs(rectangle2D2.getHeight());
            dimension2.width = (int)((double)dimension2.width + Math.max((double)n3, rectangle2D2.getWidth()));
        } else {
            dimension2.width += n3;
        }
        return dimension2;
    }

    protected int estimateWrappedTextLines(DrawContext drawContext, String string, Font font, int n) {
        boolean bl;
        boolean bl2 = bl = string.contains(" ") || string.contains("\t");
        if (!bl) {
            return 1;
        }
        int n2 = Math.min(string.length(), 50);
        Rectangle2D rectangle2D = this.getTextBounds(drawContext, string.substring(0, n2), font);
        double d = rectangle2D.getWidth() / (double)n2;
        double d2 = (int)d * string.length();
        return (int)Math.min(Math.ceil(d2 / (double)n), (double)this.getMaxWrappedLines());
    }

    protected String computeWrappedText(DrawContext drawContext, TreeNode treeNode, Font font, int n) {
        NodeLayout nodeLayout = (NodeLayout)this.layoutCache.get(treeNode);
        if (nodeLayout == null) {
            nodeLayout = new NodeLayout(treeNode);
            this.layoutCache.put(treeNode, nodeLayout);
        }
        String string = treeNode.getDescription();
        if ((nodeLayout.wrappedText == null || nodeLayout.textWrapWidth != n) && string != null) {
            TextRenderer textRenderer = OGLTextRenderer.getOrCreateTextRenderer(drawContext.getTextRendererCache(), font);
            MultiLineTextRenderer multiLineTextRenderer = new MultiLineTextRenderer(textRenderer);
            int n2 = (int)((double)(this.lineHeight * nodeLayout.numLines) + (double)this.lineHeight * 0.5);
            nodeLayout.wrappedText = multiLineTextRenderer.wrap(string, n, n2);
            nodeLayout.textWrapWidth = n;
        }
        return nodeLayout.wrappedText;
    }

    protected void invalidateWrappedText() {
        for (Map.Entry entry : this.layoutCache.entrySet()) {
            ((NodeLayout)entry.getValue()).wrappedText = null;
        }
    }

    protected HotSpot createTogglePathControl(final Tree tree, final TreeNode treeNode) {
        return new TreeHotSpot(this.getFrame()){

            @Override
            public void selected(SelectEvent selectEvent) {
                if (selectEvent == null || this.isConsumed(selectEvent)) {
                    return;
                }
                if (selectEvent.isLeftClick() || selectEvent.isLeftDoubleClick()) {
                    tree.togglePath(treeNode.getPath());
                    selectEvent.consume();
                } else {
                    super.selected(selectEvent);
                }
            }
        };
    }

    protected HotSpot createSelectControl(final TreeNode treeNode) {
        return new TreeHotSpot(this.getFrame()){

            @Override
            public void selected(SelectEvent selectEvent) {
                if (selectEvent == null || this.isConsumed(selectEvent)) {
                    return;
                }
                if (selectEvent.isLeftClick() || selectEvent.isLeftDoubleClick()) {
                    BasicTreeLayout.this.toggleNodeSelection(treeNode);
                    selectEvent.consume();
                } else {
                    super.selected(selectEvent);
                }
            }
        };
    }

    protected Rectangle2D getTextBounds(DrawContext drawContext, String string, Font font) {
        TextCacheKey textCacheKey = new TextCacheKey(string, font);
        Rectangle2D rectangle2D = (Rectangle2D)this.textCache.get(textCacheKey);
        if (rectangle2D == null) {
            TextRenderer textRenderer = OGLTextRenderer.getOrCreateTextRenderer(drawContext.getTextRendererCache(), font);
            rectangle2D = textRenderer.getBounds(string);
            this.textCache.put(textCacheKey, rectangle2D);
        }
        return rectangle2D;
    }

    protected Rectangle2D getMultilineTextBounds(DrawContext drawContext, String string, Font font) {
        String[] stringArray;
        int n = 0;
        int n2 = 0;
        for (String string2 : stringArray = string.split("\n")) {
            Rectangle2D rectangle2D = this.getTextBounds(drawContext, string2, font);
            n = (int)Math.max(rectangle2D.getWidth(), (double)n);
            n2 = (int)Math.max(rectangle2D.getMaxY(), (double)this.lineHeight);
        }
        return new Rectangle(stringArray.length, this.lineHeight, n, stringArray.length * n2);
    }

    protected void toggleNodeSelection(TreeNode treeNode) {
        boolean bl = !treeNode.isSelected();
        treeNode.setSelected(bl);
        if (!treeNode.isLeaf()) {
            this.setDescendantsSelected(treeNode, bl);
        }
        for (TreeNode treeNode2 = treeNode.getParent(); treeNode2 != null; treeNode2 = treeNode2.getParent()) {
            boolean bl2 = treeNode2.isSelected();
            treeNode2.setSelected(bl);
            if (bl || "util.tree.NotSelected".equals(treeNode2.isTreeSelected())) continue;
            treeNode2.setSelected(bl2);
            break;
        }
    }

    protected void setDescendantsSelected(TreeNode treeNode, boolean bl) {
        for (TreeNode treeNode2 : treeNode.getChildren()) {
            treeNode2.setSelected(bl);
            if (treeNode2.isLeaf()) continue;
            this.setDescendantsSelected(treeNode2, bl);
        }
    }

    protected String getText(TreeNode treeNode) {
        return treeNode.getText();
    }

    protected String getDescriptionText(TreeNode treeNode) {
        return treeNode.getDescription();
    }

    protected static class NodeLayout {
        protected TreeNode node;
        protected Rectangle bounds;
        protected Rectangle pickBounds;
        protected Rectangle screenBounds;
        protected Rectangle pickScreenBounds;
        protected String wrappedText;
        protected int textWrapWidth;
        protected int numLines;
        protected Point drawPoint;

        protected NodeLayout(TreeNode treeNode) {
            if (treeNode == null) {
                String string = Logging.getMessage("nullValue.TreeNodeIsNull");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            this.node = treeNode;
            this.drawPoint = new Point();
        }

        protected void reset(Point point) {
            this.drawPoint.x = this.bounds.x + point.x;
            this.drawPoint.y = this.bounds.y + point.y;
            this.screenBounds = new Rectangle(this.drawPoint.x, this.drawPoint.y, this.bounds.width, this.bounds.height);
            int n = this.pickBounds.x + point.x;
            int n2 = this.pickBounds.y + point.y;
            this.pickScreenBounds = new Rectangle(n, n2, this.pickBounds.width, this.pickBounds.height);
        }
    }

    protected static class TextCacheKey {
        protected String text;
        protected Font font;
        protected int hash = 0;

        public TextCacheKey(String string, Font font) {
            if (string == null) {
                String string2 = Logging.getMessage("nullValue.StringIsNull");
                Logging.logger().severe(string2);
                throw new IllegalArgumentException(string2);
            }
            if (font == null) {
                String string3 = Logging.getMessage("nullValue.FontIsNull");
                Logging.logger().severe(string3);
                throw new IllegalArgumentException(string3);
            }
            this.text = string;
            this.font = font;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            TextCacheKey textCacheKey = (TextCacheKey)object;
            return this.text.equals(textCacheKey.text) && this.font.equals(textCacheKey.font);
        }

        public int hashCode() {
            if (this.hash == 0) {
                int n = this.text.hashCode();
                this.hash = n = 31 * n + this.font.hashCode();
            }
            return this.hash;
        }
    }
}

