package org.hibernate.annotations;

import java.lang.annotation.Retention;
import java.lang.annotation.Target;
import static java.lang.annotation.ElementType.TYPE;
import static java.lang.annotation.ElementType.FIELD;
import static java.lang.annotation.ElementType.METHOD;
import static java.lang.annotation.RetentionPolicy.RUNTIME;

/**
 * Define a DB index
 * @author Emmanuel Bernard
 */
@Target({TYPE, FIELD, METHOD}) @Retention(RUNTIME)
public @interface Index {
	String name();
	String[] columnNames() default {};
}
