//$Id: ClassPropertyHolder.java,v 1.8 2005/06/20 17:11:00 epbernard Exp $
package org.hibernate.cfg;

import java.util.Map;
import java.util.HashMap;
import javax.persistence.Column;

import org.hibernate.mapping.KeyValue;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.Table;

/**
 * @author Emmanuel Bernard
 */
public class ClassPropertyHolder implements PropertyHolder {
	private PersistentClass persistentClass;
	private Map<String, Column[]> columnOverride;

	public ClassPropertyHolder(PersistentClass persistentClass, Map<String, Column[]> columnOverride) {
		this.persistentClass = persistentClass;
		this.columnOverride = columnOverride;
	}

	public String getPath() {
		return persistentClass.getEntityName();
	}

	public Column[] getOverriddenColumn(String propertyName) {
		return columnOverride.get(propertyName);
	}

	public Map<String, Column[]> mergeOverridenColumns(Map<String, Column[]> localColumnOverride) {
		Map<String, Column[]> merge = new HashMap<String, Column[]>(localColumnOverride);
		merge.putAll(localColumnOverride);
		return merge;
	}

	public String getEntityName() {
		return persistentClass.getEntityName();
	}

	public void addProperty(Property prop) {
		persistentClass.addProperty(prop);
	}
	
	public String getClassName() {
		return persistentClass.getClassName();
	}

	public Table getTable() {
		return persistentClass.getTable();
	}

	public boolean isComponent() {
		return false;
	}

	public PersistentClass getPersistentClass() {
		return persistentClass;
	}

	public KeyValue getIdentifier() {
		return persistentClass.getIdentifier();
	}
}
