//$Id: Ejb3DiscriminatorColumn.java,v 1.7 2005/06/16 19:07:13 epbernard Exp $
package org.hibernate.cfg;

import java.util.Map;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.DiscriminatorType;

import org.hibernate.AssertionFailure;
import org.hibernate.annotations.DiscriminatorFormula;
import org.hibernate.mapping.Join;

/**
 * Discriminator column
 *
 * @author Emmanuel Bernard
 */
public class Ejb3DiscriminatorColumn extends Ejb3Column {


	private static final String DEFAULT_DISCRIMINATOR_COLUMN_NAME = "TYPE";
	private static final String DEFAULT_DISCRIMINATOR_TYPE = "string";

	private String discriminatorTypeName;

	public Ejb3DiscriminatorColumn() {
		//discriminator default value
		super();
		setColumnName(DEFAULT_DISCRIMINATOR_COLUMN_NAME);
		setNullable(false);
		setDiscriminatorTypeName(DEFAULT_DISCRIMINATOR_TYPE);
	}

	public Ejb3DiscriminatorColumn(boolean isImplicit, String sqlType, int length, String name, boolean nullable, boolean unique, boolean insertable,
								   boolean updatable, String secondaryTableName, Map<String, Join> joins, PropertyHolder propertyHolder,
								   String discriminatorTypeName, Mappings mappings) {
		super();
		setImplicit(isImplicit);
		setSqlType(sqlType);
		setLength(length);
		setColumnName(name);
		setNullable(nullable);
		setUnique(unique);
		setInsertable(insertable);
		setUpdatable(updatable);
		setSecondaryTableName(secondaryTableName);
		setJoins(joins);
		setPropertyHolder(propertyHolder);
		setMappings(mappings);
		this.discriminatorTypeName = discriminatorTypeName;
		bind();
	}

	public String getDiscriminatorTypeName() {
		return discriminatorTypeName;
	}

	public void setDiscriminatorTypeName(String discriminatorTypeName) {
		this.discriminatorTypeName = discriminatorTypeName;
	}

	public static Ejb3DiscriminatorColumn buildDiscriminatorColumn(
			DiscriminatorType type, DiscriminatorColumn discAnn, DiscriminatorFormula discFormulaAnn, ExtendedMappings mappings
			) {
		Ejb3DiscriminatorColumn discriminatorColumn = new Ejb3DiscriminatorColumn();
		discriminatorColumn.setMappings(mappings);
		discriminatorColumn.setImplicit(true);
//		String discrSqlType = null;
//		String discrColumnName = DEFAULT_DISCRIMINATOR_COLUMN_NAME;
//		int discrLength = 255;
//		boolean discrNullable = false;
//		String discrTypeName = "string";
//		boolean isImplicit = true;
        if (discFormulaAnn != null) {
			discriminatorColumn.setImplicit(false);
			discriminatorColumn.setFormula( discFormulaAnn.value() );
		}
		else if (discAnn != null) {
			discriminatorColumn.setImplicit(false);
			if (! AnnotationBinder.isDefault( discAnn.columnDefinition() ) ) discriminatorColumn.setSqlType( discAnn.columnDefinition() );
			if (! AnnotationBinder.isDefault( discAnn.name() ) ) discriminatorColumn.setColumnName( discAnn.name() );
			discriminatorColumn.setNullable( discAnn.nullable() );
		}
//		boolean overrideDefaultValues = discAnn != null;
//		if (overrideDefaultValues) {
//			isImplicit = false;
//			discrSqlType = "".equals( discAnn.columnDefinition() ) ? null : discAnn.columnDefinition();
//			discrColumnName = "".equals( discAnn.name() ) ? DEFAULT_DISCRIMINATOR_COLUMN_NAME : discAnn.name();
//			discrNullable = discAnn.nullable();
//
//		}
		if (DiscriminatorType.CHAR.equals(type) ) {
			discriminatorColumn.setDiscriminatorTypeName("character");
			discriminatorColumn.setImplicit(false);
		}
		else if (DiscriminatorType.INTEGER.equals(type) ) {
			discriminatorColumn.setDiscriminatorTypeName("integer");
			discriminatorColumn.setImplicit(false);
		}
		else if (DiscriminatorType.STRING.equals(type) || type == null ) {
			if (discAnn != null) discriminatorColumn.setLength( discAnn.length() );
			discriminatorColumn.setDiscriminatorTypeName("string");
//			discrLength = overrideDefaultValues ? discAnn.length() : discrLength;
//			discrTypeName = "string";
		} else {
			throw new AssertionFailure("Unknown discriminator type: " + type);
		}
//		discriminatorColumn = new Ejb3DiscriminatorColumn(isImplicit, discrSqlType, discrLength, discrColumnName, discrNullable,
//			false, false, false, (String) null, null, null, discrTypeName, mappings);
		discriminatorColumn.bind();
		return discriminatorColumn;
	}
}
