//$Id: Max.java,v 1.1 2005/05/27 08:58:53 epbernard Exp $
package org.hibernate.validator;

import static java.lang.annotation.ElementType.METHOD;
import static java.lang.annotation.RetentionPolicy.RUNTIME;

import java.lang.annotation.Retention;
import java.lang.annotation.Target;

/**
 * max restriction on a numeric annotated element
 * @author Gavin King
 */
@ValidatorClass(MaxValidator.class)
@Target(METHOD) @Retention(RUNTIME)
public @interface Max {
	int value();
	String message() default "must less than or equal to {value}";
}
