//$Id: Min.java,v 1.1 2005/05/27 08:58:54 epbernard Exp $
package org.hibernate.validator;

import static java.lang.annotation.ElementType.METHOD;
import static java.lang.annotation.RetentionPolicy.RUNTIME;

import java.lang.annotation.Retention;
import java.lang.annotation.Target;

/**
 * min restriction on a numeric annotated elemnt (or the string representation of a numeric)
 * @author Gavin King
 */
@ValidatorClass(MinValidator.class)
@Target(METHOD) @Retention(RUNTIME)
public @interface Min {
	int value();
	String message() default "must greater than or equal to {value}";
}
