//$Id: NotNullValidator.java,v 1.1 2005/05/27 08:58:54 epbernard Exp $
package org.hibernate.validator;

import java.util.Iterator;

import org.hibernate.mapping.Column;
import org.hibernate.mapping.Property;

/**
 * Check a not null restriction on an object
 * and apply the equivalent constraint on hibernate metadata.
 *
 * @author Gavin King
 */
public class NotNullValidator implements Validator<NotNull>, PropertyConstraint {

	public boolean isValid(Object value) {
		return value!=null;
	}

	public void initialize(NotNull parameters) {}

	public void apply(Property property) {
		Iterator<Column> iter = (Iterator<Column>) property.getColumnIterator();
		while ( iter.hasNext() ) {
			iter.next().setNullable(false);
		}
	}
}
