//$Id: Pattern.java,v 1.1 2005/05/27 08:58:54 epbernard Exp $
package org.hibernate.validator;

import static java.lang.annotation.ElementType.METHOD;
import static java.lang.annotation.RetentionPolicy.RUNTIME;

import java.lang.annotation.Retention;
import java.lang.annotation.Target;

/**
 * The annotated element must follow the regexp pattern
 * @author Gavin King
 */
@ValidatorClass(PatternValidator.class)
@Target(METHOD) @Retention(RUNTIME)
public @interface Pattern {
	String regex();
	int flags() default 0;
	String message() default "must match \"{regex}\"";
}
