//$Id: Size.java,v 1.1 2005/05/27 08:58:54 epbernard Exp $
package org.hibernate.validator;

import static java.lang.annotation.ElementType.METHOD;
import static java.lang.annotation.RetentionPolicy.RUNTIME;

import java.lang.annotation.Retention;
import java.lang.annotation.Target;

/**
 * Size range for Arrays, Collections or Maps
 * 
 * @author Gavin King
 */
@ValidatorClass(SizeValidator.class)
@Target(METHOD) @Retention(RUNTIME)
public @interface Size {
	int max() default Integer.MAX_VALUE;
	int min() default 0;
	String message() default "size must be between {min} and {max}";
}
