//$Id: ValidatePreInsertEventListener.java,v 1.1 2005/05/27 08:58:53 epbernard Exp $
package org.hibernate.validator.event;

import org.hibernate.event.PreInsertEvent;
import org.hibernate.event.def.DefaultPreInsertEventListener;
import org.hibernate.validator.ClassValidator;
import org.hibernate.validator.InvalidStateException;
import org.hibernate.validator.InvalidValue;

/**
 * Before insert execute the validator framework
 * @author Gavin King
 */
public class ValidatePreInsertEventListener extends DefaultPreInsertEventListener {

	public boolean onPreInsert(PreInsertEvent event) {
		//TODO: cache the validator
		InvalidValue[] invalidValues = new ClassValidator( event.getEntity().getClass() )
				.getInvalidValues( event.getEntity() );
		if (invalidValues.length>0) {
			throw new InvalidStateException(invalidValues);
		}
		return super.onPreInsert( event );
	}

}
