/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg;

import java.util.HashMap;
import java.util.Map;
import javax.persistence.Column;
import org.hibernate.cfg.PropertyHolder;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.KeyValue;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.Table;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentPropertyHolder
implements PropertyHolder {
    private Component component;
    String path;
    private Map<String, Column[]> columnOverride;

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public Column[] getOverriddenColumn(String propertyName) {
        return this.columnOverride.get(propertyName);
    }

    @Override
    public String getEntityName() {
        return this.component.getComponentClassName();
    }

    public ComponentPropertyHolder(Component component, String path, Map<String, Column[]> columnOverride) {
        this.component = component;
        this.path = path;
        this.columnOverride = columnOverride;
    }

    @Override
    public String getClassName() {
        return this.component.getComponentClassName();
    }

    @Override
    public Table getTable() {
        return this.component.getTable();
    }

    @Override
    public void addProperty(Property prop) {
        this.component.addProperty(prop);
    }

    @Override
    public KeyValue getIdentifier() {
        return this.component.getOwner().getIdentifier();
    }

    @Override
    public PersistentClass getPersistentClass() {
        return this.component.getOwner();
    }

    @Override
    public boolean isComponent() {
        return true;
    }

    @Override
    public Map<String, Column[]> mergeOverridenColumns(Map<String, Column[]> localColumnOverride) {
        HashMap<String, Column[]> merge = new HashMap<String, Column[]>(localColumnOverride);
        merge.putAll(localColumnOverride);
        return merge;
    }
}

