//$Id: ComponentPropertyHolder.java,v 1.7 2005/09/06 22:13:36 epbernard Exp $
package org.hibernate.cfg;

import java.util.HashMap;
import java.util.Map;
import javax.persistence.Column;

import org.hibernate.mapping.Component;
import org.hibernate.mapping.KeyValue;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.Table;
import org.hibernate.AnnotationException;

/**
 * Component implementation of property holder
 *
 * @author Emmanuel Bernard
 */
public class ComponentPropertyHolder implements PropertyHolder {
	private Component component;
	String path;
	private Map<String, Column[]> columnOverride;

	public String getPath() {
		return path;
	}

	public Column[] getOverriddenColumn(String propertyName) {
		return columnOverride.get( propertyName );
	}

	public String getEntityName() {
		return component.getComponentClassName();
	}

	public void addProperty(Property prop, Ejb3Column[] columns) {
		//Ejb3Column.checkPropertyConsistency( ); //already called earlier
		/*
		 * Check table matches between the component and the columns
		 * if not, change the component table if no properties are set
		 * if a property is set already the core cannot support that
		 */
		Table table = columns[0].getTable();
		if ( ! table.equals( component.getTable() ) ) {
			if ( component.getPropertySpan() == 0 ) {
				component.setTable( table );
			}
			else {
				throw new AnnotationException("A component cannot hold properties split into 2 different tables: "
					+ this.getPath() );
			}
		}
		addProperty( prop );
	}

	public ComponentPropertyHolder(Component component, String path, Map<String, Column[]> columnOverride) {
		this.component = component;
		this.path = path;
		this.columnOverride = columnOverride;
	}

	public String getClassName() {
		return component.getComponentClassName();
	}

	public Table getTable() {
		return component.getTable();
	}

	public void addProperty(Property prop) {
		component.addProperty( prop );
	}

	public KeyValue getIdentifier() {
		return component.getOwner().getIdentifier();
	}

	public PersistentClass getPersistentClass() {
		return component.getOwner();
	}

	public boolean isComponent() {
		return true;
	}

	public Map<String, Column[]> mergeOverridenColumns(Map<String, Column[]> localColumnOverride) {
		Map<String, Column[]> merge = new HashMap<String, Column[]>( localColumnOverride );
		merge.putAll( columnOverride );
		return merge;
	}
}
