//$Id: IndexSecondPass.java,v 1.1 2005/10/06 15:22:35 epbernard Exp $
package org.hibernate.cfg;

import java.util.Map;

import org.hibernate.MappingException;
import org.hibernate.AnnotationException;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.Column;

/**
 * @author Emmanuel Bernard
 */
public class IndexSecondPass implements SecondPass {
	private final Table table;
	private final String indexName;
	private final String[] columns;

	public IndexSecondPass(Table table, String indexName, String[] columns) {
		this.table = table;
		this.indexName = indexName;
		this.columns = columns;
	}
	public void doSecondPass(Map persistentClasses, Map inheritedMetas) throws MappingException {
		for ( String columnName : columns) {
			Column column = table.getColumn( new Column( columnName ) );
			if ( column == null ) {
				throw new AnnotationException(
						"@Index references a unknown column: " + columnName
				);
			}
			table.getOrCreateIndex( indexName ).addColumn( column );
		}
	}
}
