//$Id: QueryBinder.java,v 1.15 2005/09/12 23:13:37 epbernard Exp $
package org.hibernate.cfg.annotations;

import java.util.HashMap;
import javax.persistence.ColumnResult;
import javax.persistence.EntityResult;
import javax.persistence.FieldResult;
import javax.persistence.NamedNativeQueries;
import javax.persistence.NamedNativeQuery;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.SqlResultSetMapping;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.AnnotationException;
import org.hibernate.FlushMode;
import org.hibernate.LockMode;
import org.hibernate.CacheMode;
import org.hibernate.AssertionFailure;
import org.hibernate.annotations.FlushModeType;
import org.hibernate.annotations.CacheModeType;
import org.hibernate.cfg.AnnotationBinder;
import org.hibernate.cfg.ExtendedMappings;
import org.hibernate.cfg.NotYetImplementedException;
import org.hibernate.engine.NamedQueryDefinition;
import org.hibernate.engine.NamedSQLQueryDefinition;
import org.hibernate.engine.ResultSetMappingDefinition;
import org.hibernate.loader.custom.SQLQueryReturn;
import org.hibernate.loader.custom.SQLQueryRootReturn;
import org.hibernate.loader.custom.SQLQueryScalarReturn;

/**
 * Query binder
 *
 * @author Emmanuel Bernard
 */
public abstract class QueryBinder {
	private static Log log = LogFactory.getLog( QueryBinder.class );

	public static void bindQuery(NamedQuery queryAnn, ExtendedMappings mappings) {
		if ( queryAnn == null ) return;
		if ( AnnotationBinder.isDefault( queryAnn.name() ) ) {
			throw new AnnotationException( "A named query must have a name when used in class or package level" );
		}
		//EJBQL Query
		NamedQueryDefinition query = new NamedQueryDefinition(
				queryAnn.queryString(),
				false,
				null,
				null,
				null,
				null,
				null,
				false,
				null,
				null
		);
		mappings.addQuery( queryAnn.name(), query );
		log.debug( "Named query " + queryAnn.name() + " => " + queryAnn.queryString() );
	}

	public static void bindNativeQuery(NamedNativeQuery queryAnn, ExtendedMappings mappings) {
		if ( queryAnn == null ) return;
		//ResultSetMappingDefinition mappingDefinition = mappings.getResultSetMapping( queryAnn.resultSetMapping() );
		if ( AnnotationBinder.isDefault( queryAnn.name() ) ) {
			throw new AnnotationException( "A named query must have a name when used in class or package level" );
		}
		NamedSQLQueryDefinition query;
		String resultSetMapping = queryAnn.resultSetMapping();
		if ( ! AnnotationBinder.isDefault( resultSetMapping ) ) {
			//sql result set usage
			query = new NamedSQLQueryDefinition(
					queryAnn.queryString(),
					resultSetMapping,
					null,
					false,
					null,
					null,
					null,
					null,
					null,
					false,
					null,
					null,
					false
			);
		}
		else if ( ! void.class.equals( queryAnn.resultClass() ) ) {
			//class mapping usage
			//FIXME should be done in a second pass due to entity name?
			final SQLQueryRootReturn entityQueryReturn =
					new SQLQueryRootReturn( "alias1", queryAnn.resultClass().getName(), new HashMap(), LockMode.READ );
			query = new NamedSQLQueryDefinition(
					queryAnn.queryString(),
					new SQLQueryReturn[]{entityQueryReturn},
					new SQLQueryScalarReturn[0],
					null,
					false,
					null,
					null,
					null,
					null,
					null,
					false,
					null,
					null,
					false
			);
		}
		else {
			throw new NotYetImplementedException( "Pure native scalar queries are not yet supported" );
		}
		mappings.addSQLQuery( queryAnn.name(), query );
		log.debug( "Named native query " + queryAnn.name() + " => " + queryAnn.queryString() );
	}

	public static void bindNativeQuery(org.hibernate.annotations.NamedNativeQuery queryAnn, ExtendedMappings mappings) {
		if ( queryAnn == null ) return;
		//ResultSetMappingDefinition mappingDefinition = mappings.getResultSetMapping( queryAnn.resultSetMapping() );
		if ( AnnotationBinder.isDefault( queryAnn.name() ) ) {
			throw new AnnotationException( "A named query must have a name when used in class or package level" );
		}
		NamedSQLQueryDefinition query;
		String resultSetMapping = queryAnn.resultSetMapping();
		if ( ! AnnotationBinder.isDefault( resultSetMapping ) ) {
			//sql result set usage
			query = new NamedSQLQueryDefinition(
					queryAnn.queryString(),
					resultSetMapping,
					null,
					queryAnn.cacheable(),
					AnnotationBinder.isDefault( queryAnn.cacheRegion() ) ? null : queryAnn.cacheRegion(),
					queryAnn.timeout() < 0 ? null : queryAnn.timeout(),
					queryAnn.fetchSize() < 0 ? null : queryAnn.fetchSize(),
					getFlushMode( queryAnn.flushMode() ),
					getCacheMode( queryAnn.cacheMode() ),
					queryAnn.readOnly(),
					AnnotationBinder.isDefault( queryAnn.comment() ) ? null : queryAnn.comment(),
					null,
					queryAnn.callable()
			);
		}
		else if ( ! void.class.equals( queryAnn.resultClass() ) ) {
			//class mapping usage
			//FIXME should be done in a second pass due to entity name?
			final SQLQueryRootReturn entityQueryReturn =
					new SQLQueryRootReturn( "alias1", queryAnn.resultClass().getName(), new HashMap(), LockMode.READ );
			query = new NamedSQLQueryDefinition(
					queryAnn.queryString(),
					new SQLQueryReturn[]{entityQueryReturn},
					new SQLQueryScalarReturn[0],
					null,
					queryAnn.cacheable(),
					AnnotationBinder.isDefault( queryAnn.cacheRegion() ) ? null : queryAnn.cacheRegion(),
					queryAnn.timeout() < 0 ? null : queryAnn.timeout(),
					queryAnn.fetchSize() < 0 ? null : queryAnn.fetchSize(),
					getFlushMode( queryAnn.flushMode() ),
					getCacheMode( queryAnn.cacheMode() ),
					queryAnn.readOnly(),
					AnnotationBinder.isDefault( queryAnn.comment() ) ? null : queryAnn.comment(),
					null,
					queryAnn.callable()
			);
		}
		else {
			throw new NotYetImplementedException( "Pure native scalar queries are not yet supported" );
		}
		mappings.addSQLQuery( queryAnn.name(), query );
		log.debug( "Named native query " + queryAnn.name() + " => " + queryAnn.queryString() );
	}

	public static void bindQueries(NamedQueries queriesAnn, ExtendedMappings mappings) {
		if ( queriesAnn == null ) return;
		for ( NamedQuery q : queriesAnn.value() ) {
			bindQuery( q, mappings );
		}
	}

	public static void bindNativeQueries(NamedNativeQueries queriesAnn, ExtendedMappings mappings) {
		if ( queriesAnn == null ) return;
		for ( NamedNativeQuery q : queriesAnn.value() ) {
			bindNativeQuery( q, mappings );
		}
	}

	public static void bindNativeQueries(
			org.hibernate.annotations.NamedNativeQueries queriesAnn, ExtendedMappings mappings
	) {
		if ( queriesAnn == null ) return;
		for ( org.hibernate.annotations.NamedNativeQuery q : queriesAnn.value() ) {
			bindNativeQuery( q, mappings );
		}
	}

	public static void bindQuery(org.hibernate.annotations.NamedQuery queryAnn, ExtendedMappings mappings) {
		if ( queryAnn == null ) return;
		if ( AnnotationBinder.isDefault( queryAnn.name() ) ) {
			throw new AnnotationException( "A named query must have a name when used in class or package level" );
		}

		FlushMode flushMode;
		flushMode = getFlushMode( queryAnn.flushMode() );

		NamedQueryDefinition query = new NamedQueryDefinition(
				queryAnn.queryString(),
				queryAnn.cacheable(),
				AnnotationBinder.isDefault( queryAnn.cacheRegion() ) ? null : queryAnn.cacheRegion(),
				queryAnn.timeout() < 0 ? null : queryAnn.timeout(),
				queryAnn.fetchSize() < 0 ? null : queryAnn.fetchSize(),
				flushMode,
				getCacheMode( queryAnn.cacheMode() ),
				queryAnn.readOnly(),
				AnnotationBinder.isDefault( queryAnn.comment() ) ? null : queryAnn.comment(),
				null
		);

		mappings.addQuery( queryAnn.name(), query );
		log.debug( "Named query " + queryAnn.name() + " => " + queryAnn.queryString() );
	}

	private static FlushMode getFlushMode(FlushModeType flushModeType) {
		FlushMode flushMode;
		switch ( flushModeType ) {
			case ALWAYS:
				flushMode = FlushMode.ALWAYS;
				break;
			case AUTO:
				flushMode = FlushMode.AUTO;
				break;
			case COMMIT:
				flushMode = FlushMode.COMMIT;
				break;
			case NEVER:
				flushMode = FlushMode.NEVER;
				break;
			default:
				throw new AssertionFailure( "Unknown flushModeType: " + flushModeType );
		}
		return flushMode;
	}

	private static CacheMode getCacheMode(CacheModeType cacheModeType) {
		switch ( cacheModeType ) {
			case GET:
				return CacheMode.GET;
			case IGNORE:
				return CacheMode.IGNORE;
			case NORMAL:
				return CacheMode.NORMAL;
			case PUT:
				return CacheMode.PUT;
			case REFRESH:
				return CacheMode.REFRESH;
			default:
				throw new AssertionFailure( "Unknown cacheModeType: " + cacheModeType );
		}
	}



	public static void bindQueries(org.hibernate.annotations.NamedQueries queriesAnn, ExtendedMappings mappings) {
		if ( queriesAnn == null ) return;
		for ( org.hibernate.annotations.NamedQuery q : queriesAnn.value() ) {
			bindQuery( q, mappings );
		}
	}

	public static void bindSqlResultsetMapping(SqlResultSetMapping ann, ExtendedMappings mappings) {
		//TODO add parameters checkings
		if ( ann == null ) return;
		ResultSetMappingDefinition definition = new ResultSetMappingDefinition( ann.name() );
		for ( ColumnResult column : ann.columns() ) {
			//TODO implements it
			throw new NotYetImplementedException( "Scalar returns are not supported" );
		}
		int aliasIndex = 0;
		for ( EntityResult entity : ann.entities() ) {
			//TODO parameterize lock mode?
			HashMap propertyresults = new HashMap();
			for ( FieldResult field : entity.fields() ) {
				propertyresults.put( field.name(), new String[]{field.column()} );
			}
			if ( ! AnnotationBinder.isDefault( entity.discriminatorColumn() ) ) {
				propertyresults.put( "class", new String[]{entity.discriminatorColumn()} );
			}
			SQLQueryRootReturn result =
					new SQLQueryRootReturn( "alias" + aliasIndex++, entity.name(), propertyresults, LockMode.READ );
			definition.addEntityQueryReturn( result );
		}
		mappings.addResultSetMapping( definition );
	}
}
