//$Id: NotNullValidator.java,v 1.3 2005/09/18 23:26:49 epbernard Exp $
package org.hibernate.validator;

import java.util.Iterator;
import java.io.Serializable;

import org.hibernate.mapping.Column;
import org.hibernate.mapping.Property;

/**
 * Check a not null restriction on an object
 * and apply the equivalent constraint on hibernate metadata.
 *
 * @author Gavin King
 */
public class NotNullValidator implements Validator<NotNull>, PropertyConstraint, Serializable {

	public boolean isValid(Object value) {
		return value != null;
	}

	public void initialize(NotNull parameters) {
	}

	@SuppressWarnings("unchecked")
	public void apply(Property property) {
		Iterator<Column> iter = (Iterator<Column>) property.getColumnIterator();
		while ( iter.hasNext() ) {
			iter.next().setNullable( false );
		}
	}
}
