/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.tool.ddl2hbm;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.hibernate.Hibernate;
import net.sf.hibernate.type.NullableType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JDBCUtil {
    private static final Log logger = LogFactory.getLog((Class)(class$net$sf$hibernate$tool$ddl2hbm$JDBCUtil == null ? (class$net$sf$hibernate$tool$ddl2hbm$JDBCUtil = JDBCUtil.class$("net.sf.hibernate.tool.ddl2hbm.JDBCUtil")) : class$net$sf$hibernate$tool$ddl2hbm$JDBCUtil));
    static /* synthetic */ Class class$net$sf$hibernate$tool$ddl2hbm$JDBCUtil;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Long;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getCatalogs(Connection c) throws SQLException {
        DatabaseMetaData dmd = c.getMetaData();
        ResultSet rs = null;
        try {
            rs = dmd.getCatalogs();
            LinkedList<String> l = new LinkedList<String>();
            while (rs.next()) {
                l.add(rs.getString(1));
            }
            LinkedList<String> linkedList = l;
            return linkedList;
        }
        finally {
            if (rs != null) {
                rs.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map getSchemas(Connection c) throws SQLException {
        DatabaseMetaData dmd = c.getMetaData();
        ResultSet rs = null;
        try {
            rs = dmd.getSchemas();
            HashMap<String, LinkedList<String>> map = new HashMap<String, LinkedList<String>>();
            while (rs.next()) {
                LinkedList<String> l;
                String schema = rs.getString(1);
                String catalog = null;
                if (rs.getMetaData().getColumnCount() > 1) {
                    catalog = rs.getString(2);
                }
                if ((l = (LinkedList<String>)map.get(catalog)) == null) {
                    l = new LinkedList<String>();
                    map.put(catalog, l);
                }
                l.add(schema);
            }
            HashMap<String, LinkedList<String>> hashMap = map;
            return hashMap;
        }
        finally {
            if (rs != null) {
                rs.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getTables(Connection c, String catalog, String schema, String tablePattern) throws SQLException {
        logger.debug((Object)("catalog='" + catalog + "'"));
        logger.debug((Object)("schema='" + schema + "'"));
        logger.debug((Object)("table='" + tablePattern + "'"));
        DatabaseMetaData dmd = c.getMetaData();
        ResultSet rs = null;
        try {
            rs = dmd.getTables(catalog, schema, tablePattern, new String[]{"TABLE", "VIEW", "SYNONYM", "ALIAS"});
            LinkedList<String> l = new LinkedList<String>();
            while (rs.next()) {
                l.add(rs.getString(3));
            }
            LinkedList<String> linkedList = l;
            return linkedList;
        }
        finally {
            if (rs != null) {
                rs.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set getForeignKeyColumns(Connection c, String catalog, String schema, String table) throws SQLException {
        logger.debug((Object)("catalog='" + catalog + "'"));
        logger.debug((Object)("schema='" + schema + "'"));
        logger.debug((Object)("table='" + table + "'"));
        DatabaseMetaData dmd = c.getMetaData();
        ResultSet rs = null;
        try {
            rs = dmd.getImportedKeys(catalog, schema, table);
            HashSet<String> columns = new HashSet<String>();
            while (rs.next()) {
                columns.add(rs.getString(8));
            }
            HashSet<String> hashSet = columns;
            return hashSet;
        }
        finally {
            if (rs != null) {
                rs.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getPrimaryKeyColumns(Connection c, String catalog, String schema, String table) throws SQLException {
        logger.debug((Object)("catalog='" + catalog + "'"));
        logger.debug((Object)("schema='" + schema + "'"));
        logger.debug((Object)("table='" + table + "'"));
        DatabaseMetaData dmd = c.getMetaData();
        ResultSet rs = null;
        try {
            rs = dmd.getPrimaryKeys(catalog, schema, table);
            LinkedList<Column> pkColumns = new LinkedList<Column>();
            while (rs.next()) {
                List tmp = JDBCUtil.getTableColumns(c, catalog, schema, table, rs.getString(4));
                Column pkColumn = (Column)tmp.get(0);
                pkColumns.add(pkColumn);
            }
            LinkedList<Column> linkedList = pkColumns;
            return linkedList;
        }
        finally {
            if (rs != null) {
                rs.close();
            }
        }
    }

    public static List getTableColumns(Connection c, String catalog, String schema, String table) throws SQLException {
        return JDBCUtil.getTableColumns(c, catalog, schema, table, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getTableColumns(Connection c, String catalog, String schema, String table, String columnPattern) throws SQLException {
        logger.debug((Object)("catalog='" + catalog + "'"));
        logger.debug((Object)("schema='" + schema + "'"));
        logger.debug((Object)("table='" + table + "'"));
        logger.debug((Object)("column='" + columnPattern + "'"));
        DatabaseMetaData dmd = c.getMetaData();
        ResultSet rs = null;
        try {
            rs = dmd.getColumns(catalog, schema, table, columnPattern);
            LinkedList<Column> columns = new LinkedList<Column>();
            while (rs.next()) {
                Column aCol = new Column();
                aCol.name = rs.getString(4);
                aCol.sqlType = rs.getShort(5);
                aCol.sqlColumnLength = rs.getInt(7);
                aCol.sqlDecimalLength = rs.getInt(9);
                aCol.sqlNotNull = "NO".equals(rs.getString(18));
                aCol.hibernateType = JDBCUtil.getHibernateType(aCol.sqlType, aCol.sqlColumnLength, aCol.sqlDecimalLength);
                aCol.javaType = JDBCUtil.getJavaType(aCol.sqlType, aCol.sqlColumnLength, aCol.sqlDecimalLength);
                columns.add(aCol);
            }
            LinkedList<Column> linkedList = columns;
            return linkedList;
        }
        finally {
            if (rs != null) {
                rs.close();
            }
        }
    }

    public static NullableType getHibernateType(int sqlType, int columnSize, int decimalDigits) {
        logger.debug((Object)("sqlType=" + sqlType));
        logger.debug((Object)("columnSize=" + columnSize));
        logger.debug((Object)("decimalDigits=" + decimalDigits));
        NullableType rv = Hibernate.SERIALIZABLE;
        if (sqlType == 1 || sqlType == 12) {
            rv = Hibernate.STRING;
        } else if (sqlType == 6 || sqlType == 7) {
            rv = Hibernate.FLOAT;
        } else if (sqlType == 4) {
            rv = Hibernate.INTEGER;
        } else if (sqlType == 8) {
            rv = Hibernate.DOUBLE;
        } else if (sqlType == 91) {
            rv = Hibernate.DATE;
        } else if (sqlType == 93) {
            rv = Hibernate.TIMESTAMP;
        } else if (sqlType == 92) {
            rv = Hibernate.TIME;
        } else if (sqlType == 5) {
            rv = Hibernate.SHORT;
        } else if (sqlType == -7) {
            rv = Hibernate.BYTE;
        } else if (sqlType == -5) {
            rv = Hibernate.LONG;
        } else if (sqlType == 2 || sqlType == 3) {
            rv = decimalDigits == 0 ? (columnSize == 1 ? Hibernate.BYTE : (columnSize < 5 ? Hibernate.SHORT : (columnSize < 10 ? Hibernate.INTEGER : Hibernate.LONG))) : (columnSize < 9 ? Hibernate.FLOAT : Hibernate.DOUBLE);
        }
        return rv;
    }

    public static Class getJavaType(int sqlType, int columnSize, int decimalDigits) {
        Class rv;
        logger.debug((Object)("sqlType=" + sqlType));
        logger.debug((Object)("columnSize=" + columnSize));
        logger.debug((Object)("decimalDigits=" + decimalDigits));
        Class clazz = rv = class$java$lang$String == null ? (class$java$lang$String = JDBCUtil.class$("java.lang.String")) : class$java$lang$String;
        if (sqlType == 1 || sqlType == 12) {
            rv = class$java$lang$String == null ? (class$java$lang$String = JDBCUtil.class$("java.lang.String")) : class$java$lang$String;
        } else if (sqlType == 6 || sqlType == 7) {
            rv = class$java$lang$Float == null ? (class$java$lang$Float = JDBCUtil.class$("java.lang.Float")) : class$java$lang$Float;
        } else if (sqlType == 4) {
            rv = class$java$lang$Integer == null ? (class$java$lang$Integer = JDBCUtil.class$("java.lang.Integer")) : class$java$lang$Integer;
        } else if (sqlType == 8) {
            rv = class$java$lang$Double == null ? (class$java$lang$Double = JDBCUtil.class$("java.lang.Double")) : class$java$lang$Double;
        } else if (sqlType == 91) {
            rv = class$java$util$Date == null ? (class$java$util$Date = JDBCUtil.class$("java.util.Date")) : class$java$util$Date;
        } else if (sqlType == 93) {
            rv = class$java$util$Date == null ? (class$java$util$Date = JDBCUtil.class$("java.util.Date")) : class$java$util$Date;
        } else if (sqlType == 92) {
            rv = class$java$util$Date == null ? (class$java$util$Date = JDBCUtil.class$("java.util.Date")) : class$java$util$Date;
        } else if (sqlType == 5) {
            rv = class$java$lang$Short == null ? (class$java$lang$Short = JDBCUtil.class$("java.lang.Short")) : class$java$lang$Short;
        } else if (sqlType == -7) {
            rv = class$java$lang$Byte == null ? (class$java$lang$Byte = JDBCUtil.class$("java.lang.Byte")) : class$java$lang$Byte;
        } else if (sqlType == -5) {
            rv = class$java$lang$Long == null ? (class$java$lang$Long = JDBCUtil.class$("java.lang.Long")) : class$java$lang$Long;
        } else if (sqlType == 2 || sqlType == 3) {
            rv = decimalDigits == 0 ? (columnSize == 1 ? (class$java$lang$Byte == null ? (class$java$lang$Byte = JDBCUtil.class$("java.lang.Byte")) : class$java$lang$Byte) : (columnSize < 5 ? (class$java$lang$Short == null ? (class$java$lang$Short = JDBCUtil.class$("java.lang.Short")) : class$java$lang$Short) : (columnSize < 10 ? (class$java$lang$Integer == null ? (class$java$lang$Integer = JDBCUtil.class$("java.lang.Integer")) : class$java$lang$Integer) : (class$java$lang$Long == null ? (class$java$lang$Long = JDBCUtil.class$("java.lang.Long")) : class$java$lang$Long)))) : (columnSize < 9 ? (class$java$lang$Float == null ? (class$java$lang$Float = JDBCUtil.class$("java.lang.Float")) : class$java$lang$Float) : (class$java$lang$Double == null ? (class$java$lang$Double = JDBCUtil.class$("java.lang.Double")) : class$java$lang$Double));
        }
        return rv;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class Column {
        public String name;
        public int sqlType;
        public int sqlColumnLength;
        public int sqlDecimalLength;
        public boolean sqlNotNull;
        public boolean sqlReadOnly;
        public NullableType hibernateType;
        public Class javaType;

        public boolean equals(Object o) {
            boolean rv = false;
            if (o != null && o instanceof Column) {
                rv = this.name.equals(((Column)o).name);
            }
            return rv;
        }

        public int hashCode() {
            return this.name != null ? this.name.hashCode() : 0;
        }
    }
}

