/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.tool.hbm2java;

import java.util.Set;
import net.sf.hibernate.tool.hbm2java.ClassMapping;
import net.sf.hibernate.tool.hbm2java.ClassName;
import net.sf.hibernate.tool.hbm2java.MappingElement;
import org.apache.commons.collections.MultiMap;
import org.jdom.Element;

public class FieldProperty
extends MappingElement {
    private String fieldName = null;
    private String accessorName = null;
    private boolean id = false;
    private boolean generated = false;
    private boolean nullable = true;
    private ClassName classType;
    private ClassName foreignClass;
    private Set foreignKeys;
    private ClassName implementationClassName;
    private ClassMapping parentClass;

    public FieldProperty(Element element, MappingElement parent, String name, ClassName type, boolean nullable, MultiMap metaattribs) {
        super(element, parent);
        this.initWith(name, type, type, nullable, this.id, false, null, null, metaattribs);
    }

    public FieldProperty(Element element, MappingElement parent, String name, ClassName type, boolean nullable, boolean id, boolean generated, MultiMap metaattribs) {
        super(element, parent);
        this.initWith(name, type, type, nullable, id, generated, null, null, metaattribs);
    }

    public FieldProperty(Element element, MappingElement parent, String name, ClassName type, ClassName implementationClassName, boolean nullable, ClassName foreignClass, Set foreignKeys, MultiMap metaattribs) {
        super(element, parent);
        this.initWith(name, type, implementationClassName, nullable, this.id, false, foreignClass, foreignKeys, metaattribs);
    }

    protected void initWith(String name, ClassName type, ClassName implementationClassName, boolean nullable, boolean id, boolean generated, ClassName foreignClass, Set foreignKeys, MultiMap metaattribs) {
        this.fieldName = name;
        this.setType(type);
        this.nullable = nullable;
        this.id = id;
        this.generated = generated;
        this.implementationClassName = implementationClassName;
        this.accessorName = this.beancapitalize(name);
        this.foreignClass = foreignClass;
        this.foreignKeys = foreignKeys;
        this.setMetaAttribs(metaattribs);
    }

    private String beancapitalize(String fieldname) {
        if (fieldname == null || fieldname.length() == 0) {
            return fieldname;
        }
        if (fieldname.length() > 1 && Character.isUpperCase(fieldname.charAt(1)) && Character.isUpperCase(fieldname.charAt(0))) {
            return fieldname;
        }
        char[] chars = fieldname.toCharArray();
        chars[0] = Character.toUpperCase(chars[0]);
        return new String(chars);
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public String getAccessorName() {
        return this.accessorName;
    }

    private String getGetterType() {
        return this.getFullyQualifiedTypeName().equals("boolean") ? "is" : "get";
    }

    public String getFullyQualifiedTypeName() {
        return this.classType.getFullyQualifiedName();
    }

    public boolean isIdentifier() {
        return this.id;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public boolean isGenerated() {
        return this.generated;
    }

    public String toString() {
        return this.getFullyQualifiedTypeName() + ":" + this.getFieldName();
    }

    public ClassName getClassType() {
        return this.classType;
    }

    private void setType(ClassName type) {
        this.classType = type;
    }

    public ClassName getForeignClass() {
        return this.foreignClass;
    }

    public void setForeignClass(ClassName foreignClass) {
        this.foreignClass = foreignClass;
    }

    public Set getForeignKeys() {
        return this.foreignKeys;
    }

    public String getGetterSignature() {
        return this.getGetterType() + this.getAccessorName() + "()";
    }

    public boolean isGeneratedAsProperty() {
        return this.getMetaAsBool("gen-property", true);
    }

    public ClassName getImplementationClassName() {
        return this.implementationClassName;
    }

    public ClassMapping getParentClass() {
        return this.parentClass;
    }

    public String getScope(String localScopeName, String defaultScope) {
        if (defaultScope == null) {
            defaultScope = "private";
        }
        return this.getMeta(localScopeName) == null ? defaultScope : this.getMetaAsString(localScopeName);
    }

    public String getFieldScope() {
        return this.getScope("scope-field", "private");
    }

    public String getPropertyGetScope() {
        return this.getScope("scope-get", "public");
    }

    public String getPropertySetScope() {
        return this.getScope("scope-set", "public");
    }
}

