/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.message;

import java.util.Iterator;
import org.apache.http.Header;
import org.apache.http.HttpMessage;
import org.apache.http.message.BasicHeader;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;
import org.apache.http.util.HeaderGroup;

public abstract class AbstractHttpMessage
implements HttpMessage {
    private final HeaderGroup headergroup = new HeaderGroup();
    private HttpParams params = new BasicHttpParams(null);

    protected AbstractHttpMessage() {
    }

    public boolean containsHeader(String name) {
        return this.headergroup.containsHeader(name);
    }

    public Header[] getHeaders(String name) {
        return this.headergroup.getHeaders(name);
    }

    public Header getFirstHeader(String name) {
        return this.headergroup.getFirstHeader(name);
    }

    public Header getLastHeader(String name) {
        return this.headergroup.getLastHeader(name);
    }

    public Header[] getAllHeaders() {
        return this.headergroup.getAllHeaders();
    }

    public void addHeader(Header header) {
        this.headergroup.addHeader(header);
    }

    public void addHeader(String name, String value) {
        if (name == null) {
            throw new IllegalArgumentException("Header name may not be null");
        }
        this.headergroup.addHeader(new BasicHeader(name, value));
    }

    public void setHeader(Header header) {
        this.headergroup.updateHeader(header);
    }

    public void setHeader(String name, String value) {
        if (name == null) {
            throw new IllegalArgumentException("Header name may not be null");
        }
        this.headergroup.updateHeader(new BasicHeader(name, value));
    }

    public void setHeaders(Header[] headers) {
        this.headergroup.setHeaders(headers);
    }

    public void removeHeader(Header header) {
        this.headergroup.removeHeader(header);
    }

    public void removeHeaders(String name) {
        if (name == null) {
            return;
        }
        Iterator i = this.headergroup.iterator();
        while (i.hasNext()) {
            Header header = (Header)i.next();
            if (!name.equalsIgnoreCase(header.getName())) continue;
            i.remove();
        }
    }

    public Iterator headerIterator() {
        return this.headergroup.iterator();
    }

    public HttpParams getParams() {
        return this.params;
    }

    public void setParams(HttpParams params) {
        if (params == null) {
            throw new IllegalArgumentException("HTTP parameters may not be null");
        }
        this.params = params;
    }
}

