/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.embedded;

import com.google.common.collect.ImmutableSet;
import info.archinnov.achilles.embedded.AchillesCassandraDaemon;
import info.archinnov.achilles.embedded.CassandraEmbeddedConfigParameters;
import info.archinnov.achilles.embedded.CassandraEmbeddedServer;
import info.archinnov.achilles.embedded.CassandraShutDownHook;
import info.archinnov.achilles.embedded.OrderedShutdownHook;
import info.archinnov.achilles.embedded.PortFinder;
import info.archinnov.achilles.exception.AchillesException;
import info.archinnov.achilles.type.TypedMap;
import info.archinnov.achilles.validation.Validator;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.apache.cassandra.service.CassandraDaemon;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum ServerStarter {
    CASSANDRA_EMBEDDED;

    private static final Logger LOGGER;
    private static final OrderedShutdownHook orderedShutdownHook;
    private static int cqlPort;
    private static int thriftPort;

    private static int storageRandomPort() {
        return PortFinder.findAvailableBetween(7001, 7500);
    }

    private static int storageSslRandomPort() {
        return PortFinder.findAvailableBetween(7501, 7999);
    }

    private static int jxmRandomPort() {
        return PortFinder.findAvailableBetween(7501, 7999);
    }

    private static int cqlRandomPort() {
        return PortFinder.findAvailableBetween(9043, 9499);
    }

    private static int thriftRandomPort() {
        return PortFinder.findAvailableBetween(9501, 9999);
    }

    public void startServer(String cassandraHost, TypedMap parameters) {
        if (StringUtils.isBlank((CharSequence)cassandraHost)) {
            LOGGER.debug("Do start embedded Cassandra server ");
            this.validateDataFolders((Map<String, Object>)parameters);
            this.cleanCassandraDataFiles(parameters);
            this.randomizePortsIfNeeded(parameters);
            CASSANDRA_EMBEDDED.start(parameters);
        }
    }

    public void checkAndConfigurePorts(TypedMap parameters) {
        LOGGER.trace("Check and configure Thrift/CQL ports");
        Integer cqlPort = (Integer)parameters.getTyped("cqlPort");
        Integer thriftPort = (Integer)parameters.getTyped("thriftPort");
        if (cqlPort != null && ServerStarter.cqlPort != cqlPort) {
            throw new IllegalArgumentException(String.format("An embedded Cassandra server is already listening to CQL port '%s', the specified CQL port '%s' does not match", ServerStarter.cqlPort, cqlPort));
        }
        parameters.put((Object)"cqlPort", (Object)ServerStarter.cqlPort);
        if (thriftPort != null && ServerStarter.thriftPort != thriftPort) {
            throw new IllegalArgumentException(String.format("An embedded Cassandra server is already listening to Thrift port '%s', the specified Thrift port '%s' does not match", ServerStarter.thriftPort, thriftPort));
        }
        parameters.put((Object)"thriftPort", (Object)ServerStarter.thriftPort);
    }

    public OrderedShutdownHook getShutdownHook() {
        return orderedShutdownHook;
    }

    private void start(TypedMap parameters) {
        if (this.isAlreadyRunning() && CassandraEmbeddedServer.embeddedServerStarted) {
            LOGGER.debug("Cassandra is already running, not starting new one");
            return;
        }
        String triggersDir = this.createTriggersFolder();
        LOGGER.info(" Cassandra listen address = {}", parameters.getTyped("listenAddress"));
        LOGGER.info(" Cassandra RPC address = {}", parameters.getTyped("rpcAddress"));
        LOGGER.info(" Cassandra broadcast address = {}", parameters.getTyped("broadcastAddress"));
        LOGGER.info(" Cassandra RPC broadcast address = {}", parameters.getTyped("broadcastRpcAddress"));
        LOGGER.info(" Random embedded Cassandra RPC port/Thrift port = {}", parameters.getTyped("thriftPort"));
        LOGGER.info(" Random embedded Cassandra Native port/CQL port = {}", parameters.getTyped("cqlPort"));
        LOGGER.info(" Random embedded Cassandra Storage port = {}", parameters.getTyped("storagePort"));
        LOGGER.info(" Random embedded Cassandra Storage SSL port = {}", parameters.getTyped("storageSSLPort"));
        LOGGER.info(" Random embedded Cassandra Remote JMX port = {}", (Object)System.getProperty("com.sun.management.jmxremote.port", "null"));
        LOGGER.info(" Embedded Cassandra triggers directory = {}", (Object)triggersDir);
        LOGGER.info("Starting Cassandra...");
        System.setProperty("cassandra.triggers_dir", triggersDir);
        System.setProperty("cassandra.embedded.concurrent.reads", ((Integer)parameters.getTypedOr("concurrentReads", (Object)32)).toString());
        System.setProperty("cassandra.embedded.concurrent.writes", ((Integer)parameters.getTypedOr("concurrentWrites", (Object)32)).toString());
        System.setProperty("cassandra-foreground", "true");
        boolean useUnsafeCassandra = (Boolean)parameters.getTyped("useUnsafeCassandraDaemon");
        if (useUnsafeCassandra) {
            System.setProperty("cassandra-num-tokens", "1");
        }
        System.setProperty("cassandra.config.loader", "info.archinnov.achilles.embedded.AchillesCassandraConfig");
        CountDownLatch startupLatch = new CountDownLatch(1);
        final ExecutorService executor = Executors.newSingleThreadExecutor();
        final AtomicReference<CassandraDaemon> daemonRef = new AtomicReference<CassandraDaemon>();
        executor.execute(() -> {
            if (useUnsafeCassandra) {
                LOGGER.warn("******* WARNING, starting unsafe embedded Cassandra daemon. This should be only used for unit testing or development and not for production !");
            }
            AchillesCassandraDaemon cassandraDaemon = useUnsafeCassandra ? new AchillesCassandraDaemon() : new CassandraDaemon();
            cassandraDaemon.completeSetup();
            cassandraDaemon.activate();
            daemonRef.getAndSet(cassandraDaemon);
            startupLatch.countDown();
        });
        try {
            startupLatch.await(30L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            LOGGER.error("Timeout starting Cassandra embedded", (Throwable)e);
            throw new IllegalStateException("Timeout starting Cassandra embedded", e);
        }
        if (parameters.containsKey((Object)"shutdownHook")) {
            CassandraShutDownHook shutDownHook = (CassandraShutDownHook)parameters.getTyped("shutdownHook");
            shutDownHook.addCassandraDaemonRef(daemonRef);
            shutDownHook.addOrderedShutdownHook(orderedShutdownHook);
            shutDownHook.addExecutorService(executor);
        } else {
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    LOGGER.info("Calling stop on Embedded Cassandra server");
                    ((CassandraDaemon)daemonRef.get()).stop();
                    LOGGER.info("Calling shutdown on all Cluster instances");
                    orderedShutdownHook.callShutDown();
                    LOGGER.info("Shutting down embedded Cassandra server");
                    executor.shutdownNow();
                }
            });
        }
    }

    private void validateDataFolders(Map<String, Object> parameters) {
        String dataFolder = (String)parameters.get("datafileFolder");
        String commitLogFolder = (String)parameters.get("commitlogFolder");
        String savedCachesFolder = (String)parameters.get("savedCachesFolder");
        String hintsFolder = (String)parameters.get("hintsFolder");
        LOGGER.debug(" Embedded Cassandra data directory = {}", (Object)dataFolder);
        LOGGER.debug(" Embedded Cassandra commitlog directory = {}", (Object)commitLogFolder);
        LOGGER.debug(" Embedded Cassandra saved caches directory = {}", (Object)savedCachesFolder);
        LOGGER.debug(" Embedded Cassandra hints directory = {}", (Object)hintsFolder);
        this.validateFolder(dataFolder);
        this.validateFolder(commitLogFolder);
        this.validateFolder(savedCachesFolder);
        this.validateFolder(hintsFolder);
        System.setProperty("ACHILLES_EMBEDDED_CASSANDRA_DATA_FOLDER", dataFolder);
        System.setProperty("ACHILLES_EMBEDDED_CASSANDRA_COMMITLOG_FOLDER", commitLogFolder);
        System.setProperty("ACHILLES_EMBEDDED_CASSANDRA_SAVED_CACHES_FOLDER", savedCachesFolder);
        System.setProperty("ACHILLES_EMBEDDED_CASSANDRA_HINTS_FOLDER", hintsFolder);
    }

    private void validateFolder(String folderPath) {
        String currentUser = System.getProperty("user.name");
        File folder = new File(folderPath);
        if (!CassandraEmbeddedConfigParameters.DEFAULT_ACHILLES_TEST_FOLDERS.contains(folderPath)) {
            Validator.validateTrue((boolean)folder.exists(), (String)"Folder '%s' does not exist", (Object[])new Object[]{folder.getAbsolutePath()});
            Validator.validateTrue((boolean)folder.isDirectory(), (String)"Folder '%s' is not a directory", (Object[])new Object[]{folder.getAbsolutePath()});
            Validator.validateTrue((boolean)folder.canRead(), (String)"No read credential. Please grant read permission for the current user '%s' on folder '%s'", (Object[])new Object[]{currentUser, folder.getAbsolutePath()});
            Validator.validateTrue((boolean)folder.canWrite(), (String)"No write credential. Please grant write permission for the current user '%s' on folder '%s'", (Object[])new Object[]{currentUser, folder.getAbsolutePath()});
        } else if (!folder.exists()) {
            try {
                LOGGER.info("Creating folder : " + folder.getAbsolutePath());
                FileUtils.forceMkdir((File)folder);
            }
            catch (IOException e) {
                throw new RuntimeException("Cannot create Cassandra data folder " + folderPath, e);
            }
        } else {
            LOGGER.info("Using existing data folder for unit tests : " + folder.getAbsolutePath());
        }
    }

    private void cleanCassandraDataFiles(TypedMap parameters) {
        if (((Boolean)parameters.getTyped("cleanCassandraDataFiles")).booleanValue()) {
            ImmutableSet dataFolders = ImmutableSet.builder().add(parameters.getTyped("datafileFolder")).add(parameters.getTyped("commitlogFolder")).add(parameters.getTyped("savedCachesFolder")).build();
            for (String dataFolder : dataFolders) {
                File dataFolderFile = new File(dataFolder);
                if (!dataFolderFile.exists() || !dataFolderFile.isDirectory()) continue;
                LOGGER.info("Cleaning up embedded Cassandra data directory '{}'", (Object)dataFolderFile.getAbsolutePath());
                try {
                    FileUtils.cleanDirectory((File)dataFolderFile);
                }
                catch (IOException e) {
                    throw new AchillesException(String.format("Cannot clean data folder %s", dataFolder));
                }
            }
        }
    }

    private void randomizePortsIfNeeded(TypedMap parameters) {
        Integer thriftPort = this.extractAndValidatePort(Optional.ofNullable(parameters.get((Object)"thriftPort")).orElse(ServerStarter.thriftRandomPort()), "thriftPort");
        Integer cqlPort = this.extractAndValidatePort(Optional.ofNullable(parameters.get((Object)"cqlPort")).orElse(ServerStarter.cqlRandomPort()), "cqlPort");
        Integer storagePort = this.extractAndValidatePort(Optional.ofNullable(parameters.get((Object)"storagePort")).orElse(ServerStarter.storageRandomPort()), "storagePort");
        Integer storageSSLPort = this.extractAndValidatePort(Optional.ofNullable(parameters.get((Object)"storageSSLPort")).orElse(ServerStarter.storageSslRandomPort()), "storageSSLPort");
        Integer jmxPort = this.extractAndValidatePort(Optional.ofNullable(parameters.get((Object)"jmxPort")).orElse(ServerStarter.jxmRandomPort()), "jmxPort");
        parameters.put((Object)"thriftPort", (Object)thriftPort);
        parameters.put((Object)"cqlPort", (Object)cqlPort);
        parameters.put((Object)"storagePort", (Object)storagePort);
        parameters.put((Object)"storageSSLPort", (Object)storageSSLPort);
        System.setProperty("ACHILLES_EMBEDDED_CASSANDRA_LISTEN_ADDRESS", (String)parameters.getTyped("listenAddress"));
        System.setProperty("ACHILLES_EMBEDDED_CASSANDRA_RPC_ADDRESS", (String)parameters.getTyped("rpcAddress"));
        System.setProperty("ACHILLES_EMBEDDED_CASSANDRA_BROADCAST_ADDRESS", (String)parameters.getTyped("broadcastAddress"));
        System.setProperty("ACHILLES_EMBEDDED_CASSANDRA_BROADCAST_RPC_ADDRESS", (String)parameters.getTyped("broadcastRpcAddress"));
        System.setProperty("ACHILLES_EMBEDDED_CASSANDRA_THRIFT_PORT", thriftPort.toString());
        System.setProperty("ACHILLES_EMBEDDED_CASSANDRA_CQL_PORT", cqlPort.toString());
        System.setProperty("ACHILLES_EMBEDDED_CASSANDRA_STORAGE_PORT", storagePort.toString());
        System.setProperty("ACHILLES_EMBEDDED_CASSANDRA_STORAGE_SSL_PORT", storageSSLPort.toString());
        System.setProperty("cassandra.jmx.local.port", jmxPort.toString());
        System.setProperty("cassandra.skip_wait_for_gossip_to_settle", "0");
        ServerStarter.cqlPort = cqlPort;
        ServerStarter.thriftPort = thriftPort;
    }

    private Integer extractAndValidatePort(Object port, String portLabel) {
        Validator.validateTrue((boolean)(port instanceof Integer), (String)"The provided '%s' port should be an integer", (Object[])new Object[]{portLabel});
        Validator.validateTrue(((Integer)port > 0 ? 1 : 0) != 0, (String)"The provided '%s' port should positive", (Object[])new Object[]{portLabel});
        return (Integer)port;
    }

    private String createTriggersFolder() {
        LOGGER.trace("Create triggers folder");
        File triggersDir = new File("target/cassandra_embedded/cassandra_triggers");
        if (!triggersDir.exists()) {
            triggersDir.mkdir();
        }
        return triggersDir.getAbsolutePath();
    }

    private boolean isAlreadyRunning() {
        LOGGER.trace("Check whether an embedded Cassandra is already running");
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        try {
            MBeanInfo mBeanInfo = mbs.getMBeanInfo(new ObjectName("org.apache.cassandra.db:type=StorageService"));
            return mBeanInfo != null;
        }
        catch (InstanceNotFoundException e) {
            return false;
        }
        catch (IntrospectionException e) {
            throw new IllegalStateException("Cannot check if cassandra is already running", e);
        }
        catch (MalformedObjectNameException e) {
            throw new IllegalStateException("Cannot check if cassandra is already running", e);
        }
        catch (ReflectionException e) {
            throw new IllegalStateException("Cannot check if cassandra is already running", e);
        }
    }

    static {
        LOGGER = LoggerFactory.getLogger(ServerStarter.class);
        orderedShutdownHook = new OrderedShutdownHook();
    }
}

