/*
 * Decompiled with CFR 0.152.
 */
package com.antstreaming.rtsp.protocol;

import com.antstreaming.rtsp.protocol.RtspHeaderCode;
import com.antstreaming.rtsp.protocol.SafeProperties;
import java.nio.CharBuffer;

public abstract class RtspMessage {
    public static final String CRLF = "\r\n";
    private Long sequenceNumber = 0L;
    private SafeProperties headers = new SafeProperties();
    private StringBuffer buffer = new StringBuffer();
    private StringBuffer originRequest = new StringBuffer();

    public Type getType() {
        return Type.TypeNone;
    }

    public void setHeader(String key, String value) {
        if (key.compareToIgnoreCase("content-length") == 0) {
            this.headers.put("Content-Length", value);
        } else if (value != null) {
            if (value.startsWith(" ")) {
                this.headers.put(key, value);
            } else {
                this.headers.put(key, " " + value);
            }
        }
    }

    public void setHeader(RtspHeaderCode key, String value) {
        if (key.value().compareToIgnoreCase("content-length") == 0) {
            this.headers.put("Content-Length", value);
        } else if (value != null) {
            if (value.startsWith(" ")) {
                this.headers.put(key.value(), value);
            } else {
                this.headers.put(key.value(), " " + value);
            }
        }
    }

    public String getHeader(String key) {
        String value = this.headers.getProperty(key);
        if (value != null) {
            return value.trim();
        }
        return value;
    }

    public String getHeader(RtspHeaderCode key) {
        String value = this.headers.getProperty(key.value());
        if (value != null) {
            return value.trim();
        }
        return value;
    }

    public String getHeader(String key, String defaultValue) {
        String value = this.getHeader(key);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public String getHeadersString() {
        return this.headers.getString();
    }

    public int getHeadersCount() {
        return this.headers.size();
    }

    public SafeProperties getHeaders() {
        return this.headers;
    }

    public void removeHeader(String key) {
        this.headers.remove(key);
    }

    public void setBuffer(StringBuffer buffer) {
        this.buffer = buffer;
    }

    public StringBuffer getBuffer() {
        return this.buffer;
    }

    public void appendToBuffer(StringBuffer other) {
        this.buffer.append(other);
    }

    public void appendToBuffer(CharBuffer other) {
        this.buffer.append(other);
    }

    public int getBufferSize() {
        return this.buffer.toString().length();
    }

    public Long getSequenceNumber() {
        return this.sequenceNumber;
    }

    public void setSequenceNumber(Long sequenceNumber) {
        this.sequenceNumber = sequenceNumber;
    }

    public void saveOriginRequest(String line) {
        this.originRequest.append(line);
    }

    public void saveOriginRequest(StringBuffer body) {
        this.originRequest.append(body);
    }

    public StringBuffer getOriginRequest() {
        return this.originRequest;
    }

    public static enum Type {
        TypeNone,
        TypeRequest,
        TypeResponse;

    }
}

