/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.datastore.db;

import io.antmedia.datastore.db.IDataStore;
import io.antmedia.datastore.db.types.Broadcast;
import io.antmedia.datastore.db.types.Endpoint;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.commons.lang3.RandomStringUtils;

public class InMemoryDataStore
implements IDataStore {
    public LinkedHashMap<String, Broadcast> broadcastMap = new LinkedHashMap();

    public InMemoryDataStore(String dbName) {
    }

    public String save(Broadcast broadcast) {
        String streamId = null;
        if (broadcast != null) {
            try {
                if (broadcast.getStreamId() == null) {
                    streamId = RandomStringUtils.randomNumeric((int)24);
                    broadcast.setStreamId(streamId);
                }
                streamId = broadcast.getStreamId();
                String rtmpURL = broadcast.getRtmpURL();
                if (rtmpURL != null) {
                    rtmpURL = rtmpURL + streamId;
                }
                broadcast.setRtmpURL(rtmpURL);
                this.broadcastMap.put(streamId, broadcast);
            }
            catch (Exception e) {
                e.printStackTrace();
                streamId = null;
            }
        }
        return streamId;
    }

    public Broadcast get(String id) {
        return this.broadcastMap.get(id);
    }

    public boolean updateName(String id, String name, String description) {
        Broadcast broadcast = this.broadcastMap.get(id);
        boolean result = false;
        if (broadcast != null) {
            broadcast.setName(name);
            broadcast.setDescription(description);
            this.broadcastMap.put(id, broadcast);
            result = true;
        }
        return result;
    }

    public boolean updateStatus(String id, String status) {
        Broadcast broadcast = this.broadcastMap.get(id);
        boolean result = false;
        if (broadcast != null) {
            broadcast.setStatus(status);
            this.broadcastMap.put(id, broadcast);
            result = true;
        }
        return result;
    }

    public boolean updateDuration(String id, long duration) {
        Broadcast broadcast = this.broadcastMap.get(id);
        boolean result = false;
        if (broadcast != null) {
            broadcast.setDuration(Long.valueOf(duration));
            this.broadcastMap.put(id, broadcast);
            result = true;
        }
        return result;
    }

    public boolean updatePublish(String id, boolean publish) {
        Broadcast broadcast = this.broadcastMap.get(id);
        boolean result = false;
        if (broadcast != null) {
            broadcast.setPublish(publish);
            this.broadcastMap.put(id, broadcast);
            result = true;
        }
        return result;
    }

    public boolean addEndpoint(String id, Endpoint endpoint) {
        Broadcast broadcast = this.broadcastMap.get(id);
        boolean result = false;
        if (broadcast != null && endpoint != null) {
            ArrayList<Endpoint> endPointList = broadcast.getEndPointList();
            if (endPointList == null) {
                endPointList = new ArrayList<Endpoint>();
            }
            endPointList.add(endpoint);
            broadcast.setEndPointList(endPointList);
            this.broadcastMap.put(id, broadcast);
            result = true;
        }
        return result;
    }

    public boolean removeEndpoint(String id, Endpoint endpoint) {
        List endPointList;
        boolean result = false;
        Broadcast broadcast = this.broadcastMap.get(id);
        if (broadcast != null && endpoint != null && (endPointList = broadcast.getEndPointList()) != null) {
            Iterator iterator = endPointList.iterator();
            while (iterator.hasNext()) {
                Endpoint endpointItem = (Endpoint)iterator.next();
                if (!endpointItem.rtmpUrl.equals(endpoint.rtmpUrl)) continue;
                iterator.remove();
                result = true;
                break;
            }
        }
        return result;
    }

    public long getBroadcastCount() {
        return this.broadcastMap.size();
    }

    public boolean delete(String id) {
        Broadcast broadcast = this.broadcastMap.get(id);
        boolean result = false;
        if (broadcast != null) {
            this.broadcastMap.remove(id);
            result = true;
        }
        return result;
    }

    public List<Broadcast> getBroadcastList(int offset, int size) {
        Collection<Broadcast> values = this.broadcastMap.values();
        int t = 0;
        int itemCount = 0;
        if (size > 50) {
            size = 50;
        }
        if (offset < 0) {
            offset = 0;
        }
        ArrayList<Broadcast> list = new ArrayList<Broadcast>();
        for (Broadcast broadcast : values) {
            if (t < offset) {
                ++t;
                continue;
            }
            list.add(broadcast);
            if (++itemCount < size) continue;
            break;
        }
        return list;
    }
}

