/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.datastore.db;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.antmedia.datastore.db.IDataStore;
import io.antmedia.datastore.db.types.Broadcast;
import io.antmedia.datastore.db.types.Endpoint;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.RandomStringUtils;
import org.mapdb.DB;
import org.mapdb.DBMaker;
import org.mapdb.HTreeMap;
import org.mapdb.Serializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapDBStore
implements IDataStore {
    private DB db;
    private HTreeMap<String, String> map;
    private Gson gson;
    protected static Logger logger = LoggerFactory.getLogger(MapDBStore.class);
    private static final String MAP_NAME = "broadcast";

    public MapDBStore(String dbName) {
        this.db = DBMaker.fileDB((String)dbName).transactionEnable().make();
        this.map = this.db.hashMap(MAP_NAME).keySerializer((Serializer)Serializer.STRING).valueSerializer((Serializer)Serializer.STRING).counterEnable().createOrOpen();
        GsonBuilder builder = new GsonBuilder();
        this.gson = builder.create();
    }

    public String save(Broadcast broadcast) {
        String streamId = null;
        if (broadcast != null) {
            try {
                if (broadcast.getStreamId() == null) {
                    streamId = RandomStringUtils.randomNumeric((int)24);
                    broadcast.setStreamId(streamId);
                }
                streamId = broadcast.getStreamId();
                String rtmpURL = broadcast.getRtmpURL();
                if (rtmpURL != null) {
                    rtmpURL = rtmpURL + streamId;
                }
                broadcast.setRtmpURL(rtmpURL);
                this.map.put((Object)streamId, (Object)this.gson.toJson((Object)broadcast));
                this.db.commit();
            }
            catch (Exception e) {
                e.printStackTrace();
                streamId = null;
            }
        }
        return streamId;
    }

    public Broadcast get(String id) {
        String jsonString;
        if (id != null && (jsonString = (String)this.map.get((Object)id)) != null) {
            return (Broadcast)this.gson.fromJson(jsonString, Broadcast.class);
        }
        return null;
    }

    public boolean updateName(String id, String name, String description) {
        String jsonString;
        boolean result = false;
        if (id != null && (jsonString = (String)this.map.get((Object)id)) != null) {
            Broadcast broadcast = (Broadcast)this.gson.fromJson(jsonString, Broadcast.class);
            broadcast.setName(name);
            broadcast.setDescription(description);
            this.map.replace((Object)id, (Object)this.gson.toJson((Object)broadcast));
            this.db.commit();
            result = true;
        }
        return result;
    }

    public boolean updateStatus(String id, String status) {
        String jsonString;
        boolean result = false;
        if (id != null && (jsonString = (String)this.map.get((Object)id)) != null) {
            Broadcast broadcast = (Broadcast)this.gson.fromJson(jsonString, Broadcast.class);
            broadcast.setStatus(status);
            this.map.replace((Object)id, (Object)this.gson.toJson((Object)broadcast));
            this.db.commit();
            result = true;
        }
        return result;
    }

    public boolean updateDuration(String id, long duration) {
        String jsonString;
        boolean result = false;
        if (id != null && (jsonString = (String)this.map.get((Object)id)) != null) {
            Broadcast broadcast = (Broadcast)this.gson.fromJson(jsonString, Broadcast.class);
            broadcast.setDuration(Long.valueOf(duration));
            this.map.replace((Object)id, (Object)this.gson.toJson((Object)broadcast));
            this.db.commit();
            result = true;
        }
        return result;
    }

    public boolean updatePublish(String id, boolean publish) {
        String jsonString = (String)this.map.get((Object)id);
        boolean result = false;
        if (jsonString != null) {
            Broadcast broadcast = (Broadcast)this.gson.fromJson(jsonString, Broadcast.class);
            broadcast.setPublish(publish);
            this.map.replace((Object)id, (Object)this.gson.toJson((Object)broadcast));
            this.db.commit();
            result = true;
        }
        return result;
    }

    public boolean addEndpoint(String id, Endpoint endpoint) {
        String jsonString;
        boolean result = false;
        if (id != null && endpoint != null && (jsonString = (String)this.map.get((Object)id)) != null) {
            Broadcast broadcast = (Broadcast)this.gson.fromJson(jsonString, Broadcast.class);
            ArrayList<Endpoint> endPointList = broadcast.getEndPointList();
            if (endPointList == null) {
                endPointList = new ArrayList<Endpoint>();
            }
            endPointList.add(endpoint);
            broadcast.setEndPointList(endPointList);
            this.map.replace((Object)id, (Object)this.gson.toJson((Object)broadcast));
            this.db.commit();
            result = true;
        }
        return result;
    }

    public boolean removeEndpoint(String id, Endpoint endpoint) {
        Broadcast broadcast;
        List endPointList;
        String jsonString;
        boolean result = false;
        if (id != null && endpoint != null && (jsonString = (String)this.map.get((Object)id)) != null && (endPointList = (broadcast = (Broadcast)this.gson.fromJson(jsonString, Broadcast.class)).getEndPointList()) != null) {
            Iterator iterator = endPointList.iterator();
            while (iterator.hasNext()) {
                Endpoint endpointItem = (Endpoint)iterator.next();
                if (!endpointItem.rtmpUrl.equals(endpoint.rtmpUrl)) continue;
                iterator.remove();
                result = true;
                break;
            }
            if (result) {
                broadcast.setEndPointList(endPointList);
                this.map.replace((Object)id, (Object)this.gson.toJson((Object)broadcast));
                this.db.commit();
            }
        }
        return result;
    }

    public long getBroadcastCount() {
        return this.map.getSize();
    }

    public boolean delete(String id) {
        boolean result;
        boolean bl = result = this.map.remove((Object)id) != null;
        if (result) {
            this.db.commit();
        }
        return result;
    }

    public List<Broadcast> getBroadcastList(int offset, int size) {
        Collection values = this.map.values();
        int t = 0;
        int itemCount = 0;
        if (size > 50) {
            size = 50;
        }
        if (offset < 0) {
            offset = 0;
        }
        ArrayList<Broadcast> list = new ArrayList<Broadcast>();
        for (String broadcastString : values) {
            if (t < offset) {
                ++t;
                continue;
            }
            list.add((Broadcast)this.gson.fromJson(broadcastString, Broadcast.class));
            if (++itemCount < size) continue;
            break;
        }
        return list;
    }
}

