/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.security;

import io.antmedia.datastore.db.IDataStore;
import io.antmedia.datastore.db.types.Broadcast;
import org.red5.server.api.Red5;
import org.red5.server.api.scope.IScope;
import org.red5.server.api.stream.IStreamPublishSecurity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpireStreamPublishSecurity
implements IStreamPublishSecurity {
    private IDataStore dataStore;
    protected static Logger logger = LoggerFactory.getLogger(ExpireStreamPublishSecurity.class);

    public boolean isPublishAllowed(IScope scope, String name, String mode) {
        boolean result = false;
        Broadcast broadcast = this.dataStore.get(name);
        if (broadcast != null) {
            int expireDurationMS = broadcast.getExpireDurationMS();
            if (expireDurationMS != 0) {
                if (System.currentTimeMillis() < broadcast.getDate() + (long)expireDurationMS) {
                    result = true;
                } else {
                    logger.info("Not allowing the stream " + broadcast.getStreamId() + " to publish. It is expired.");
                }
            } else {
                result = true;
            }
        } else {
            result = true;
        }
        if (!result) {
            Red5.getConnectionLocal().close();
        }
        return result;
    }

    public IDataStore getDataStore() {
        return this.dataStore;
    }

    public void setDataStore(IDataStore dataStore) {
        this.dataStore = dataStore;
    }
}

