/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.social.endpoint;

import io.antmedia.api.periscope.AuthorizationEndpoints;
import io.antmedia.api.periscope.BroadcastEndpoints;
import io.antmedia.api.periscope.PeriscopeEndpointFactory;
import io.antmedia.api.periscope.RegionEndpoints;
import io.antmedia.api.periscope.response.AuthorizationResponse;
import io.antmedia.api.periscope.response.CheckDeviceCodeResponse;
import io.antmedia.api.periscope.response.CreateBroadcastResponse;
import io.antmedia.api.periscope.response.CreateDeviceCodeResponse;
import io.antmedia.datastore.db.types.Endpoint;
import io.antmedia.datastore.preference.PreferenceStore;
import io.antmedia.social.endpoint.VideoServiceEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PeriscopeEndpoint
extends VideoServiceEndpoint {
    private static final String serviceName = "periscope";
    private AuthorizationEndpoints authorizationEndpoint;
    private String device_code;
    private PeriscopeEndpointFactory periscopeEndpointFactory;
    private BroadcastEndpoints broadcastEndpoint;
    private RegionEndpoints regionEndpoint;
    private String accessToken;
    private String region;
    private long expireTimeMS;
    protected static Logger logger = LoggerFactory.getLogger(PeriscopeEndpoint.class);

    public PeriscopeEndpoint(String clientId, String clientSecret, PreferenceStore dataStore) {
        super(clientId, clientSecret, dataStore);
    }

    @Override
    public String getName() {
        return serviceName;
    }

    @Override
    public VideoServiceEndpoint.DeviceAuthParameters askDeviceAuthParameters() throws Exception {
        AuthorizationEndpoints authorizationEndpoint = this.getAuthorizationEndpoint();
        CreateDeviceCodeResponse response = authorizationEndpoint.createDeviceCode(this.getClientId());
        VideoServiceEndpoint.DeviceAuthParameters authParameters = null;
        if (response != null) {
            authParameters = new VideoServiceEndpoint.DeviceAuthParameters();
            authParameters.device_code = response.device_code;
            this.device_code = response.device_code;
            authParameters.expires_in = response.expires_in;
            authParameters.interval = response.interval;
            authParameters.user_code = response.user_code;
            authParameters.verification_url = response.associate_url;
        }
        return authParameters;
    }

    private AuthorizationEndpoints getAuthorizationEndpoint() {
        if (this.authorizationEndpoint == null) {
            this.authorizationEndpoint = new AuthorizationEndpoints();
        }
        return this.authorizationEndpoint;
    }

    @Override
    public boolean askIfDeviceAuthenticated() throws Exception {
        AuthorizationEndpoints authorizationEndpoint = this.getAuthorizationEndpoint();
        CheckDeviceCodeResponse checkDeviceCode = authorizationEndpoint.checkDeviceCode(this.device_code, this.getClientId());
        logger.warn("State: " + checkDeviceCode.state);
        boolean result = false;
        if (checkDeviceCode.state.equals("associated")) {
            this.saveCredentials(checkDeviceCode.access_token, checkDeviceCode.refresh_token, String.valueOf(checkDeviceCode.expires_in), checkDeviceCode.token_type);
            this.init(checkDeviceCode.access_token, checkDeviceCode.refresh_token, checkDeviceCode.expires_in, checkDeviceCode.token_type, System.currentTimeMillis());
            result = true;
        }
        return result;
    }

    @Override
    public boolean isAuthenticated() {
        return this.periscopeEndpointFactory != null && this.accessToken != null && this.accessToken.length() > 0;
    }

    @Override
    public void resetCredentials() {
        super.resetCredentials();
        this.accessToken = null;
    }

    @Override
    public Endpoint createBroadcast(String name, String description, boolean is360, boolean isPublic, int videoHeight) throws Exception {
        if (this.broadcastEndpoint == null) {
            throw new Exception("First authenticated the server");
        }
        this.updateTokenIfRequired();
        CreateBroadcastResponse createBroadcastResponse = this.broadcastEndpoint.createBroadcast(this.getRegion(), is360);
        String rtmpUrl = createBroadcastResponse.encoder.rtmp_url + "/" + createBroadcastResponse.encoder.stream_key;
        return new Endpoint(createBroadcastResponse.broadcast.id, null, name, rtmpUrl, this.getName());
    }

    private String getRegion() {
        if (this.region != null) {
            try {
                this.region = this.regionEndpoint.get();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.region;
    }

    @Override
    public void publishBroadcast(Endpoint endpoint) throws Exception {
        if (this.broadcastEndpoint == null) {
            throw new Exception("First authenticated the server");
        }
        if (endpoint.broadcastId == null) {
            throw new Exception("No broadcast is available, call createBroadcast function before calling publish broadcast");
        }
        this.updateTokenIfRequired();
        this.broadcastEndpoint.publishBroadcast(endpoint.broadcastId, endpoint.name, false, "en_US");
    }

    @Override
    public void stopBroadcast(Endpoint endpoint) throws Exception {
        if (this.broadcastEndpoint == null) {
            throw new Exception("First authenticated the server");
        }
        if (endpoint.broadcastId == null) {
            throw new Exception("No broadcast is available");
        }
        this.updateTokenIfRequired();
        this.broadcastEndpoint.stopBroadcast(endpoint.broadcastId);
    }

    private void updateTokenIfRequired() {
        if (this.expireTimeMS < System.currentTimeMillis() + THREE_DAYS_IN_MS) {
            AuthorizationResponse token = this.periscopeEndpointFactory.refreshToken(this.clientId, this.clientSecret);
            this.saveCredentials(token.access_token, token.refresh_token, String.valueOf(token.expires_in), token.token_type);
            this.init(token.access_token, token.refresh_token, Long.valueOf(token.expires_in), token.token_type, System.currentTimeMillis());
        }
    }

    @Override
    public void init(String accessToken, String refreshToken, long expireTime, String tokenType, long authTimeInMS) {
        this.accessToken = accessToken;
        this.periscopeEndpointFactory = new PeriscopeEndpointFactory(tokenType, accessToken, refreshToken);
        this.expireTimeMS = authTimeInMS + expireTime * 1000L;
        this.broadcastEndpoint = this.periscopeEndpointFactory.getBroadcastEndpoints();
        this.regionEndpoint = this.periscopeEndpointFactory.getRegionEndpoints();
    }
}

