/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.webrtc;

import io.antmedia.webrtc.api.IStreamInfo;
import io.antmedia.webrtc.api.IWebRTCAdaptor;
import io.antmedia.webrtc.api.IWebRTCClient;
import io.antmedia.webrtc.api.IWebRTCMuxer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebRTCAdaptor
implements IWebRTCAdaptor {
    Map<String, List<IWebRTCMuxer>> muxerMap = new ConcurrentHashMap<String, List<IWebRTCMuxer>>();
    protected static Logger logger = LoggerFactory.getLogger(WebRTCAdaptor.class);

    @Override
    public void registerMuxer(String streamId, IWebRTCMuxer webRTCMuxer) {
        List<IWebRTCMuxer> list = this.muxerMap.get(streamId);
        if (list == null) {
            list = new ArrayList<IWebRTCMuxer>();
        }
        list.add(webRTCMuxer);
        this.muxerMap.put(streamId, list);
    }

    @Override
    public void unRegisterMuxer(String streamId, IWebRTCMuxer webRTCMuxer) {
        List<IWebRTCMuxer> list = this.muxerMap.get(streamId);
        if (list != null) {
            list.remove(webRTCMuxer);
        }
        if (list == null || list.size() == 0) {
            this.muxerMap.remove(streamId);
        }
    }

    @Override
    public boolean registerWebRTCClient(String streamId, IWebRTCClient webRTCClient) {
        boolean result = false;
        List<IWebRTCMuxer> list = this.muxerMap.get(streamId);
        if (list != null && list.size() > 0) {
            IWebRTCMuxer lowestBitrateMuxer = null;
            for (IWebRTCMuxer iWebRTCMuxer : list) {
                int videoBitrate = iWebRTCMuxer.getVideoBitrate();
                if (lowestBitrateMuxer != null && lowestBitrateMuxer.getVideoBitrate() <= videoBitrate) continue;
                lowestBitrateMuxer = iWebRTCMuxer;
            }
            if (lowestBitrateMuxer != null) {
                lowestBitrateMuxer.registerWebRTCClient(webRTCClient);
                result = true;
            }
        }
        return result;
    }

    @Override
    public boolean streamExists(String streamId) {
        List<IWebRTCMuxer> list = this.muxerMap.get(streamId);
        return list != null && list.size() > 0;
    }

    @Override
    public List<IStreamInfo> getStreamOptions(String streamId) {
        List<IStreamInfo> streamList = this.muxerMap.get(streamId);
        return streamList;
    }

    @Override
    public void adaptStreamingQuality(String streamId, IWebRTCClient webRTCClient) {
        List<IWebRTCMuxer> list = this.muxerMap.get(streamId);
        IWebRTCMuxer currentlyRegisteredMuxer = webRTCClient.getWebRTCMuxer();
        IStreamInfo adaptedMuxer = null;
        int bitrate = webRTCClient.getTargetBitrate();
        int currentBitrateDiff = bitrate - (currentlyRegisteredMuxer.getVideoBitrate() + currentlyRegisteredMuxer.getAudioBitrate());
        for (IWebRTCMuxer iWebRTCMuxer : list) {
            int bitrate_diff = bitrate - (iWebRTCMuxer.getVideoBitrate() + iWebRTCMuxer.getAudioBitrate());
            if (bitrate_diff <= 0 || bitrate_diff >= currentBitrateDiff && currentBitrateDiff >= 0) continue;
            currentBitrateDiff = bitrate_diff;
            adaptedMuxer = iWebRTCMuxer;
        }
        if (adaptedMuxer != null && !currentlyRegisteredMuxer.equals(adaptedMuxer)) {
            logger.info(" switching muxer for the stream id: " + streamId + " adapted muxer video bitrate: " + adaptedMuxer.getVideoBitrate() + " audio bitrate: " + adaptedMuxer.getAudioBitrate() + " webrtc client target bitrate: " + bitrate);
            currentlyRegisteredMuxer.unRegisterWebRTCClient(webRTCClient);
            adaptedMuxer.registerWebRTCClient(webRTCClient);
        } else {
            logger.info("not found a more suitable adapted muxer for " + streamId + " current muxer video bitrate: " + currentlyRegisteredMuxer.getVideoBitrate() + " audio bitrate: " + currentlyRegisteredMuxer.getAudioBitrate() + " webrtc client target bitrate: " + bitrate);
        }
    }
}

