/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.webrtc;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.antmedia.webrtc.api.IWebRTCAdaptor;
import io.antmedia.webrtc.api.IWebRTCClient;
import io.antmedia.webrtc.api.IWebRTCMuxer;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.json.simple.JSONObject;
import org.red5.net.websocket.WebSocketConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.webrtc.AudioSource;
import org.webrtc.DataChannel;
import org.webrtc.IceCandidate;
import org.webrtc.MediaConstraints;
import org.webrtc.MediaStream;
import org.webrtc.PeerConnection;
import org.webrtc.PeerConnectionFactory;
import org.webrtc.RtpReceiver;
import org.webrtc.SdpObserver;
import org.webrtc.SessionDescription;
import org.webrtc.VideoSource;

public class WebRTCClient
implements IWebRTCClient,
PeerConnection.Observer,
SdpObserver {
    private MediaConstraints pcConstraints;
    private MediaConstraints sdpMediaConstraints;
    private PeerConnectionFactory factory;
    private PeerConnection peerConnection;
    private VideoSource videoSource;
    private AudioSource audioSource;
    private int width;
    private int height;
    private MediaStream mediaStream;
    private WebSocketConnection wsConnection;
    private IWebRTCAdaptor webRTCAdaptor;
    private String streamId;
    private IWebRTCMuxer webRTCMuxer;
    private static Logger logger = LoggerFactory.getLogger(WebRTCClient.class);
    private ScheduledExecutorService executor;
    private ExecutorService audioStreamExecutor;
    private ExecutorService videoStreamExecutor;
    public static final int ADAPTIVE_RESET_COUNT = 90;
    public static final int ADAPTIVE_QUALITY_CHECK_TIME_MS = 5000;
    private volatile boolean isInitialized = false;
    private volatile boolean isStreaming = false;
    private static final String DTLS_SRTP_KEY_AGREEMENT_CONSTRAINT = "DtlsSrtpKeyAgreement";
    private ScheduledFuture<?> adaptStreamScheduledFuture;
    protected boolean settingRemoteDescription = false;
    private boolean remoteDescriptionSet = false;

    public WebRTCClient(WebSocketConnection wsConnection, String streamId) {
        this.wsConnection = wsConnection;
        this.streamId = streamId;
        ThreadFactory namedThreadFactory = new ThreadFactoryBuilder().setNameFormat("webrtc-client-" + streamId + "-%d").build();
        this.executor = Executors.newSingleThreadScheduledExecutor(namedThreadFactory);
        namedThreadFactory = new ThreadFactoryBuilder().setNameFormat("webrtc-streamer-" + streamId + "-%d").build();
        this.audioStreamExecutor = Executors.newSingleThreadExecutor(namedThreadFactory);
        this.videoStreamExecutor = Executors.newSingleThreadExecutor(namedThreadFactory);
    }

    public String getStreamId() {
        return this.streamId;
    }

    @Override
    public void setWebRTCAdaptor(IWebRTCAdaptor webRTCAdaptor) {
        this.webRTCAdaptor = webRTCAdaptor;
    }

    @Override
    public void sendVideoConfPacket(final byte[] videoConfData, final byte[] videoPacket, final long timestamp) {
        if (this.isStreaming) {
            this.videoStreamExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    WebRTCClient.this.factory.addVideoConfPacket(videoConfData, videoConfData.length, videoPacket, videoPacket.length, WebRTCClient.this.width, WebRTCClient.this.height, true, timestamp);
                }
            });
        }
    }

    @Override
    public void sendVideoPacket(final byte[] videoPacket, final boolean isKeyFrame, final long timestamp) {
        if (this.isStreaming) {
            this.videoStreamExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    WebRTCClient.this.factory.addVideoPacket(videoPacket, videoPacket.length, WebRTCClient.this.width, WebRTCClient.this.height, isKeyFrame, timestamp);
                }
            });
        }
    }

    @Override
    public void sendAudioPacket(final byte[] audioPacket, final long timestamp) {
        if (this.isStreaming) {
            this.audioStreamExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    WebRTCClient.this.factory.addAudioPacket(audioPacket, audioPacket.length, timestamp, 960);
                }
            });
        }
    }

    @Override
    public int getTargetBitrate() {
        return (int)this.factory.getTargetedBitrate();
    }

    public static PeerConnectionFactory createPeerConnectionFactory() {
        PeerConnectionFactory.Options options = new PeerConnectionFactory.Options();
        options.networkIgnoreMask = 0;
        return new PeerConnectionFactory(options);
    }

    @Override
    public void start() {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                ArrayList<PeerConnection.IceServer> iceServers = new ArrayList<PeerConnection.IceServer>();
                iceServers.add(new PeerConnection.IceServer("stun:stun.l.google.com:19302"));
                PeerConnection.RTCConfiguration rtcConfig = new PeerConnection.RTCConfiguration(iceServers);
                WebRTCClient.this.createMediaConstraintsInternal();
                WebRTCClient.this.factory = WebRTCClient.createPeerConnectionFactory();
                WebRTCClient.this.peerConnection = WebRTCClient.this.factory.createPeerConnection(rtcConfig, WebRTCClient.this.pcConstraints, (PeerConnection.Observer)WebRTCClient.this);
                WebRTCClient.this.mediaStream = WebRTCClient.this.factory.createLocalMediaStream("local_stream");
                WebRTCClient.this.audioSource = WebRTCClient.this.factory.createAudioSource(WebRTCClient.this.pcConstraints);
                WebRTCClient.this.mediaStream.addTrack(WebRTCClient.this.factory.createAudioTrack("audio", WebRTCClient.this.audioSource));
                WebRTCClient.this.videoSource = WebRTCClient.this.factory.createVideoSource();
                WebRTCClient.this.mediaStream.addTrack(WebRTCClient.this.factory.createVideoTrack("video", WebRTCClient.this.videoSource));
                WebRTCClient.this.peerConnection.addStream(WebRTCClient.this.mediaStream);
                WebRTCClient.this.peerConnection.createOffer(WebRTCClient.this, WebRTCClient.this.sdpMediaConstraints);
                WebRTCClient.this.isInitialized = true;
            }
        });
    }

    private void createMediaConstraintsInternal() {
        this.pcConstraints = new MediaConstraints();
        this.pcConstraints.optional.add(new MediaConstraints.KeyValuePair(DTLS_SRTP_KEY_AGREEMENT_CONSTRAINT, "true"));
        this.sdpMediaConstraints = new MediaConstraints();
        this.sdpMediaConstraints.mandatory.add(new MediaConstraints.KeyValuePair("OfferToReceiveAudio", "false"));
        this.sdpMediaConstraints.mandatory.add(new MediaConstraints.KeyValuePair("OfferToReceiveVideo", "false"));
    }

    @Override
    public void onSignalingChange(PeerConnection.SignalingState newState) {
        logger.info("onSignalingChange : " + (Object)((Object)newState));
    }

    @Override
    public void onIceConnectionChange(PeerConnection.IceConnectionState newState) {
        logger.info("IceConnectionState: " + (Object)((Object)newState));
        if (newState == PeerConnection.IceConnectionState.CONNECTED) {
            logger.info("Signalling state: " + (Object)((Object)this.peerConnection.signalingState()));
            if (this.remoteDescriptionSet) {
                this.startStreaming();
            }
        } else if (newState == PeerConnection.IceConnectionState.FAILED || newState == PeerConnection.IceConnectionState.CLOSED) {
            this.stop();
        }
    }

    private void startStreaming() {
        if (this.isStreaming) {
            return;
        }
        logger.info("Starting streaming....");
        this.isStreaming = true;
        this.executor.schedule(new Runnable(){

            @Override
            public void run() {
                WebRTCClient.this.webRTCAdaptor.registerWebRTCClient(WebRTCClient.this.streamId, WebRTCClient.this);
                try {
                    JSONObject jsonObject = new JSONObject();
                    jsonObject.put((Object)"command", (Object)"notification");
                    jsonObject.put((Object)"definition", (Object)"play_started");
                    WebRTCClient.this.wsConnection.send(jsonObject.toJSONString());
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
            }
        }, 0L, TimeUnit.MILLISECONDS);
        this.adaptStreamScheduledFuture = this.executor.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                WebRTCClient.this.webRTCAdaptor.adaptStreamingQuality(WebRTCClient.this.streamId, WebRTCClient.this);
            }
        }, 5000L, 5000L, TimeUnit.MILLISECONDS);
    }

    @Override
    public void onIceConnectionReceivingChange(boolean receiving) {
        logger.info("onIceConnectionReceivingChange : " + receiving);
    }

    @Override
    public void onIceGatheringChange(PeerConnection.IceGatheringState newState) {
        logger.info("onIceGatheringChange : " + (Object)((Object)newState));
    }

    @Override
    public void onIceCandidate(IceCandidate candidate) {
        logger.info("onIceCandidate : " + candidate);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)"command", (Object)"takeCandidate");
        jsonObject.put((Object)"label", (Object)candidate.sdpMLineIndex);
        jsonObject.put((Object)"id", (Object)candidate.sdpMid);
        jsonObject.put((Object)"candidate", (Object)candidate.sdp);
        try {
            this.wsConnection.send(jsonObject.toJSONString());
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onIceCandidatesRemoved(IceCandidate[] candidates) {
        logger.info("onIceCandidatesRemoved : " + candidates);
    }

    @Override
    public void onAddStream(MediaStream stream) {
        logger.info("onAddStream : " + stream);
    }

    @Override
    public void onRemoveStream(MediaStream stream) {
        logger.info("onRemoveStream : " + stream);
    }

    @Override
    public void onDataChannel(DataChannel dataChannel) {
        logger.info("onDataChannel : " + dataChannel);
    }

    @Override
    public void onRenegotiationNeeded() {
        logger.info("onRenegotiationNeeded");
    }

    @Override
    public void onAddTrack(RtpReceiver receiver, MediaStream[] mediaStreams) {
        logger.info("onAddTrack : " + receiver);
    }

    @Override
    public void onCreateSuccess(final SessionDescription sdp) {
        logger.info("onCreateSuccess : " + sdp);
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                logger.info("setting local description");
                WebRTCClient.this.peerConnection.setLocalDescription(WebRTCClient.this, sdp);
                JSONObject jsonObject = new JSONObject();
                jsonObject.put((Object)"command", (Object)"takeConfiguration");
                jsonObject.put((Object)"sdp", (Object)sdp.description);
                String type = sdp.type == SessionDescription.Type.ANSWER ? "answer" : "offer";
                jsonObject.put((Object)"type", (Object)type);
                try {
                    WebRTCClient.this.wsConnection.send(jsonObject.toJSONString());
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    @Override
    public void onSetSuccess() {
        logger.info("onSetSuccess");
        if (this.settingRemoteDescription) {
            this.remoteDescriptionSet = true;
            switch (this.peerConnection.iceConnectionState()) {
                case CONNECTED: 
                case COMPLETED: {
                    this.startStreaming();
                }
            }
        }
    }

    @Override
    public void onCreateFailure(String error) {
        logger.info("onCreateFailure : " + error);
    }

    @Override
    public void onSetFailure(String error) {
        logger.info("onSetFailure : " + error);
    }

    @Override
    public void setRemoteDescription(final SessionDescription sdp) {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                if (WebRTCClient.this.peerConnection != null) {
                    WebRTCClient.this.settingRemoteDescription = true;
                    logger.info("setting remote description ");
                    WebRTCClient.this.peerConnection.setRemoteDescription(WebRTCClient.this, sdp);
                } else {
                    logger.warn("Peer connection is null. It cannot add ice candidate");
                }
            }
        });
    }

    @Override
    public void addIceCandidate(final IceCandidate iceCandidate) {
        logger.info("addIceCandidate : " + iceCandidate);
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                if (WebRTCClient.this.peerConnection != null) {
                    WebRTCClient.this.peerConnection.addIceCandidate(iceCandidate);
                } else {
                    logger.warn("Peer connection is null. It cannot set remote description");
                }
            }
        });
    }

    @Override
    public void setVideoResolution(int width, int height) {
        this.width = width;
        this.height = height;
    }

    @Override
    public void setWebRTCMuxer(IWebRTCMuxer webRTCMuxer) {
        this.webRTCMuxer = webRTCMuxer;
    }

    @Override
    public IWebRTCMuxer getWebRTCMuxer() {
        return this.webRTCMuxer;
    }

    @Override
    public void stop() {
        if (!this.isInitialized) {
            logger.info("Stop is already called");
            return;
        }
        logger.info("Stopping webrtc client");
        this.isInitialized = false;
        this.isStreaming = false;
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                if (WebRTCClient.this.webRTCMuxer != null) {
                    WebRTCClient.this.webRTCMuxer.unRegisterWebRTCClient(WebRTCClient.this);
                }
                WebRTCClient.this.audioStreamExecutor.shutdownNow();
                WebRTCClient.this.videoStreamExecutor.shutdownNow();
                try {
                    JSONObject jsonObject = new JSONObject();
                    jsonObject.put((Object)"command", (Object)"notification");
                    jsonObject.put((Object)"definition", (Object)"play_finished");
                    WebRTCClient.this.wsConnection.send(jsonObject.toJSONString());
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
                try {
                    WebRTCClient.this.audioStreamExecutor.awaitTermination(10L, TimeUnit.SECONDS);
                    WebRTCClient.this.videoStreamExecutor.awaitTermination(10L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                WebRTCClient.this.peerConnection.removeStream(WebRTCClient.this.mediaStream);
                if (WebRTCClient.this.adaptStreamScheduledFuture != null) {
                    WebRTCClient.this.adaptStreamScheduledFuture.cancel(false);
                    WebRTCClient.this.adaptStreamScheduledFuture = null;
                }
                logger.info("Disposing peerconnection objects");
                if (WebRTCClient.this.audioSource != null) {
                    logger.info("Disposing audio source");
                    WebRTCClient.this.audioSource.dispose();
                    WebRTCClient.this.audioSource = null;
                }
                if (WebRTCClient.this.videoSource != null) {
                    logger.info("Disposing video source");
                    WebRTCClient.this.videoSource.dispose();
                    WebRTCClient.this.videoSource = null;
                }
                if (WebRTCClient.this.peerConnection != null) {
                    logger.info("Closing peer connection: " + (Object)((Object)WebRTCClient.this.peerConnection.iceConnectionState()));
                    WebRTCClient.this.peerConnection.close();
                    logger.info("Disposing peer connection");
                    WebRTCClient.this.peerConnection.dispose();
                    WebRTCClient.this.peerConnection = null;
                }
                if (WebRTCClient.this.factory != null) {
                    logger.info("Closing peer connection factory ");
                    WebRTCClient.this.factory.dispose();
                    WebRTCClient.this.factory = null;
                }
            }
        });
        this.executor.shutdown();
    }
}

