/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server;

import com.brsanthu.googleanalytics.GoogleAnalytics;
import com.brsanthu.googleanalytics.request.EventHit;
import com.brsanthu.googleanalytics.request.ScreenViewHit;
import io.antmedia.Version;
import io.antmedia.rest.BroadcastRestService;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import org.bytedeco.javacpp.avformat;
import org.red5.logging.Red5LoggerFactory;
import org.red5.server.api.Red5;
import org.slf4j.Logger;
import org.slf4j.bridge.SLF4JBridgeHandler;
import org.springframework.context.support.FileSystemXmlApplicationContext;

public class Launcher {
    private GoogleAnalytics ga;
    private String instanceId;

    public void launch() throws Exception {
        avformat.av_register_all();
        avformat.avformat_network_init();
        System.out.printf("Root: %s%nDeploy type: %s%n", System.getProperty("red5.root"), System.getProperty("red5.deployment.type"));
        boolean useLogback = Boolean.valueOf(System.getProperty("useLogback", "true"));
        if (useLogback && System.getProperty("logback.ContextSelector") == null) {
            System.setProperty("logback.ContextSelector", "org.red5.logging.LoggingContextSelector");
        }
        Red5LoggerFactory.setUseLogback((boolean)useLogback);
        SLF4JBridgeHandler.install();
        Logger log = Red5LoggerFactory.getLogger(Launcher.class);
        String implementationVersion = Version.class.getPackage().getImplementationVersion();
        String type = BroadcastRestService.isEnterprise() ? "Enterprise" : "Community";
        log.info("Ant Media Server {} {}", (Object)type, (Object)implementationVersion);
        if (log.isDebugEnabled()) {
            log.debug("fmsVer: {}", (Object)Red5.getFMSVersion());
        }
        FileSystemXmlApplicationContext root = new FileSystemXmlApplicationContext(new String[]{"classpath:/red5.xml"}, false);
        root.setClassLoader(Thread.currentThread().getContextClassLoader());
        root.setId("red5.root");
        root.setBeanName("red5.root");
        String path = System.getProperty("red5.root");
        File idFile = new File(path + "/conf/instanceId");
        this.instanceId = null;
        if (idFile.exists()) {
            this.instanceId = this.getFileContent(idFile.getAbsolutePath());
        } else {
            this.instanceId = UUID.randomUUID().toString();
            this.writeToFile(idFile.getAbsolutePath(), this.instanceId);
        }
        this.ga = GoogleAnalytics.builder().withAppVersion(implementationVersion).withAppName(type).withTrackingId("UA-93263926-3").build();
        Timer heartbeat = new Timer("heartbeat", true);
        heartbeat.schedule(new TimerTask(){

            @Override
            public void run() {
                ((ScreenViewHit)((ScreenViewHit)Launcher.this.ga.screenView().sessionControl("start")).clientId(Launcher.this.instanceId)).send();
            }
        }, 0L);
        heartbeat.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                ((EventHit)Launcher.this.ga.event().eventCategory("server_status").eventAction("heartbeat").eventLabel("").clientId(Launcher.this.instanceId)).send();
            }
        }, 300000L, 300000L);
        log.trace("Refreshing root server context");
        root.refresh();
        log.trace("Root server context refreshed");
        log.debug("Launcher exit");
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                ((ScreenViewHit)((ScreenViewHit)Launcher.this.ga.screenView().clientId(Launcher.this.instanceId)).sessionControl("end")).send();
            }
        });
    }

    public void writeToFile(String absolutePath, String content) {
        try {
            Files.write(new File(absolutePath).toPath(), content.getBytes(), StandardOpenOption.CREATE);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String getFileContent(String path) {
        try {
            byte[] data = Files.readAllBytes(new File(path).toPath());
            return new String(data);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

