/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import java.util.LinkedList;
import org.webrtc.AudioSink;
import org.webrtc.MediaStreamTrack;

public class AudioTrack
extends MediaStreamTrack {
    private final LinkedList<AudioSink> audioSinks = new LinkedList();

    public AudioTrack(long nativeTrack) {
        super(nativeTrack);
    }

    public void addSink(AudioSink renderer) {
        this.audioSinks.add(renderer);
        AudioTrack.nativeAddSink(this.nativeTrack, renderer.nativeAudioSink);
    }

    public void removeSink(AudioSink renderer) {
        if (!this.audioSinks.remove(renderer)) {
            return;
        }
        AudioTrack.nativeRemoveSink(this.nativeTrack, renderer.nativeAudioSink);
        renderer.dispose();
    }

    @Override
    public void dispose() {
        while (!this.audioSinks.isEmpty()) {
            this.removeSink(this.audioSinks.getFirst());
        }
        super.dispose();
    }

    private static native void free(long var0);

    private static native void nativeAddSink(long var0, long var2);

    private static native void nativeRemoveSink(long var0, long var2);
}

