/*
 * Decompiled with CFR 0.152.
 */
package com.antstreaming.rtsp;

import com.antstreaming.rtsp.IMuxerListener;
import com.antstreaming.rtsp.RtspConnection;
import java.util.concurrent.atomic.AtomicBoolean;
import org.bytedeco.javacpp.PointerPointer;
import org.bytedeco.javacpp.avcodec;
import org.bytedeco.javacpp.avformat;
import org.bytedeco.javacpp.avutil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PacketSenderRunnable
implements Runnable {
    avcodec.AVPacket pkt = new avcodec.AVPacket();
    int packetIndex = 0;
    long packetSentTime = 0L;
    long firstPacketSentTime = 0L;
    long startTime = 0L;
    boolean bufferFree = true;
    boolean endOfFile = false;
    private AtomicBoolean isRunning = new AtomicBoolean(false);
    private avformat.AVFormatContext inputFormatContext;
    private avformat.AVFormatContext[] outputFormatContext;
    private static Logger logger = LoggerFactory.getLogger(PacketSenderRunnable.class);
    private boolean closeRequest = false;
    private boolean finish;
    private String rtmpUrl;
    private IMuxerListener muxerListener;
    private avutil.AVRational[] streamTimeBase;

    public PacketSenderRunnable(IMuxerListener muxerListener) {
        this.muxerListener = muxerListener;
    }

    public int seek(long seekTime) {
        return avformat.av_seek_frame((avformat.AVFormatContext)this.inputFormatContext, (int)-1, (long)seekTime, (int)8);
    }

    public long getDuration() {
        return this.inputFormatContext.duration();
    }

    public boolean prepare_output_context(int streamId, String remoteAddress, int[] clientPort, int[] serverPort) {
        if (this.outputFormatContext == null) {
            this.outputFormatContext = new avformat.AVFormatContext[this.inputFormatContext.nb_streams()];
        }
        this.outputFormatContext[streamId] = new avformat.AVFormatContext(null);
        int ret = avformat.avformat_alloc_output_context2((avformat.AVFormatContext)this.outputFormatContext[streamId], null, (String)"rtp", null);
        if (ret < 0) {
            logger.debug("Could not create output context\n");
            return false;
        }
        avformat.AVOutputFormat ofmt = this.outputFormatContext[streamId].oformat();
        avformat.AVStream in_stream = this.inputFormatContext.streams(streamId);
        avformat.AVStream out_stream = avformat.avformat_new_stream((avformat.AVFormatContext)this.outputFormatContext[streamId], (avcodec.AVCodec)in_stream.codec().codec());
        this.streamTimeBase[streamId] = in_stream.time_base();
        ret = avcodec.avcodec_parameters_copy((avcodec.AVCodecParameters)out_stream.codecpar(), (avcodec.AVCodecParameters)in_stream.codecpar());
        if (ret < 0) {
            logger.warn("Failed to copy context from input to output stream codec context\n");
            return false;
        }
        out_stream.codec().codec_tag(0);
        if ((this.outputFormatContext[streamId].oformat().flags() & 0x40) != 0) {
            out_stream.codec().flags(out_stream.codec().flags() | 0x400000);
        }
        if ((ofmt.flags() & 1) == 0) {
            avformat.AVIOContext pb = new avformat.AVIOContext(null);
            String rtpUrl = null;
            if (serverPort[0] == 0) {
                while (RtspConnection.PORT_NUMBER.get() <= 65000) {
                    serverPort[0] = RtspConnection.PORT_NUMBER.getAndAdd(2);
                    serverPort[1] = serverPort[0] + 1;
                    rtpUrl = "rtp://" + remoteAddress + ":" + clientPort[0] + "?localrtpport=" + serverPort[0];
                    ret = avformat.avio_open((avformat.AVIOContext)pb, (String)rtpUrl, (int)2);
                    if (ret < 0) {
                        logger.debug("Could not open url " + rtpUrl);
                        continue;
                    }
                    logger.warn("Opened url " + rtpUrl);
                    this.outputFormatContext[streamId].pb(pb);
                    break;
                }
                if (RtspConnection.PORT_NUMBER.get() >= 65000) {
                    RtspConnection.PORT_NUMBER.set(5000);
                }
            } else {
                rtpUrl = "rtp://" + remoteAddress + ":" + clientPort[0] + "?localrtpport=" + serverPort[0];
                ret = avformat.avio_open((avformat.AVIOContext)pb, (String)rtpUrl, (int)2);
                if (ret < 0) {
                    logger.debug("Could not open url returning " + rtpUrl);
                    return false;
                }
                this.outputFormatContext[streamId].pb(pb);
            }
        }
        if ((ret = avformat.avformat_write_header((avformat.AVFormatContext)this.outputFormatContext[streamId], (PointerPointer)null)) < 0) {
            logger.warn("cannot write header with error: " + ret);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        block19: {
            if (this.isRunning.compareAndSet(false, true) == false) return;
            if (this.inputFormatContext == null) {
                return;
            }
            var1_1 = this;
            // MONITORENTER : var1_1
            if (!this.bufferFree) ** GOTO lbl46
            ret = avformat.av_read_frame((avformat.AVFormatContext)this.inputFormatContext, (avcodec.AVPacket)this.pkt);
            if (ret < 0) {
                data = new byte[4096];
                avutil.av_strerror((int)ret, (byte[])data, (long)data.length);
                PacketSenderRunnable.logger.warn("cannot read frame, closing muxer. Error: " + new String(data));
                this.closeMuxer(true);
                // MONITOREXIT : var1_1
                return;
            }
            ** try [egrp 3[TRYBLOCK] [6 : 131->156)] { 
lbl-1000:
            // 1 sources

            {
                this.packetIndex = this.pkt.stream_index();
                if (this.outputFormatContext[this.packetIndex] != null) break block19;
                // MONITOREXIT : var1_1
                this.isRunning.compareAndSet(true, false);
            }
            return;
        }
        try {
            out_stream = this.outputFormatContext[this.packetIndex].streams(0);
            inStreamTimeBase = this.streamTimeBase[this.packetIndex];
            avRational = new avutil.AVRational();
            avRational.num(1);
            avRational.den(1000000);
            this.packetSentTime = avutil.av_rescale_q((long)this.pkt.dts(), (avutil.AVRational)inStreamTimeBase, (avutil.AVRational)avRational);
            if (this.firstPacketSentTime == 0L) {
                this.firstPacketSentTime = this.packetSentTime;
            }
            this.pkt.pts(avutil.av_rescale_q_rnd((long)this.pkt.pts(), (avutil.AVRational)inStreamTimeBase, (avutil.AVRational)out_stream.time_base(), (int)8197));
            this.pkt.dts(avutil.av_rescale_q_rnd((long)this.pkt.dts(), (avutil.AVRational)inStreamTimeBase, (avutil.AVRational)out_stream.time_base(), (int)8197));
            this.pkt.duration(avutil.av_rescale_q((long)this.pkt.duration(), (avutil.AVRational)inStreamTimeBase, (avutil.AVRational)out_stream.time_base()));
            this.pkt.pos(-1L);
            this.pkt.stream_index(0);
lbl46:
            // 2 sources

            if (this.startTime == 0L) {
                this.startTime = System.currentTimeMillis();
            }
            if (this.packetSentTime <= this.firstPacketSentTime + (timeDiff = (System.currentTimeMillis() - this.startTime) * 1000L)) {
                ret = avformat.av_write_frame((avformat.AVFormatContext)this.outputFormatContext[this.packetIndex], (avcodec.AVPacket)this.pkt);
                if (ret < 0) {
                    PacketSenderRunnable.logger.warn("Error muxing packet with error: " + ret);
                }
                avcodec.av_packet_unref((avcodec.AVPacket)this.pkt);
                this.bufferFree = true;
            } else {
                this.bufferFree = false;
            }
            if (this.closeRequest) {
                this.closeInternal(this.finish);
                this.closeRequest = false;
            }
            // MONITOREXIT : var1_1
            this.isRunning.compareAndSet(true, false);
        }
lbl63:
        // 3 sources

        catch (Exception e) {
            PacketSenderRunnable.logger.warn("exception");
            e.printStackTrace();
            return;
        }
        catch (Throwable var8_10) {
            throw var8_10;
        }
        finally {
            this.isRunning.compareAndSet(true, false);
        }
        return;
    }

    public void closeInternal(boolean finishProcess) {
        logger.warn("closeInternal called.");
        if (this.outputFormatContext != null) {
            for (avformat.AVFormatContext avFormatContext : this.outputFormatContext) {
                if (avFormatContext == null) continue;
                logger.warn("close internal av_write_trailer(avFormatContext);");
                avformat.av_write_trailer((avformat.AVFormatContext)avFormatContext);
                if (avFormatContext != null && (avFormatContext.oformat().flags() & 1) == 0) {
                    logger.warn(" avio_closep(avFormatContext.pb()); ");
                    avformat.avio_closep((avformat.AVIOContext)avFormatContext.pb());
                }
                avformat.avformat_free_context((avformat.AVFormatContext)avFormatContext);
                avFormatContext = null;
            }
            this.outputFormatContext = null;
        }
        if (this.inputFormatContext != null && finishProcess) {
            avformat.avformat_close_input((avformat.AVFormatContext)this.inputFormatContext);
            this.inputFormatContext = null;
        }
        if (this.muxerListener != null) {
            this.muxerListener.muxingFinished(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeMuxer(boolean finishProcess) {
        PacketSenderRunnable packetSenderRunnable = this;
        synchronized (packetSenderRunnable) {
            logger.warn("close muxer called with finish process: " + finishProcess);
            this.closeRequest = true;
            this.finish = finishProcess;
            this.closeInternal(finishProcess);
            this.closeRequest = false;
        }
    }

    public int getStreamCount() {
        return this.inputFormatContext.nb_streams();
    }

    public String getSdpDescription(String rtmpUrl) {
        return this.getSdpDescription(rtmpUrl, true);
    }

    public String getSdpDescription(String rtmpUrl, boolean createSDP) {
        this.rtmpUrl = rtmpUrl;
        this.inputFormatContext = avformat.avformat_alloc_context();
        int ret = avformat.avformat_open_input((avformat.AVFormatContext)this.inputFormatContext, (String)rtmpUrl, null, null);
        if (ret < 0) {
            byte[] data = new byte[4096];
            avutil.av_strerror((int)ret, (byte[])data, (long)data.length);
            logger.warn("could not open input " + rtmpUrl + " error code:" + ret + " description: " + new String(data));
            return null;
        }
        if (createSDP) {
            ret = avformat.avformat_find_stream_info((avformat.AVFormatContext)this.inputFormatContext, (PointerPointer)null);
            if (ret < 0) {
                byte[] data = new byte[4096];
                avutil.av_strerror((int)ret, (byte[])data, (long)data.length);
                logger.warn("could not find stream info " + rtmpUrl + " error code:" + ret + " description: " + new String(data));
                return null;
            }
            byte[] sdpData = new byte[16384];
            ret = avformat.av_sdp_create((avformat.AVFormatContext)this.inputFormatContext, (int)1, (byte[])sdpData, (int)2048);
            if (ret < 0) {
                byte[] data = new byte[4096];
                avutil.av_strerror((int)ret, (byte[])data, (long)data.length);
                logger.warn("could not create sdp " + rtmpUrl + " error code:" + ret + " description: " + new String(data));
                return null;
            }
            String sdpString = new String(sdpData);
            if (sdpString.indexOf("rtpmap") == -1) {
                logger.warn("sdp description does not have rtpmap field");
                return null;
            }
            this.streamTimeBase = new avutil.AVRational[this.inputFormatContext.nb_streams()];
            return sdpString.trim();
        }
        return null;
    }

    public void reinitialize() {
        if (this.inputFormatContext != null) {
            avformat.avformat_close_input((avformat.AVFormatContext)this.inputFormatContext);
            this.inputFormatContext = null;
        }
        this.getSdpDescription(this.rtmpUrl, false);
    }
}

