/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia;

import io.antmedia.AppSettings;
import io.antmedia.datastore.db.IDataStore;
import io.antmedia.datastore.db.types.Broadcast;
import io.antmedia.datastore.db.types.Endpoint;
import io.antmedia.muxer.IMuxerListener;
import io.antmedia.rest.BroadcastRestService;
import io.antmedia.social.endpoint.VideoServiceEndpoint;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.red5.server.adapter.MultiThreadedApplicationAdapter;
import org.red5.server.api.scheduling.IScheduledJob;
import org.red5.server.api.scheduling.ISchedulingService;
import org.red5.server.api.scope.IScope;
import org.red5.server.api.stream.IBroadcastStream;
import org.red5.server.api.stream.IStreamPublishSecurity;

public class AntMediaApplicationAdapter
extends MultiThreadedApplicationAdapter
implements IMuxerListener {
    public static final String BROADCAST_STATUS_CREATED = "created";
    public static final String BROADCAST_STATUS_BROADCASTING = "broadcasting";
    public static final String BROADCAST_STATUS_FINISHED = "finished";
    public static final String HOOK_ACTION_END_LIVE_STREAM = "liveStreamEnded";
    public static final String HOOK_ACTION_START_LIVE_STREAM = "liveStreamStarted";
    public static final String HOOK_ACTION_VOD_READY = "vodReady";
    private List<VideoServiceEndpoint> videoServiceEndpoints;
    private List<IStreamPublishSecurity> streamPublishSecurityList;
    private IDataStore dataStore;
    private AppSettings appSettings;

    public IDataStore getDataStore() {
        return this.dataStore;
    }

    public void setDataStore(IDataStore dataStore) {
        this.dataStore = dataStore;
    }

    @Override
    public boolean appStart(IScope app) {
        if (this.getStreamPublishSecurityList() != null) {
            for (IStreamPublishSecurity streamPublishSecurity : this.getStreamPublishSecurityList()) {
                this.registerStreamPublishSecurity(streamPublishSecurity);
            }
        }
        return super.appStart(app);
    }

    @Override
    public void streamBroadcastClose(IBroadcastStream stream) {
        try {
            String streamName = stream.getPublishedName();
            if (this.dataStore != null) {
                this.dataStore.updateStatus(streamName, BROADCAST_STATUS_FINISHED);
                Broadcast broadcast = this.dataStore.get(streamName);
                if (broadcast != null) {
                    List endPointList;
                    final String listenerHookURL = broadcast.getListenerHookURL();
                    final String streamId = broadcast.getStreamId();
                    if (listenerHookURL != null && listenerHookURL.length() > 0) {
                        final String name = broadcast.getName();
                        final String category = broadcast.getCategory();
                        this.addScheduledOnceJob(100L, new IScheduledJob(){

                            public void execute(ISchedulingService service) throws CloneNotSupportedException {
                                AntMediaApplicationAdapter.this.notifyHook(listenerHookURL, streamId, AntMediaApplicationAdapter.HOOK_ACTION_END_LIVE_STREAM, name, category, null);
                            }
                        });
                    }
                    if ((endPointList = broadcast.getEndPointList()) != null) {
                        for (Endpoint endpoint : endPointList) {
                            VideoServiceEndpoint videoServiceEndPoint = this.getVideoServiceEndPoint(stream, endpoint.type);
                            if (videoServiceEndPoint == null) continue;
                            try {
                                videoServiceEndPoint.stopBroadcast(endpoint);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    }
                    if (endPointList != null) {
                        this.recreateEndpointsForSocialMedia(broadcast, endPointList);
                    }
                    if (broadcast.isZombi()) {
                        this.dataStore.delete(streamName);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        super.streamBroadcastClose(stream);
    }

    public void recreateEndpointsForSocialMedia(Broadcast broadcast, List<Endpoint> endPointList) {
        for (Endpoint endpoint : endPointList) {
            VideoServiceEndpoint videoServiceEndPoint;
            if (endpoint.type == null || endpoint.type.equals("") || (videoServiceEndPoint = this.getVideoServiceEndPoint(null, endpoint.type)) == null) continue;
            try {
                Endpoint newEndpoint = videoServiceEndPoint.createBroadcast(broadcast.getName(), broadcast.getDescription(), broadcast.isIs360(), broadcast.isPublicStream(), 720);
                this.getDataStore().removeEndpoint(broadcast.getStreamId(), endpoint);
                this.getDataStore().addEndpoint(broadcast.getStreamId(), newEndpoint);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void streamPublishStart(final IBroadcastStream stream) {
        this.addScheduledOnceJob(0L, new IScheduledJob(){

            public void execute(ISchedulingService service) throws CloneNotSupportedException {
                String streamName = stream.getPublishedName();
                try {
                    if (AntMediaApplicationAdapter.this.dataStore != null) {
                        List endPointList;
                        Broadcast broadcast = AntMediaApplicationAdapter.this.dataStore.get(streamName);
                        if (broadcast == null) {
                            broadcast = AntMediaApplicationAdapter.this.saveZombiBroadcast(streamName);
                        } else {
                            AntMediaApplicationAdapter.this.dataStore.updateStatus(streamName, AntMediaApplicationAdapter.BROADCAST_STATUS_BROADCASTING);
                        }
                        final String listenerHookURL = broadcast.getListenerHookURL();
                        final String streamId = broadcast.getStreamId();
                        if (listenerHookURL != null && listenerHookURL.length() > 0) {
                            final String name = broadcast.getName();
                            final String category = broadcast.getCategory();
                            AntMediaApplicationAdapter.this.addScheduledOnceJob(100L, new IScheduledJob(){

                                public void execute(ISchedulingService service) throws CloneNotSupportedException {
                                    AntMediaApplicationAdapter.this.notifyHook(listenerHookURL, streamId, AntMediaApplicationAdapter.HOOK_ACTION_START_LIVE_STREAM, name, category, null);
                                }
                            });
                        }
                        if ((endPointList = broadcast.getEndPointList()) != null) {
                            for (Endpoint endpoint : endPointList) {
                                VideoServiceEndpoint videoServiceEndPoint = AntMediaApplicationAdapter.this.getVideoServiceEndPoint(stream, endpoint.type);
                                if (videoServiceEndPoint == null) continue;
                                try {
                                    videoServiceEndPoint.publishBroadcast(endpoint);
                                    AntMediaApplicationAdapter.this.log.info("publish broadcast called for " + videoServiceEndPoint.getName());
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                            }
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        super.streamPublishStart(stream);
    }

    private Broadcast saveZombiBroadcast(String streamName) {
        Broadcast newBroadcast = new Broadcast();
        newBroadcast.setDate(Long.valueOf(System.currentTimeMillis()));
        newBroadcast.setZombi(true);
        try {
            newBroadcast.setStreamId(streamName);
            return BroadcastRestService.saveBroadcast(newBroadcast, BROADCAST_STATUS_BROADCASTING, this.getScope().getName(), this.dataStore, this.appSettings);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    protected VideoServiceEndpoint getVideoServiceEndPoint(IBroadcastStream stream, String type) {
        if (this.videoServiceEndpoints != null) {
            for (VideoServiceEndpoint serviceEndpoint : this.videoServiceEndpoints) {
                if (!serviceEndpoint.getName().equals(type)) continue;
                return serviceEndpoint;
            }
        }
        return null;
    }

    public void muxingFinished(final String streamId, File file, long duration) {
        int index;
        String regularExp;
        String name = file.getName();
        if (this.dataStore != null && !name.matches(regularExp = "^.*_{1}[0-9]{3}p{1}\\.mp4{1}$") && (index = name.lastIndexOf(".mp4")) != -1) {
            String listenerHookURL;
            final String baseName = name.substring(0, index);
            this.dataStore.updateDuration(streamId, duration);
            Broadcast broadcast = this.dataStore.get(streamId);
            if (broadcast != null && (listenerHookURL = broadcast.getListenerHookURL()) != null && listenerHookURL.length() > 0) {
                this.addScheduledOnceJob(100L, new IScheduledJob(){

                    public void execute(ISchedulingService service) throws CloneNotSupportedException {
                        AntMediaApplicationAdapter.this.notifyHook(listenerHookURL, streamId, AntMediaApplicationAdapter.HOOK_ACTION_VOD_READY, null, null, baseName);
                    }
                });
            }
        }
    }

    public void startDeviceAuthStatusPolling(VideoServiceEndpoint videoServiceEndpoint, VideoServiceEndpoint.DeviceAuthParameters askDeviceAuthParameters) {
        int timeDelta = askDeviceAuthParameters.interval * 1000;
        this.addScheduledOnceJob(timeDelta, (IScheduledJob)new AuthCheckJob(0, timeDelta, videoServiceEndpoint));
    }

    public List<VideoServiceEndpoint> getVideoServiceEndpoints() {
        return this.videoServiceEndpoints;
    }

    public void setVideoServiceEndpoints(List<VideoServiceEndpoint> videoServiceEndpoints) {
        this.videoServiceEndpoints = videoServiceEndpoints;
    }

    public StringBuffer notifyHook(String url, String id, String action, String streamName, String category, String vodName) {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("id", id);
        variables.put("action", action);
        if (streamName != null) {
            variables.put("streamName", streamName);
        }
        if (category != null) {
            variables.put("category", category);
        }
        if (vodName != null) {
            variables.put("vodName", vodName);
        }
        StringBuffer response = null;
        try {
            response = AntMediaApplicationAdapter.sendPOST(url, variables);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return response;
    }

    public static StringBuffer sendPOST(String url, Map<String, String> variables) throws IOException {
        String inputLine;
        CloseableHttpClient httpClient = HttpClients.createDefault();
        HttpPost httpPost = new HttpPost(url);
        httpPost.addHeader("User-Agent", "Daaavuuuuuttttt https://www.youtube.com/watch?v=cbyTDRgW4Jg");
        ArrayList<BasicNameValuePair> urlParameters = new ArrayList<BasicNameValuePair>();
        Set<Map.Entry<String, String>> entrySet = variables.entrySet();
        for (Map.Entry<String, String> entry : entrySet) {
            urlParameters.add(new BasicNameValuePair(entry.getKey(), entry.getValue()));
        }
        UrlEncodedFormEntity postParams = new UrlEncodedFormEntity(urlParameters);
        httpPost.setEntity((HttpEntity)postParams);
        CloseableHttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpPost);
        System.out.println("POST Response Status:: " + httpResponse.getStatusLine().getStatusCode());
        BufferedReader reader = new BufferedReader(new InputStreamReader(httpResponse.getEntity().getContent()));
        StringBuffer response = new StringBuffer();
        while ((inputLine = reader.readLine()) != null) {
            response.append(inputLine);
        }
        reader.close();
        httpClient.close();
        return response;
    }

    public List<IStreamPublishSecurity> getStreamPublishSecurityList() {
        return this.streamPublishSecurityList;
    }

    public void setStreamPublishSecurityList(List<IStreamPublishSecurity> streamPublishSecurityList) {
        this.streamPublishSecurityList = streamPublishSecurityList;
    }

    public AppSettings getAppSettings() {
        return this.appSettings;
    }

    public void setAppSettings(AppSettings appSettings) {
        this.appSettings = appSettings;
    }

    private static class AuthCheckJob
    implements IScheduledJob {
        private int count;
        private VideoServiceEndpoint videoServiceEndpoint;
        private int interval;

        public AuthCheckJob(int count, int interval, VideoServiceEndpoint videoServiceEndpoint) {
            this.count = count;
            this.videoServiceEndpoint = videoServiceEndpoint;
            this.interval = interval;
        }

        public void execute(ISchedulingService service) throws CloneNotSupportedException {
            try {
                if (!this.videoServiceEndpoint.askIfDeviceAuthenticated()) {
                    ++this.count;
                    if (this.count < 10) {
                        service.addScheduledOnceJob((long)this.interval, (IScheduledJob)new AuthCheckJob(this.count, this.interval, this.videoServiceEndpoint));
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

