/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.datastore.preference;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import javax.servlet.ServletContext;
import org.springframework.web.context.ServletContextAware;

public class PreferenceStore
implements ServletContextAware {
    private String fileName;
    private Properties prop;
    private String fullPath;

    public PreferenceStore(String fileName) {
        this.fileName = fileName;
    }

    public void put(String key, String value) {
        Properties properties = this.getProperties();
        properties.put(key, value);
    }

    public String get(String key) {
        Properties properties = this.getProperties();
        return properties.getProperty(key);
    }

    public void remove(String key) {
        this.getProperties().remove(key);
    }

    private Properties getProperties() {
        if (this.prop == null) {
            this.prop = new Properties();
            FileInputStream input = null;
            try {
                input = new FileInputStream(this.fullPath);
                this.prop.load(input);
            }
            catch (Exception e) {
            }
            finally {
                if (input != null) {
                    try {
                        input.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return this.prop;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean save() {
        boolean result = false;
        if (this.prop != null) {
            FileOutputStream output = null;
            try {
                output = new FileOutputStream(this.fullPath);
                this.prop.store(output, null);
                result = true;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (output != null) {
                    try {
                        output.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return result;
    }

    public void setServletContext(ServletContext servletContext) {
        this.fullPath = servletContext.getRealPath(this.fileName);
    }

    public void setFullPath(String fullpath) {
        this.fullPath = fullpath;
    }
}

