/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.social.endpoint;

import io.antmedia.datastore.db.types.Endpoint;
import io.antmedia.datastore.db.types.SocialEndpointChannel;
import io.antmedia.datastore.preference.PreferenceStore;
import java.util.List;

public abstract class VideoServiceEndpoint {
    protected static final String AUTH_TIME = ".authTime";
    protected static final String EXPIRE_TIME_SECONDS = ".expireTimeSeconds";
    protected static final String REFRESH_TOKEN = ".refreshToken";
    protected static final String ACCESS_TOKEN = ".accessToken";
    protected static final String TOKEN_TYPE = ".tokenType";
    public static final Long THREE_DAYS_IN_MS = 259200000L;
    protected String clientId;
    protected String clientSecret;
    protected PreferenceStore dataStore;

    public VideoServiceEndpoint(String clientId, String clientSecret, PreferenceStore dataStore) {
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.dataStore = dataStore;
    }

    public void start() {
        String accessToken = this.dataStore.get(this.getName() + ACCESS_TOKEN);
        String refreshToken = this.dataStore.get(this.getName() + REFRESH_TOKEN);
        String expireTimeSeconds = this.dataStore.get(this.getName() + EXPIRE_TIME_SECONDS);
        String tokenType = this.dataStore.get(this.getName() + TOKEN_TYPE);
        String authtimeMilliSeconds = this.dataStore.get(this.getName() + AUTH_TIME);
        long expireTime = 0L;
        long authTime = 0L;
        if (expireTimeSeconds != null) {
            expireTime = Long.valueOf(expireTimeSeconds);
        }
        if (authtimeMilliSeconds != null) {
            authTime = Long.valueOf(authtimeMilliSeconds);
        }
        try {
            this.init(accessToken, refreshToken, expireTime, tokenType, authTime);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public abstract void init(String var1, String var2, long var3, String var5, long var6);

    public void saveCredentials(String accessToken, String refreshToken, String expireTimeInSeconds, String token_type) {
        if (refreshToken != null) {
            this.dataStore.put(this.getName() + REFRESH_TOKEN, refreshToken);
        }
        if (accessToken != null) {
            this.dataStore.put(this.getName() + ACCESS_TOKEN, accessToken);
        }
        if (expireTimeInSeconds != null) {
            this.dataStore.put(this.getName() + EXPIRE_TIME_SECONDS, expireTimeInSeconds);
        }
        if (token_type != null) {
            this.dataStore.put(this.getName() + TOKEN_TYPE, token_type);
        }
        this.dataStore.put(this.getName() + AUTH_TIME, String.valueOf(System.currentTimeMillis()));
        this.dataStore.save();
    }

    public void resetCredentials() {
        this.dataStore.put(this.getName() + REFRESH_TOKEN, "");
        this.dataStore.put(this.getName() + ACCESS_TOKEN, "");
        this.dataStore.put(this.getName() + EXPIRE_TIME_SECONDS, "0");
        this.dataStore.put(this.getName() + TOKEN_TYPE, "");
        this.dataStore.save();
    }

    public abstract String getName();

    public abstract DeviceAuthParameters askDeviceAuthParameters() throws Exception;

    public abstract boolean askIfDeviceAuthenticated() throws Exception;

    public abstract boolean isAuthenticated();

    public abstract Endpoint createBroadcast(String var1, String var2, boolean var3, boolean var4, int var5) throws Exception;

    public abstract void publishBroadcast(Endpoint var1) throws Exception;

    public abstract void stopBroadcast(Endpoint var1) throws Exception;

    protected String getClientId() {
        return this.clientId;
    }

    protected void setClientId(String clientId) {
        this.clientId = clientId;
    }

    protected String getClientSecret() {
        return this.clientSecret;
    }

    protected void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public boolean isInitialized() {
        return this.clientId != null && this.clientSecret != null && this.clientId.length() > 0 && this.clientSecret.length() > 0;
    }

    public SocialEndpointChannel getChannel() {
        return null;
    }

    public List<SocialEndpointChannel> getChannelList(String type) {
        return null;
    }

    public boolean setActiveChannel(String type, String id) {
        return false;
    }

    public static class DeviceAuthParameters {
        public String device_code;
        public String user_code;
        public String verification_url;
        public int expires_in;
        public int interval;
    }
}

