/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.webrtc.adaptor;

import java.io.UnsupportedEncodingException;
import org.json.simple.JSONObject;
import org.red5.logging.Red5LoggerFactory;
import org.red5.net.websocket.WebSocketConnection;
import org.slf4j.Logger;
import org.webrtc.DataChannel;
import org.webrtc.IceCandidate;
import org.webrtc.MediaConstraints;
import org.webrtc.MediaStream;
import org.webrtc.PeerConnection;
import org.webrtc.PeerConnectionFactory;
import org.webrtc.RtpReceiver;
import org.webrtc.SdpObserver;
import org.webrtc.SessionDescription;

public abstract class Adaptor
implements PeerConnection.Observer,
SdpObserver {
    protected PeerConnection peerConnection;
    private WebSocketConnection wsConnection;
    private MediaConstraints sdpMediaConstraints;
    protected PeerConnectionFactory peerConnectionFactory;
    protected static final Logger log = Red5LoggerFactory.getLogger(Adaptor.class);

    public abstract void start();

    public abstract void stop();

    public void setPeerConnection(PeerConnection peerConnection) {
        this.peerConnection = peerConnection;
    }

    public PeerConnection getPeerConnection() {
        return this.peerConnection;
    }

    public WebSocketConnection getWsConnection() {
        return this.wsConnection;
    }

    public void setWsConnection(WebSocketConnection wsConnection) {
        this.wsConnection = wsConnection;
    }

    @Override
    public void onSignalingChange(PeerConnection.SignalingState newState) {
    }

    @Override
    public void onIceConnectionChange(PeerConnection.IceConnectionState newState) {
        if (newState == PeerConnection.IceConnectionState.DISCONNECTED || newState == PeerConnection.IceConnectionState.FAILED || newState == PeerConnection.IceConnectionState.CLOSED) {
            this.stop();
        }
    }

    @Override
    public void onIceConnectionReceivingChange(boolean receiving) {
    }

    @Override
    public void onIceGatheringChange(PeerConnection.IceGatheringState newState) {
    }

    @Override
    public void onIceCandidate(IceCandidate candidate) {
        log.warn("onIceCandidate");
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)"command", (Object)"takeCandidate");
        jsonObject.put((Object)"label", (Object)candidate.sdpMLineIndex);
        jsonObject.put((Object)"id", (Object)candidate.sdpMid);
        jsonObject.put((Object)"candidate", (Object)candidate.sdp);
        try {
            this.wsConnection.send(jsonObject.toJSONString());
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onIceCandidatesRemoved(IceCandidate[] candidates) {
    }

    @Override
    public void onAddStream(MediaStream stream) {
    }

    @Override
    public void onRemoveStream(MediaStream stream) {
    }

    @Override
    public void onDataChannel(DataChannel dataChannel) {
    }

    @Override
    public void onRenegotiationNeeded() {
    }

    @Override
    public void onAddTrack(RtpReceiver receiver, MediaStream[] mediaStreams) {
    }

    @Override
    public void onCreateSuccess(SessionDescription sdp) {
        log.warn("onCreate Success");
        this.peerConnection.setLocalDescription(new SdpObserver(){

            @Override
            public void onSetSuccess() {
            }

            @Override
            public void onSetFailure(String error) {
            }

            @Override
            public void onCreateSuccess(SessionDescription sdp) {
            }

            @Override
            public void onCreateFailure(String error) {
            }
        }, sdp);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)"command", (Object)"takeConfiguration");
        jsonObject.put((Object)"sdp", (Object)sdp.description);
        String type = sdp.type == SessionDescription.Type.ANSWER ? "answer" : "offer";
        jsonObject.put((Object)"type", (Object)type);
        try {
            this.wsConnection.send(jsonObject.toJSONString());
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onSetSuccess() {
        log.warn("on setSuccess");
    }

    @Override
    public void onCreateFailure(String error) {
        log.warn(error);
    }

    @Override
    public void onSetFailure(String error) {
        log.warn(error);
    }

    public MediaConstraints getSdpMediaConstraints() {
        return this.sdpMediaConstraints;
    }

    public void setSdpMediaConstraints(MediaConstraints sdpMediaConstraints) {
        this.sdpMediaConstraints = sdpMediaConstraints;
    }

    public void setPeerConnectionFactory(PeerConnectionFactory peerConnectionFactory) {
        this.peerConnectionFactory = peerConnectionFactory;
    }
}

